/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.admin.servermgmt.RepositoryManager;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CLITokenizer;
import com.sun.enterprise.cli.framework.CliUtil;
import com.sun.enterprise.cli.framework.Command;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.InputsAndOutputs;
import com.sun.enterprise.deployment.client.ServerConnectionIdentifier;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public abstract class S1ASCommand
extends Command {
    public static final String JMX_PROTOCOL = "jmxmp";
    public static final String TERSE = "terse";
    public static final String INTERACTIVE = "interactive";
    public static final String PASSWORDFILE = "passwordfile";
    public static final String ECHO = "echo";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String SECURE = "secure";
    public static final String MAPPED_PASSWORD = "mappedpassword";
    public static final String OBJECT_NAME = "objectname";
    public static final String ARGUMENTS = "arguments";
    public static final String OPERATION = "operation";
    public static final String PARAMS = "params";
    public static final String PARAM_TYPES = "paramtypes";
    public static final String RETURN_TYPE = "returntype";
    public static final String DISPLAY_TYPE = "displaytype";
    public static final String ATTRIBUTE_LIST_CLASS = AttributeList.class.getName();
    public static final String PROPERTIES_CLASS = Properties.class.getName();
    public static final String BOOLEAN_CLASS = Boolean.class.getName();
    public static final String PRIMITIVE_BOOLEAN_CLASS = Boolean.TYPE.getName();
    public static final String STRING_ARRAY = new String[0].getClass().getName();
    public static final String PARAM_DELIMITER = ",";
    public static final String PARAM_VALUE_DELIMITER = "=";
    public static final String PROPERTY_DELIMITER = ":";
    private static final String ASADMINPREFS = ".asadminprefs";
    protected static final String SHORTHAND_DELIMETER = ":";
    protected static final char ESCAPE_CHAR = '\\';
    protected static final String SET_DELIMETER = "=";
    private static final String ENV_PREFIX = "AS_ADMIN_";
    protected static String NOT_DEPRECATED_PASSWORDFILE_OPTIONS = "password|adminpassword|userpassword|masterpassword|aliaspassword|mappedpassword";
    public static final String LIST_JMS_RESOURCES = "list-jms-resources";
    private String userValue = null;
    private boolean warningDisplayed = false;

    public boolean validateOptions() throws CommandValidationException {
        this.setLoggerLevel();
        if (this.getBooleanOption(ECHO)) {
            CLILogger.getInstance().printMessage(this.toString());
        }
        return true;
    }

    protected void setLoggerLevel() {
        boolean terse = this.getBooleanOption(TERSE);
        if (terse) {
            CLILogger.getInstance().setOutputLevel(Level.INFO);
        } else {
            CLILogger.getInstance().setOutputLevel(Level.FINE);
        }
    }

    protected MBeanServerConnection getMBeanServerConnection(String protocol, String host, int port, String user, String password) throws CommandException {
        JMXServiceURL url = this.getJMXServiceURL(protocol, host, port);
        try {
            JMXConnector jmxc = JMXConnectorFactory.connect(url);
            CLILogger.getInstance().printDebugMessage("Get an MBeanSErverConnection");
            return jmxc.getMBeanServerConnection();
        }
        catch (IOException ioe) {
            throw new CommandException(ioe);
        }
    }

    private JMXServiceURL getJMXServiceURL(String protocol, String host, int port) throws CommandException {
        try {
            CLILogger.getInstance().printDebugMessage("Create a JMXMP connector client and connect it to the JMXMP connector server");
            JMXServiceURL url = new JMXServiceURL(protocol, host, port);
            CLILogger.getInstance().printDebugMessage("url = " + url.toString());
            return url;
        }
        catch (MalformedURLException mue) {
            throw new CommandException(mue);
        }
    }

    protected MBeanServerConnection getMBeanServerConnection(String host, int port, String user, String password) throws CommandException, CommandValidationException {
        try {
            String jmxProtocol = null;
            jmxProtocol = this.getBooleanOption(SECURE) ? "s1ashttps" : "s1ashttp";
            JMXServiceURL url = new JMXServiceURL(jmxProtocol, host, port);
            JMXConnector conn = JMXConnectorFactory.connect(url, this.initEnvironment(user, password));
            return conn.getMBeanServerConnection();
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
    }

    protected ServerConnectionIdentifier createServerConnectionIdentifier(String host, int port, String user, String password) throws CommandException, CommandValidationException {
        ServerConnectionIdentifier conn = new ServerConnectionIdentifier();
        conn.setHostName(host);
        conn.setHostPort(port);
        conn.setUserName(user);
        conn.setPassword(password);
        if (this.getBooleanOption(SECURE)) {
            conn.setSecure(true);
        } else {
            conn.setSecure(false);
        }
        return conn;
    }

    private Map initEnvironment(String user, String password) throws CommandValidationException, CommandException {
        HashMap<String, Object> env = new HashMap<String, Object>();
        String PKGS = "com.sun.enterprise.admin.jmx.remote.protocol";
        env.put("jmx.remote.protocol.provider.class.loader", this.getClass().getClassLoader());
        env.put("jmx.remote.protocol.provider.pkgs", "com.sun.enterprise.admin.jmx.remote.protocol");
        env.put("USER", user);
        env.put("PASSWORD", password);
        env.put("com.sun.enterprise.as.http.auth", "BASIC");
        return env;
    }

    protected String getHost() {
        return this.getOption(HOST);
    }

    protected int getPort() throws CommandException {
        String port = this.getOption(PORT);
        try {
            int portInt = 0;
            portInt = Integer.parseInt(port);
            return portInt;
        }
        catch (Exception e) {
            throw new CommandException(this.getLocalizedString("InvalidPortNumber", new Object[]{port}), e);
        }
    }

    protected String getUser() throws CommandValidationException {
        if (this.getOption(USER) == null && this.userValue == null) {
            this.userValue = this.getValuesFromASADMINPREFS(USER);
            if (this.userValue != null) {
                return this.userValue;
            }
        } else {
            if (this.getOption(USER) != null) {
                return this.getOption(USER);
            }
            if (this.userValue != null) {
                return this.userValue;
            }
        }
        throw new CommandValidationException(this.getLocalizedString("OptionIsRequired", new Object[]{USER}));
    }

    protected String getValuesFromASADMINPREFS(String nameOfValue) {
        String returnVal = null;
        BufferedReader reader = null;
        try {
            File file = this.checkForFileExistence(System.getProperty("user.home"), ASADMINPREFS);
            reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            while (line != null && returnVal == null) {
                String[] nameAndValue;
                if (line.regionMatches(true, 0, ENV_PREFIX, 0, ENV_PREFIX.length()) && (nameAndValue = this.splitNameValuePairs(line))[0].equalsIgnoreCase(nameOfValue)) {
                    returnVal = nameAndValue[1];
                }
                line = reader.readLine();
            }
            reader.close();
            return returnVal;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String[] splitNameValuePairs(String nameValuePairs) {
        String tempStr = nameValuePairs.substring(ENV_PREFIX.length());
        return tempStr.split("=");
    }

    protected String getPassword() throws CommandValidationException, CommandException {
        return this.getPassword(PASSWORD, true, true, false, false, null, null, true, false, false, true);
    }

    protected boolean isPasswordValid(String passwd) {
        return passwd.length() >= 8;
    }

    protected String getPassword(String optionName, boolean allowedOnCommandLine, boolean readPrefsFile, boolean readPasswordOptionFromPrefs, boolean readMasterPasswordFile, RepositoryManager mgr, RepositoryConfig config, boolean promptUser, boolean confirm, boolean validate, boolean displayWarning) throws CommandValidationException, CommandException {
        return this.getPassword(optionName, "InteractiveOptionPrompt", "InteractiveOptionConfirmationPrompt", allowedOnCommandLine, readPrefsFile, readPasswordOptionFromPrefs, readMasterPasswordFile, mgr, config, promptUser, confirm, validate, displayWarning);
    }

    protected String getPassword(String optionName, String promptMsg, String confirmationPromptMsg, boolean allowedOnCommandLine, boolean readPrefsFile, boolean readPasswordOptionFromPrefs, boolean readMasterPasswordFile, RepositoryManager mgr, RepositoryConfig config, boolean promptUser, boolean confirm, boolean validate, boolean displayWarning) throws CommandValidationException, CommandException {
        String passwordVal;
        if (this.getOption(optionName) == null) {
            if (this.getOption(PASSWORDFILE) != null) {
                this.loadPasswordFileOptions(optionName);
            }
        } else {
            if (!allowedOnCommandLine) {
                throw new CommandValidationException(this.getLocalizedString("PasswordNotAllowedOnCommandLine", new Object[]{optionName}));
            }
            if (displayWarning) {
                CLILogger.getInstance().printDetailMessage(this.getLocalizedString("PasswordWarning", new Object[]{optionName}));
            }
        }
        if ((passwordVal = this.getOption(optionName)) == null) {
            if (readPrefsFile) {
                passwordVal = this.getValuesFromASADMINPREFS(optionName);
            }
            if (passwordVal == null) {
                if (readPrefsFile && readPasswordOptionFromPrefs) {
                    passwordVal = this.getValuesFromASADMINPREFS(PASSWORD);
                }
                if (passwordVal == null) {
                    if (readMasterPasswordFile && mgr != null && config != null) {
                        try {
                            passwordVal = mgr.readMasterPasswordFile(config);
                        }
                        catch (RepositoryException ex) {
                            throw new CommandException(ex);
                        }
                    }
                    if (passwordVal == null && promptUser) {
                        passwordVal = confirm ? this.getInteractiveOptionWithConfirmation(optionName, this.getLocalizedString(promptMsg, new Object[]{optionName}), this.getLocalizedString(confirmationPromptMsg, new Object[]{optionName}), validate) : this.getInteractiveOption(optionName, this.getLocalizedString(promptMsg, new Object[]{optionName}));
                    }
                }
            }
        }
        if (validate && passwordVal != null && !this.isPasswordValid(passwordVal)) {
            throw new CommandValidationException(this.getLocalizedString("PasswordLimit", new Object[]{optionName}));
        }
        return passwordVal;
    }

    private String getInteractiveOptionWithConfirmation(String optionName, String prompt, String confirmationPrompt, boolean validatePassword) throws CommandValidationException {
        String optionValue = this.getInteractiveOption(optionName, prompt);
        if (validatePassword && !this.isPasswordValid(optionValue)) {
            throw new CommandValidationException(this.getLocalizedString("PasswordLimit", new Object[]{optionName}));
        }
        String optionValueAgain = this.getInteractiveOption(optionName, confirmationPrompt);
        if (!optionValue.equals(optionValueAgain)) {
            throw new CommandValidationException(this.getLocalizedString("OptionsDoNotMatch", new Object[]{optionName}));
        }
        return optionValue;
    }

    protected String getInteractiveOption(String optionName, String prompt) throws CommandValidationException {
        String optionValue = this.getOption(optionName);
        if (optionValue == null && this.getBooleanOption(INTERACTIVE)) {
            try {
                InputsAndOutputs.getInstance().getUserOutput().print(prompt);
                optionValue = new CliUtil().getPassword();
            }
            catch (NoClassDefFoundError e) {
                optionValue = this.readInput();
            }
            catch (UnsatisfiedLinkError e) {
                optionValue = this.readInput();
            }
            catch (Exception e) {
                throw new CommandValidationException(e);
            }
        } else if (optionValue == null && !this.getBooleanOption(INTERACTIVE)) {
            throw new CommandValidationException(this.getLocalizedString("OptionIsRequired", new Object[]{optionName}));
        }
        return optionValue;
    }

    private String readInput() {
        try {
            return InputsAndOutputs.getInstance().getUserInput().getLine();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private void loadPasswordFileOptions(String optionName) throws CommandException {
        try {
            String passwordFileName = this.getOption(PASSWORDFILE);
            File file = this.checkForFileExistence(null, passwordFileName);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            boolean displayWarning = false;
            while (line != null) {
                if (line.length() > 0) {
                    displayWarning = displayWarning || this.checkPasswordFileOptions(line, optionName);
                }
                line = reader.readLine();
            }
            reader.close();
            if (displayWarning && !this.warningDisplayed) {
                CLILogger.getInstance().printWarning(this.getLocalizedString("DeprecatedOptionsFromPasswordfile"));
                this.warningDisplayed = true;
            }
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
    }

    private boolean checkPasswordFileOptions(String line, String optionName) {
        if (line.regionMatches(true, 0, ENV_PREFIX, 0, ENV_PREFIX.length())) {
            String[] envNameAndValue = this.splitNameValuePairs(line);
            if (optionName == null || optionName.equalsIgnoreCase(envNameAndValue[0])) {
                if (this.getOption(optionName) == null && envNameAndValue.length > 1) {
                    this.setOption(optionName, envNameAndValue[1]);
                }
                return !optionName.matches(NOT_DEPRECATED_PASSWORDFILE_OPTIONS);
            }
            return false;
        }
        return true;
    }

    protected File checkForFileExistence(String parent, String fileName) throws CommandException {
        if (fileName == null) {
            return null;
        }
        File file = null;
        file = parent == null ? new File(fileName) : new File(parent, fileName);
        if (!file.canRead()) {
            throw new CommandException(this.getLocalizedString("FileDoesNotExist", new Object[]{fileName}));
        }
        return file;
    }

    protected String getObjectName() throws CommandException {
        String objectName = (String)((Vector)this.getProperty(OBJECT_NAME)).get(0);
        String objectNameStr = this.replacePattern(objectName);
        CLILogger.getInstance().printDebugMessage("Object Name = [" + objectNameStr + "]");
        return objectNameStr;
    }

    protected Object[] getParamsInfo() throws CommandException, CommandValidationException {
        Object[] paramsInfo;
        Vector params = (Vector)this.getProperty(PARAMS);
        String[] typesInfo = this.getTypesInfo();
        Object[] objectArray = paramsInfo = params == null ? null : new Object[params.size()];
        if (typesInfo != null && paramsInfo != null && paramsInfo.length != typesInfo.length) {
            throw new CommandException(this.getLocalizedString("BadDescriptorXML"));
        }
        for (int i = 0; params != null && i < params.size(); ++i) {
            String paramStr = (String)params.get(i);
            CLILogger.getInstance().printDebugMessage("Types Info [" + i + "] = " + typesInfo[i]);
            CLILogger.getInstance().printDebugMessage("ATTRIBUTE_LIST_CLASS = " + ATTRIBUTE_LIST_CLASS);
            if (typesInfo[i].equals(ATTRIBUTE_LIST_CLASS)) {
                paramsInfo[i] = this.getAttributeList(paramStr);
                continue;
            }
            if (typesInfo[i].equals(PROPERTIES_CLASS)) {
                paramsInfo[i] = this.createPropertiesParam((String)params.get(i));
                continue;
            }
            if (typesInfo[i].equals(BOOLEAN_CLASS) || typesInfo[i].equals(PRIMITIVE_BOOLEAN_CLASS)) {
                if (this.createBooleanVal((String)params.get(i)) == null) continue;
                paramsInfo[i] = this.createBooleanVal((String)params.get(i));
                continue;
            }
            if (typesInfo[i].equals(STRING_ARRAY)) {
                CLILogger.getInstance().printDebugMessage("Creating String Array");
                paramsInfo[i] = this.createStringArrayParam((String)params.get(i));
                continue;
            }
            CLILogger.getInstance().printDebugMessage((String)params.get(i));
            paramsInfo[i] = this.replacePattern((String)params.get(i));
            CLILogger.getInstance().printDebugMessage("ParamsInfo = " + paramsInfo[i]);
        }
        return paramsInfo;
    }

    protected String[] getTypesInfo() {
        Vector typesList = (Vector)this.getProperty(PARAM_TYPES);
        String[] types = typesList == null ? null : new String[typesList.size()];
        CLILogger.getInstance().printDebugMessage("Types = ");
        for (int i = 0; typesList != null && i < typesList.size(); ++i) {
            types[i] = (String)typesList.get(i);
            CLILogger.getInstance().printDebugMessage(types[i] + PARAM_DELIMITER);
        }
        CLILogger.getInstance().printDebugMessage("");
        return types;
    }

    protected String getOperationName() throws CommandException {
        String operationName = (String)((Vector)this.getProperty(OPERATION)).get(0);
        String operationNameStr = this.replacePattern(operationName);
        CLILogger.getInstance().printDebugMessage("OperationName = " + operationNameStr);
        return operationNameStr;
    }

    protected String getReturnType() {
        String returnType = (String)((Vector)this.getProperty(RETURN_TYPE)).get(0);
        CLILogger.getInstance().printDebugMessage("ReturnType = " + returnType);
        return returnType;
    }

    private AttributeList getAttributeList(String paramStr) throws CommandException {
        AttributeList attrList = new AttributeList();
        StringTokenizer paramsTokenizer = new StringTokenizer(paramStr, PARAM_DELIMITER);
        int size = paramsTokenizer.countTokens();
        for (int i = 0; i < size; ++i) {
            String nameValue = paramsTokenizer.nextToken();
            String nameValueStr = this.replacePattern(nameValue);
            if (nameValueStr == null) continue;
            int index = this.getDelimeterIndex(nameValueStr, "=", 0);
            String attrName = nameValueStr.substring(0, index);
            String attrValue = nameValueStr.substring(index + 1);
            if (attrValue.length() <= 0) continue;
            CLILogger.getInstance().printDebugMessage("**Attr Name = " + attrName + ", Value = " + attrValue);
            attrList.add(new Attribute(attrName, attrValue));
        }
        return attrList;
    }

    private Properties createPropertiesParam(String propertyVal) throws CommandException, CommandValidationException {
        String propertyStr = this.replacePattern(propertyVal);
        if (propertyStr == null) {
            return null;
        }
        Properties properties = new Properties();
        CLITokenizer propertyTok = new CLITokenizer(propertyStr, ":");
        while (propertyTok.hasMoreTokens()) {
            String nameAndvalue = propertyTok.nextToken();
            CLITokenizer nameTok = new CLITokenizer(nameAndvalue, "=");
            if (nameTok.countTokens() == 2) {
                properties.setProperty(nameTok.nextTokenWithoutEscapeAndQuoteChars(), nameTok.nextTokenWithoutEscapeAndQuoteChars());
                continue;
            }
            throw new CommandValidationException(this.getLocalizedString("InvalidPropertySyntax"));
        }
        return properties;
    }

    private Boolean createBooleanVal(String booleanVal) throws CommandException {
        String booleanStr = this.replacePattern(booleanVal);
        return Boolean.valueOf(booleanStr);
    }

    private String[] createStringArrayParam(String str) throws CommandException {
        String strArrayVal = this.replacePattern(str);
        CLILogger.getInstance().printDebugMessage("strArrayVal value = \"" + strArrayVal + "\"");
        if (strArrayVal == null || strArrayVal.equals("") || strArrayVal.equals("null")) {
            return null;
        }
        CLITokenizer cliTokenizer = new CLITokenizer(strArrayVal, ":");
        String[] strArray = new String[cliTokenizer.countTokens()];
        int ii = 0;
        while (cliTokenizer.hasMoreTokens()) {
            strArray[ii++] = cliTokenizer.nextTokenWithoutEscapeAndQuoteChars();
        }
        return strArray;
    }

    protected void handleReturnValue(Object returnval) {
        block7: {
            if (returnval == null) {
                return;
            }
            Class<?> cl = returnval.getClass();
            if (!cl.isArray()) break block7;
            if (cl == new ObjectName[0].getClass()) {
                ObjectName[] objs = (ObjectName[])returnval;
                if (objs.length == 0) {
                    CLILogger.getInstance().printDetailMessage(this.getLocalizedString("NoElementsToList"));
                    return;
                }
                String displayType = (String)((Vector)this.getProperty(DISPLAY_TYPE)).get(0);
                for (int ii = 0; ii < objs.length; ++ii) {
                    ObjectName objectName = objs[ii];
                    CLILogger.getInstance().printDebugMessage("ObjectName = " + objectName);
                    CLILogger.getInstance().printMessage(objectName.getKeyProperty(displayType));
                }
            } else {
                Object[] objs = (Object[])returnval;
                if (objs.length == 0) {
                    CLILogger.getInstance().printDetailMessage(this.getLocalizedString("NoElementsToList"));
                    return;
                }
                for (int ii = 0; ii < objs.length; ++ii) {
                    CLILogger.getInstance().printMessage(objs[ii].toString());
                }
            }
        }
    }
}

