/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.admin.common.JMXFileTransfer;
import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.deployapi.SunDeploymentPlan;
import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.deployment.archivist.FileArchive;
import com.sun.enterprise.deployment.archivist.InputJarArchive;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.util.DescriptorLoader;
import com.sun.enterprise.webservice.ClientWsdlPublisher;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Properties;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class OldDeployCommand
extends S1ASCommand {
    private static final String TARGET_OPTION = "target";
    private static final String CONTEXT_ROOT_OPTION = "contextroot";
    private static final String FORCE_OPTION = "force";
    private static final String PRECOMPILE_JSP_OPTION = "precompilejsp";
    private static final String VERIFY_OPTION = "verify";
    private static final String UPLOAD_OPTION = "upload";
    private static final String ENABLED_OPTION = "enabled";
    private static final String COMPONENT_NAME = "name";
    private static final String RETRIEVE_DIR = "retrieve";
    private static final String VIRTUALSERVERS_OPTION = "virtualservers";
    private static final String DB_VENDOR_NAME_OPTION = "dbvendorname";
    private static final String CREATE_TABLES_OPTION = "createtables";
    private static final String DROP_AND_CREATE_TABLES_OPTION = "dropandcreatetables";
    private static final String UNIQUE_TABLENAMES_OPTION = "uniquetablenames";
    private static final String DEPLOYMENTPLAN_OPTION = "deploymentplan";
    private static final String AVAILABILITY_ENABLED_OPTION = "availabilityenabled";
    private static final String GENERATE_RMI_STUBS_OPTION = "generatermistubs";
    private static final String DEPLOY_DIR = "deploydir";
    private String filePath = null;
    private String serverFilePath = null;
    private boolean isUpload = false;
    private String componentName = null;

    public void runCommand() throws CommandException, CommandValidationException {
        String retrievePath;
        DeploymentStatus status;
        this.validateOptions();
        this.validateFilePathAndUpload();
        ObjectName objectName = this.constructObjectName();
        MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
        if (System.getProperty("Debug") != null) {
            this.debugDeployCommand(mbsc, objectName);
        }
        DescriptorLoader descriptorLoader = new DescriptorLoader();
        descriptorLoader.setArchivePath(this.filePath);
        descriptorLoader.start();
        this.createArchiveForDeployment();
        if (this.isUpload) {
            this.serverFilePath = this.uploadFileToServer(mbsc);
        }
        Properties props = this.createDeploymentProperties();
        Object[] params = new Object[]{props};
        String[] signature = new String[]{Properties.class.getName()};
        try {
            status = (DeploymentStatus)mbsc.invoke(objectName, "deploy", params, signature);
        }
        catch (Exception e) {
            if (e.getLocalizedMessage() != null) {
                CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            }
            throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), e);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bos);
        DeploymentStatus.parseDeploymentStatus((DeploymentStatus)status, (PrintWriter)pw);
        byte[] statusBytes = bos.toByteArray();
        String statusString = new String(statusBytes);
        if (status != null && status.getStatus() == 0) {
            this.checkDeployStatus(status, statusString);
        }
        if ((retrievePath = this.getOption(RETRIEVE_DIR)) != null) {
            try {
                this.getClientStub(mbsc, retrievePath);
            }
            catch (CommandException e) {
                throw new CommandException(this.getLocalizedString("InvalidValueInOption", new Object[]{RETRIEVE_DIR, retrievePath}) + "\n" + e.getLocalizedMessage());
            }
        }
        this.retrieveWsdlFiles(mbsc, this.filePath, descriptorLoader);
        if (status != null && status.getStatus() == 1) {
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessfulWithMsg", new Object[]{this.name, statusString}));
        } else {
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
    }

    private void checkDeployStatus(DeploymentStatus status, String statusString) throws CommandException {
        if (status != null && status.getStatus() == 0) {
            Iterator subStagesIter = status.getSubStages();
            int ii = 0;
            while (subStagesIter.hasNext()) {
                DeploymentStatus subStage = (DeploymentStatus)subStagesIter.next();
                CLILogger.getInstance().printDebugMessage("ii=" + ii + " subStage.toString()=" + subStage.toString());
                if (ii == 0 && subStage.getStatus() == 0) {
                    throw new CommandException(this.getLocalizedString("CommandUnSuccessfulWithMsg", new Object[]{this.name, statusString}));
                }
                if (ii > 0 && subStage.getStatus() == 0) {
                    CLILogger.getInstance().printWarning(this.getLocalizedString("ApplicationDeployedButNotLoaded", new Object[]{statusString}));
                }
                ++ii;
            }
            throw new CommandException(this.getLocalizedString("CommandUnSuccessfulWithMsg", new Object[]{this.name, statusString}));
        }
    }

    private void retrieveWsdlFiles(MBeanServerConnection mbsc, String srcModulePath, DescriptorLoader dl) throws CommandException {
        try {
            ClientWsdlPublisher publisher = new ClientWsdlPublisher();
            dl.join();
            publisher.retrieveWsdlFiles(mbsc, this.componentName, srcModulePath, dl.getApplication());
            CLILogger.getInstance().printDebugMessage("published wsdl files for  : " + srcModulePath);
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
    }

    public boolean validateOptions() throws CommandValidationException {
        super.validateOptions();
        if (this.getOption(CREATE_TABLES_OPTION) != null && this.getOption(DROP_AND_CREATE_TABLES_OPTION) != null) {
            throw new CommandValidationException(this.getLocalizedString("MutuallyExclusiveOption", new Object[]{CREATE_TABLES_OPTION, DROP_AND_CREATE_TABLES_OPTION}));
        }
        this.filePath = (String)this.getOperands().get(0);
        this.isUpload = this.getOption(UPLOAD_OPTION) == null ? false : this.getBooleanOption(UPLOAD_OPTION);
        this.componentName = this.getComponentName();
        return true;
    }

    private String uploadFileToServer(MBeanServerConnection mbsc) throws CommandException {
        try {
            String file = new JMXFileTransfer(mbsc).uploadFile(this.filePath);
            return file;
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
    }

    private ObjectName constructObjectName() throws CommandValidationException {
        try {
            return new ObjectName(this.getObjectName());
        }
        catch (Exception e) {
            throw new CommandValidationException(e);
        }
    }

    private Properties createDeploymentProperties() {
        String virtualServers = this.getOption(VIRTUALSERVERS_OPTION);
        String contextRoot = this.getContextRoot();
        String dbVendorName = this.getOption(DB_VENDOR_NAME_OPTION);
        String createTable = this.getOption(CREATE_TABLES_OPTION);
        String dropCreateTable = this.getOption(DROP_AND_CREATE_TABLES_OPTION);
        String uniqueTableNames = this.getOption(UNIQUE_TABLENAMES_OPTION);
        String target = this.getOption(TARGET_OPTION);
        Properties props = new Properties();
        if (props != null) {
            props.setProperty(TARGET_OPTION, target);
        }
        if (this.serverFilePath != null && this.isUpload) {
            props.setProperty("archiveName", this.serverFilePath);
        } else if (this.filePath != null) {
            props.setProperty("archiveName", this.filePath);
        }
        if (contextRoot != null) {
            props.setProperty("contextRoot", contextRoot);
        }
        if (virtualServers != null) {
            props.setProperty(VIRTUALSERVERS_OPTION, virtualServers);
        }
        if (dbVendorName != null) {
            props.setProperty("CmpInfo.dbVendorName", dbVendorName);
        }
        if (createTable != null) {
            props.setProperty("CmpInfo.CREATE_TABLES", createTable);
        }
        if (dropCreateTable != null) {
            props.setProperty("CmpInfo.DROP_AND_CREATE_TABLES", dropCreateTable);
        }
        if (uniqueTableNames != null) {
            props.setProperty("CmpInfo.uniqueTableNames", uniqueTableNames);
        }
        props.setProperty(COMPONENT_NAME, this.componentName);
        props.setProperty(VERIFY_OPTION, this.getOption(VERIFY_OPTION));
        props.setProperty(PRECOMPILE_JSP_OPTION, this.getOption(PRECOMPILE_JSP_OPTION));
        props.setProperty("enable", this.getOption(ENABLED_OPTION));
        props.setProperty(FORCE_OPTION, this.getOption(FORCE_OPTION));
        props.setProperty(AVAILABILITY_ENABLED_OPTION, this.getOption(AVAILABILITY_ENABLED_OPTION));
        props.setProperty(GENERATE_RMI_STUBS_OPTION, this.getOption(GENERATE_RMI_STUBS_OPTION));
        boolean isDirectoryDeployed = this.name.compareTo(DEPLOY_DIR) == 0;
        props.setProperty("directorydeployed", new Boolean(isDirectoryDeployed).toString());
        String retrievePath = this.getOption(RETRIEVE_DIR);
        if (retrievePath != null) {
            props.setProperty("clientJarRequested", "true");
        }
        return props;
    }

    private void validateFilePathAndUpload() throws CommandException {
        if (!new File(this.filePath).isFile() && this.isUpload) {
            throw new CommandException(this.getLocalizedString("FileNotFoundOnLocalMachine", new Object[]{this.filePath}));
        }
    }

    private String getContextRoot() {
        String contextRoot = this.getOption(CONTEXT_ROOT_OPTION);
        return contextRoot;
    }

    private String getComponentName() throws CommandValidationException {
        String name = this.getOption(COMPONENT_NAME);
        if (name == null) {
            name = this.getNameFromFilePath();
        }
        if (name == null || name.equals("")) {
            throw new CommandValidationException(this.getLocalizedString("ComponentNameNull"));
        }
        return name;
    }

    private String getNameFromFilePath() {
        String fileNameOperand = (String)this.getOperands().get(0);
        String fileName = new File(fileNameOperand).getName();
        int toIndex = fileName.lastIndexOf(46);
        if (toIndex < 0) {
            toIndex = fileName.length();
        }
        return fileName.substring(0, toIndex);
    }

    private void getClientStub(MBeanServerConnection mbsc, String retrievePath) throws CommandException {
        CLILogger.getInstance().printDebugMessage("componentName = " + this.componentName + " retrievePath = " + retrievePath);
        try {
            String fileName = new JMXFileTransfer(mbsc).downloadClientStubs(this.componentName, retrievePath);
            CLILogger.getInstance().printDebugMessage("downloaded stubs to  : " + fileName);
        }
        catch (FileNotFoundException e) {
            throw new CommandException(this.getLocalizedString("FileDoesNotExist", new Object[]{retrievePath}));
        }
        catch (Exception e) {
            throw new CommandException(e.getLocalizedMessage());
        }
    }

    private void createArchiveForDeployment() throws CommandException {
        block6: {
            String deploymentPlan = this.getOption(DEPLOYMENTPLAN_OPTION);
            if (deploymentPlan != null) {
                File source = new File(this.filePath);
                try {
                    FileArchive earArchive;
                    if (source.isDirectory()) {
                        earArchive = new FileArchive();
                        earArchive.open(this.filePath);
                    } else {
                        earArchive = new InputJarArchive();
                        ((InputJarArchive)earArchive).open(this.filePath);
                    }
                    File inputPlan = new File(deploymentPlan);
                    if (!inputPlan.exists()) {
                        throw new CommandException(this.getLocalizedString("FileNotFoundOnLocalMachine", new Object[]{deploymentPlan}));
                    }
                    BufferedInputStream is = new BufferedInputStream(new FileInputStream(inputPlan));
                    File tmpFile = File.createTempFile("deploy", this.filePath.substring(this.filePath.lastIndexOf(46)));
                    tmpFile.deleteOnExit();
                    SunDeploymentPlan plan = new SunDeploymentPlan();
                    plan.mergeDeploymentPlan((AbstractArchive)earArchive, (InputStream)is, (OutputStream)new BufferedOutputStream(new FileOutputStream(tmpFile)));
                    this.filePath = tmpFile.getAbsolutePath();
                }
                catch (Exception e) {
                    if (e.getLocalizedMessage() == null) break block6;
                    CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
                    throw new CommandException(this.getLocalizedString("CouldNotUseDeploymentPlan", new Object[]{this.name}), e);
                }
            }
        }
    }

    private void debugDeployCommand(MBeanServerConnection mbsc, ObjectName objectName) {
        try {
            Iterator<ObjectName> iterator = mbsc.queryNames(objectName, null).iterator();
            CLILogger.getInstance().printDebugMessage("*********************************************");
            while (iterator.hasNext()) {
                CLILogger.getInstance().printDebugMessage(iterator.next().toString());
            }
            CLILogger.getInstance().printDebugMessage("*********************************************");
            CLILogger.getInstance().printDebugMessage("*************** getMBeanInfo ****************");
            MBeanInfo mbinfo = mbsc.getMBeanInfo(objectName);
            MBeanOperationInfo[] mboinfo = mbinfo.getOperations();
            CLILogger.getInstance().printDebugMessage("*************** getOperations ****************");
            for (int ii = 0; ii < mboinfo.length; ++ii) {
                CLILogger.getInstance().printDebugMessage("Name: " + mboinfo[ii].getName());
                MBeanParameterInfo[] mbpinfo = mboinfo[ii].getSignature();
                for (int jj = 0; jj < mbpinfo.length; ++jj) {
                    CLILogger.getInstance().printDebugMessage("Param[" + jj + "]:  type = " + mbpinfo[jj].getType() + " name = " + mbpinfo[jj].getName());
                }
                CLILogger.getInstance().printDebugMessage("ReturnType: " + mboinfo[ii].getReturnType());
                CLILogger.getInstance().printDebugMessage("*********************************************");
            }
        }
        catch (Exception e) {
            CLILogger.getInstance().printExceptionStackTrace(e);
            CLILogger.getInstance().printDebugMessage(e.getLocalizedMessage());
        }
    }
}

