/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.util.Vector;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class ListComponentsCommand
extends S1ASCommand {
    private static final String TYPE_OPTION = "type";
    private static final String TYPE_OPTION_REG = "application|web|ejb|connector";

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        String objectName = this.getObjectName();
        Object[] params = this.getParamsInfo();
        String operationName = this.getOperationName();
        String[] types = this.getTypesInfo();
        MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
        try {
            if (System.getProperty("Debug") != null) {
                this.printDebug(mbsc, objectName);
            }
            Object returnValue = mbsc.invoke(new ObjectName(objectName), operationName, params, types);
            this.printObjectName(returnValue);
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            if (e.getLocalizedMessage() != null) {
                CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            }
            throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), e);
        }
    }

    private void printObjectName(Object returnValue) throws CommandValidationException {
        if (returnValue == null) {
            return;
        }
        boolean nothingToList = true;
        if (returnValue.getClass() == new ObjectName[0].getClass()) {
            ObjectName[] objs = (ObjectName[])returnValue;
            String displayType = (String)((Vector)this.getProperty("displaytype")).get(0);
            String type = this.getTypeOption();
            for (int ii = 0; ii < objs.length; ++ii) {
                ObjectName objectName = objs[ii];
                CLILogger.getInstance().printDebugMessage("ObjectName = " + objectName);
                String componentType = objectName.getKeyProperty(TYPE_OPTION);
                if (type != null && componentType.indexOf(type) == -1) continue;
                CLILogger.getInstance().printMessage(objectName.getKeyProperty(displayType) + " <" + componentType + "> ");
                nothingToList = false;
            }
        }
        if (nothingToList) {
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("NoElementsToList"));
        }
    }

    private String getTypeOption() throws CommandValidationException {
        String type = this.getOption(TYPE_OPTION);
        if (type == null) {
            return type;
        }
        if (type.matches(TYPE_OPTION_REG)) {
            return type;
        }
        throw new CommandValidationException(this.getLocalizedString("InvalidTypeOption"));
    }

    private void printDebug(MBeanServerConnection mbsc, String objectName) throws Exception {
        CLILogger.getInstance().printDebugMessage("********** getMBeanInfo **********");
        MBeanInfo mbinfo = mbsc.getMBeanInfo(new ObjectName(objectName));
        CLILogger.getInstance().printDebugMessage("Description = " + mbinfo.getDescription());
        CLILogger.getInstance().printDebugMessage("Classname = " + mbinfo.getClassName());
        MBeanOperationInfo[] mboinfo = mbinfo.getOperations();
        for (int ii = 0; ii < mboinfo.length; ++ii) {
            CLILogger.getInstance().printDebugMessage("(" + ii + ") Description = " + mboinfo[ii].getDescription());
            CLILogger.getInstance().printDebugMessage("(" + ii + ") Name = " + mboinfo[ii].getName());
            CLILogger.getInstance().printDebugMessage("****** TYPE *****");
            MBeanParameterInfo[] mbpi = mboinfo[ii].getSignature();
            for (int kk = 0; kk < mbpi.length; ++kk) {
                CLILogger.getInstance().printDebugMessage("type = " + mbpi[kk].getType());
            }
            CLILogger.getInstance().printDebugMessage("returnType = " + mboinfo[ii].getReturnType());
        }
    }
}

