/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.admin.common.JMXFileTransfer;
import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.io.File;
import javax.management.MBeanServerConnection;

public class GetClientStubsCommand
extends S1ASCommand {
    private String downloadDir;
    private String appName;
    public static final String APP_NAME = "appname";

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
        String path = this.getClientStub(mbsc);
        CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
    }

    public boolean validateOptions() throws CommandValidationException {
        super.validateOptions();
        this.downloadDir = (String)this.getOperands().get(0);
        this.validateDirectory();
        this.appName = this.getAppName();
        return true;
    }

    private void validateDirectory() throws CommandValidationException {
        File dlDir = new File(this.downloadDir);
        if (!dlDir.exists()) {
            dlDir.mkdirs();
        }
        if (!(dlDir.exists() && dlDir.canWrite() && dlDir.isDirectory())) {
            throw new CommandValidationException(this.getLocalizedString("InvalidDirectory", new Object[]{this.downloadDir}));
        }
    }

    private String getAppName() throws CommandValidationException {
        String name = this.getOption(APP_NAME);
        return name;
    }

    private String getClientStub(MBeanServerConnection mbsc) throws CommandException {
        try {
            String fileName = new JMXFileTransfer(mbsc).downloadClientStubs(this.appName, this.downloadDir);
            CLILogger.getInstance().printDebugMessage("downloaded from  : " + fileName + " to : " + this.downloadDir);
            return fileName;
        }
        catch (Exception e) {
            Throwable t;
            for (t = e.getCause(); t != null && t.getCause() != null; t = t.getCause()) {
            }
            if (t == null) {
                t = e;
            }
            throw new CommandException(t.getLocalizedMessage(), t);
        }
    }
}

