/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.agent.ws;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.management.Attribute;

public class Utility {
    private static final String STRING = "java:java.lang.String";
    private static final String INTEGER = "java:java.lang.Integer";
    private static final String BOOLEAN = "java:java.lang.Boolean";
    private static final String FLOAT = "java:java.lang.Float";
    private static final String LONG = "java:java.lang.Long";
    private static final String DOUBLE = "java:java.lang.Double";
    private static final String DATE = "date";
    private static final String ARRAYLIST = "java:java.util.ArrayList";

    public static synchronized Attribute createAttribute(String string, String string2, String[] stringArray) {
        if (stringArray.length == 1) {
            return Utility.createSimpleAttribute(string, string2, stringArray[0]);
        }
        return Utility.createComplexAttribute(string, string2, stringArray);
    }

    private static Attribute createSimpleAttribute(String string, String string2, String string3) {
        Object object = Utility.createSimpleJavaObject(string2, string3);
        if (object == null) {
            object = "dummy";
        }
        return new Attribute(string, object);
    }

    private static Object createSimpleJavaObject(String string, String string2) {
        if (string.equals(STRING)) {
            return string2;
        }
        if (string.equals(INTEGER)) {
            return new Integer(string2);
        }
        if (string.equals(BOOLEAN)) {
            return new Boolean(string2);
        }
        if (string.equals(FLOAT)) {
            return new Float(string2);
        }
        if (string.equals(LONG)) {
            return new Long(string2);
        }
        if (string.equals(DOUBLE)) {
            return new Double(string2);
        }
        if (string.equals(DATE)) {
            try {
                return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(string2);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        return null;
    }

    private static Attribute createComplexAttribute(String string, String string2, String[] stringArray) {
        if (string2.equals(ARRAYLIST)) {
            return new Attribute(string, Utility.createArrayList(stringArray));
        }
        return new Attribute(string, "dummy");
    }

    private static ArrayList createArrayList(String[] stringArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < 2; i += 2) {
            arrayList.add(Utility.createSimpleJavaObject(stringArray[i], stringArray[i + 1]));
        }
        return arrayList;
    }
}

