/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.agent.ws;

import java.util.ArrayList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MBeanInfoSaxHandler
extends DefaultHandler {
    private static final int ATTRIBUTE_ELEMENT = 1;
    private static final int OPERATION_ELEMENT = 2;
    private static final int CLASSNAME_ELEMENT = 3;
    private static final int DESCRIPTION_ELEMENT = 4;
    private static final int CONSTRUCTOR_ELEMENT = 5;
    private static final int NOTIFICATION_ELEMENT = 6;
    private static final String ATTRIBUTES = "attributes";
    private static final String OPERATIONS = "operations";
    private static final String CLASSNAME = "class-name";
    private static final String CONSTRUCTORS = "constructors";
    private static final String DESCRIPTION = "description";
    private static final String SIGNATURE = "signature";
    private static final String NOTIFICATIONS = "notifications";
    private static final String NOTIFICATION_TYPES = "notif-types";
    int currentElementParsed = 0;
    private ArrayList attributeInfoList;
    private ArrayList operationInfoList;
    private ArrayList constructorInfoList;
    private ArrayList notificationInfoList;
    private String className;
    private String description;
    private MBeanInfo mBeanInfo;
    private String[] attributeNames = new String[100];
    private String[] attributeValues = new String[100];
    private String[] fieldNames = new String[100];
    private String[] fieldValues = new String[100];
    private int signatureCount;
    private int notificationTypesCount;
    private int attrCount;
    private int fieldCount;

    public MBeanInfo getMBeanInfo() {
        return this.mBeanInfo;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
        try {
            this.buildMBeanInfo();
        }
        catch (Exception exception) {
            throw new SAXException("I/O error", exception);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        if ("".equals(string4)) {
            string4 = string3;
        }
        if (string4.equals(ATTRIBUTES)) {
            this.fieldCount = 0;
            this.attrCount = 0;
            this.signatureCount = 0;
            this.currentElementParsed = 1;
        } else if (string4.equals(OPERATIONS)) {
            this.fieldCount = 0;
            this.attrCount = 0;
            this.signatureCount = 0;
            this.currentElementParsed = 2;
        } else if (string4.equals(CLASSNAME)) {
            this.fieldCount = 0;
            this.attrCount = 0;
            this.signatureCount = 0;
            this.currentElementParsed = 3;
        } else if (string4.equals(DESCRIPTION) && this.currentElementParsed == 3) {
            this.fieldCount = 0;
            this.attrCount = 0;
            this.signatureCount = 0;
            this.currentElementParsed = 4;
        } else if (string4.equals(CONSTRUCTORS)) {
            this.fieldCount = 0;
            this.attrCount = 0;
            this.signatureCount = 0;
            this.currentElementParsed = 5;
        } else if (string4.equals(NOTIFICATIONS)) {
            this.fieldCount = 0;
            this.attrCount = 0;
            this.signatureCount = 0;
            this.notificationTypesCount = 0;
            this.currentElementParsed = 6;
        } else {
            this.fieldNames[this.fieldCount] = string4;
        }
        if (attributes != null) {
            this.attrCount = attributes.getLength();
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string5 = attributes.getLocalName(i);
                if ("".equals(string5)) {
                    string5 = attributes.getQName(i);
                }
                this.attributeNames[i] = string5;
                this.attributeValues[i] = attributes.getValue(i);
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals(ATTRIBUTES)) {
            this.buildAttributeInfo();
        } else if (string3.equals(OPERATIONS)) {
            this.buildOperationInfo();
        } else if (string3.equals(CLASSNAME)) {
            this.buildClassName();
        } else if (string3.equals(DESCRIPTION) && this.currentElementParsed == 4) {
            this.buildDescription();
        } else if (string3.equals(CONSTRUCTORS)) {
            this.buildConstructorInfo();
        } else if (string3.equals(SIGNATURE)) {
            ++this.signatureCount;
        } else if (string3.equals(NOTIFICATION_TYPES)) {
            ++this.notificationTypesCount;
        } else if (string3.equals(NOTIFICATIONS)) {
            this.buildNotificationInfo();
            this.notificationTypesCount = 0;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        this.fieldValues[this.fieldCount++] = string;
    }

    private void buildAttributeInfo() {
        boolean bl = new Boolean(this.attributeValues[0]);
        boolean bl2 = new Boolean(this.attributeValues[1]);
        boolean bl3 = new Boolean(this.attributeValues[2]);
        MBeanAttributeInfo mBeanAttributeInfo = new MBeanAttributeInfo(this.fieldValues[0], this.fieldValues[1], this.fieldValues[2], bl, bl2, bl3);
        if (this.attributeInfoList == null) {
            this.attributeInfoList = new ArrayList();
        }
        this.attributeInfoList.add(mBeanAttributeInfo);
    }

    private void buildOperationInfo() {
        int n = 0;
        try {
            n = new Integer(this.attributeValues[0]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[this.signatureCount];
        int n2 = 0;
        for (int i = 0; i < this.signatureCount; ++i) {
            String string = this.fieldValues[n2++];
            String string2 = this.fieldValues[n2++];
            String string3 = null;
            if (this.fieldNames[n2] != null && this.fieldNames[n2].equals(DESCRIPTION)) {
                string3 = this.fieldValues[n2++];
            }
            mBeanParameterInfoArray[i] = new MBeanParameterInfo(string, string2, string3);
        }
        MBeanOperationInfo mBeanOperationInfo = new MBeanOperationInfo(this.fieldValues[n2], this.fieldValues[n2 + 2], mBeanParameterInfoArray, this.fieldValues[n2 + 1], n);
        if (this.operationInfoList == null) {
            this.operationInfoList = new ArrayList();
        }
        this.operationInfoList.add(mBeanOperationInfo);
    }

    private void buildConstructorInfo() {
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[this.signatureCount];
        int n = 0;
        for (int i = 0; i < this.signatureCount; ++i) {
            String string = this.fieldValues[n++];
            String string2 = this.fieldValues[n++];
            String string3 = null;
            if (this.fieldNames[n] != null && this.fieldNames[n].equals(DESCRIPTION)) {
                string3 = this.fieldValues[n++];
            }
            mBeanParameterInfoArray[i] = new MBeanParameterInfo(string, string2, string3);
        }
        MBeanConstructorInfo mBeanConstructorInfo = new MBeanConstructorInfo(this.fieldValues[n++], this.fieldValues[n++], mBeanParameterInfoArray);
        if (this.constructorInfoList == null) {
            this.constructorInfoList = new ArrayList();
        }
        this.constructorInfoList.add(mBeanConstructorInfo);
    }

    private void buildNotificationInfo() {
        int n;
        String[] stringArray = new String[this.notificationTypesCount];
        for (n = 0; n < this.notificationTypesCount; ++n) {
            stringArray[n] = this.fieldValues[n];
        }
        MBeanNotificationInfo mBeanNotificationInfo = new MBeanNotificationInfo(stringArray, this.fieldValues[n], this.fieldValues[n + 1]);
        if (this.notificationInfoList == null) {
            this.notificationInfoList = new ArrayList();
        }
        this.notificationInfoList.add(mBeanNotificationInfo);
    }

    private void buildClassName() {
        this.className = this.fieldValues[0];
    }

    private void buildDescription() {
        this.description = this.fieldValues[0];
    }

    private void buildMBeanInfo() {
        try {
            MBeanNotificationInfo[] mBeanNotificationInfoArray = this.notificationInfoList != null ? this.notificationInfoList.toArray(new MBeanNotificationInfo[0]) : new MBeanNotificationInfo[]{};
            MBeanAttributeInfo[] mBeanAttributeInfoArray = this.attributeInfoList != null ? this.attributeInfoList.toArray(new MBeanAttributeInfo[0]) : new MBeanAttributeInfo[]{};
            MBeanConstructorInfo[] mBeanConstructorInfoArray = this.constructorInfoList != null ? this.constructorInfoList.toArray(new MBeanConstructorInfo[0]) : new MBeanConstructorInfo[]{};
            MBeanOperationInfo[] mBeanOperationInfoArray = this.operationInfoList != null ? this.operationInfoList.toArray(new MBeanOperationInfo[0]) : new MBeanOperationInfo[]{};
            this.mBeanInfo = new MBeanInfo(this.className, this.description, mBeanAttributeInfoArray, mBeanConstructorInfoArray, mBeanOperationInfoArray, mBeanNotificationInfoArray);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
        }
    }
}

