/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.agent.ws;

import java.io.Serializable;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.ObjectName;

public class LocalNotificationObject
implements Serializable {
    private String type;
    private long sequenceNumber;
    private long timeStamp;
    private Object userData;
    private String message;
    private String sourceObjectName;
    private String mbeanName = null;

    public LocalNotificationObject() {
    }

    public LocalNotificationObject(Notification notification) {
        this.type = notification.getType();
        this.sequenceNumber = notification.getSequenceNumber();
        this.timeStamp = notification.getTimeStamp();
        this.userData = notification.getUserData();
        this.message = notification.getMessage();
        this.sourceObjectName = ((ObjectName)notification.getSource()).toString();
        if (notification instanceof MBeanServerNotification) {
            this.mbeanName = ((MBeanServerNotification)notification).getMBeanName().toString();
        }
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public void setSequenceNumber(long l) {
        this.sequenceNumber = l;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setTimeStamp(long l) {
        this.timeStamp = l;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public String getMessage() {
        return this.message;
    }

    public void setSourceObjectName(String string) {
        this.sourceObjectName = string;
    }

    public String getSourceObjectName() {
        return this.sourceObjectName;
    }

    public void setMBeanName(String string) {
        this.mbeanName = string;
    }

    public String getMBeanName() {
        return this.mbeanName;
    }

    public Notification getNotificationObject() {
        if (this.getMBeanName() != null) {
            try {
                ObjectName objectName = new ObjectName(this.getMBeanName());
                return new MBeanServerNotification(this.type, (Object)this.sourceObjectName, this.sequenceNumber, objectName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Notification(this.type, this.sourceObjectName, this.sequenceNumber, this.timeStamp, this.message);
    }
}

