/*
 * Decompiled with CFR 0.152.
 */
package samples.jms.soaptojms;

import com.sun.messaging.xml.MessageTransformer;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import samples.jms.soaptojms.ServiceLocator;
import samples.jms.soaptojms.ServiceLocatorException;

public class SendSOAPMessageWithJMS {
    TopicConnectionFactory tcf = null;
    TopicConnection tc = null;
    TopicSession session = null;
    Topic topic = null;
    TopicPublisher publisher = null;
    static /* synthetic */ Class class$samples$jms$soaptojms$SendSOAPMessageWithJMS;

    public SendSOAPMessageWithJMS(String string) {
        this.init(string);
    }

    public void init(String string) {
        try {
            ServiceLocator serviceLocator = new ServiceLocator();
            this.tcf = serviceLocator.getTopicConnectionFactory("jms/TopicConnectionFactory");
            this.tc = this.tcf.createTopicConnection();
            this.session = this.tc.createTopicSession(false, 1);
            this.topic = serviceLocator.getTopic(string);
            this.publisher = this.session.createPublisher(this.topic);
        }
        catch (JMSException jMSException) {
            jMSException.printStackTrace();
        }
        catch (ServiceLocatorException serviceLocatorException) {
            serviceLocatorException.printStackTrace();
        }
    }

    public void send() throws Exception {
        MessageFactory messageFactory = MessageFactory.newInstance();
        System.out.println("Create a SOAP message");
        SOAPMessage sOAPMessage = messageFactory.createMessage();
        SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
        SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
        SOAPBody sOAPBody = sOAPEnvelope.getBody();
        Name name = sOAPEnvelope.createName("HelloWorld", "hw", "http://www.sun.com/imq");
        SOAPElement sOAPElement = sOAPBody.addChildElement(name);
        sOAPElement.addTextNode("Welcome to Sun Web Services.");
        URL uRL = this.getUrlFromPropsFile();
        System.out.println("Attaching the file from URL: " + uRL);
        DataHandler dataHandler = new DataHandler(uRL);
        AttachmentPart attachmentPart = sOAPMessage.createAttachmentPart(dataHandler);
        attachmentPart.setContentType("text/html");
        attachmentPart.setContentId("cid-001");
        sOAPMessage.addAttachmentPart(attachmentPart);
        sOAPMessage.saveChanges();
        System.out.println("Convert the message to JMS message");
        Message message = MessageTransformer.SOAPMessageIntoJMSMessage((SOAPMessage)sOAPMessage, (Session)this.session);
        System.out.println("Publish the message");
        this.publisher.publish(message);
    }

    public URL getUrlFromPropsFile() throws Exception {
        InputStream inputStream = (class$samples$jms$soaptojms$SendSOAPMessageWithJMS == null ? (class$samples$jms$soaptojms$SendSOAPMessageWithJMS = SendSOAPMessageWithJMS.class$("samples.jms.soaptojms.SendSOAPMessageWithJMS")) : class$samples$jms$soaptojms$SendSOAPMessageWithJMS).getResourceAsStream("soaptojms.properties");
        Properties properties = new Properties();
        properties.load(inputStream);
        return new URL(properties.getProperty("url"));
    }

    public void close() throws JMSException {
        this.tc.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

