/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.tree;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.TreeModelBase;
import com.iplanet.jato.model.ValidationException;
import com.iplanet.jato.util.StringTokenizer2;
import com.sun.enterprise.tools.admingui.tree.IndexTreeModel;
import com.sun.enterprise.tools.admingui.tree.IndexTreeNode;
import com.sun.enterprise.tools.admingui.tree.NodeNotFoundException;
import com.sun.enterprise.tools.admingui.tree.TreeReader;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.guiframework.view.ViewDescriptorManager;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;

public class TreeModelBaseImpl
extends TreeModelBase
implements IndexTreeModel,
Serializable {
    private String treeFileName;
    private String stateDataName;
    private boolean initialExpand = true;
    private String name;
    private int nodeCount = 0;
    private IndexTreeNode root = null;

    public TreeModelBaseImpl(String treeFileName, String stateDataName) {
        this.treeFileName = treeFileName;
        this.stateDataName = stateDataName;
    }

    public String getStateDataName() {
        return this.stateDataName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public void root() throws ModelControlException {
        if (this.root == null) {
            throw new RuntimeException("The root node is null!!!");
        }
        this.setCurrentNode(this.root);
        this.setNodeLevel(0);
        this.setIterationComplete(false);
    }

    public String getNodeName() throws ModelControlException {
        IndexTreeNode node = (IndexTreeNode)this.getCurrentNode();
        if (node != null) {
            return node.getName();
        }
        return null;
    }

    public String getNodeType() throws ModelControlException {
        IndexTreeNode node = (IndexTreeNode)this.getCurrentNode();
        if (node != null) {
            return node.getType();
        }
        return null;
    }

    public IndexTreeNode getNode(String nodePath) throws NodeNotFoundException {
        if (Util.isLoggableFINEST()) {
            Util.logFINEST("IndexTreeModelImpl.getNode : " + nodePath);
        }
        String[] nodeIDs = StringTokenizer2.tokenize((String)nodePath, (String)".");
        IndexTreeNode node = this.getRoot();
        block0: for (int i = 1; i < nodeIDs.length; ++i) {
            for (int j = 0; j < node.getChildren().size(); ++j) {
                IndexTreeNode child = (IndexTreeNode)node.getChildren().get(j);
                if (!String.valueOf(child.getID()).equals(nodeIDs[i])) continue;
                node = child;
                continue block0;
            }
        }
        if (!node.getPath().equals(nodePath)) {
            throw new NodeNotFoundException("Incorrect node (" + node.getPath() + " != " + nodePath + ")");
        }
        return node;
    }

    public IndexTreeNode getNodeByName(String nodeNamePath) {
        String[] nodeIDs = StringTokenizer2.tokenize((String)nodeNamePath, (String)".");
        IndexTreeNode node = this.getRoot();
        block0: for (int i = 1; i < nodeIDs.length; ++i) {
            for (int j = 0; j < node.getChildren().size(); ++j) {
                IndexTreeNode child = (IndexTreeNode)node.getChildren().get(j);
                if (!String.valueOf(child.getName()).equals(nodeIDs[i])) continue;
                node = child;
                continue block0;
            }
        }
        if (!node.getNamePath().equals(nodeNamePath)) {
            throw new NodeNotFoundException("Incorrect node (" + node.getNamePath() + " != " + nodeNamePath + ")");
        }
        return node;
    }

    public IndexTreeNode getNodeByUniqueID(String id, String childName, IndexTreeNode node) {
        String uniqueID;
        if (node == null) {
            node = this.getRoot();
        }
        if ((uniqueID = node.getUniqueID()) == null) {
            return null;
        }
        List children = node.getChildren();
        if (uniqueID != null && uniqueID.equals(id)) {
            if (childName != null) {
                IndexTreeNode childNode = node.getChild(childName);
                if (childNode != null) {
                    return childNode;
                }
            } else {
                return node;
            }
        }
        for (int i = 0; i < children.size(); ++i) {
            IndexTreeNode child = (IndexTreeNode)children.get(i);
            IndexTreeNode childNode = this.getNodeByUniqueID(id, childName, child);
            if (childNode == null) continue;
            return childNode;
        }
        return null;
    }

    public void beforeRoot() throws ModelControlException {
        this.setCurrentNode(null);
        this.setNodeLevel(-1);
        this.setIterationComplete(false);
    }

    public Object getCurrentNode() {
        return super.getCurrentNode();
    }

    public void setCurrentNode(String nodeID) throws ModelControlException, Exception {
        this.setCurrentNode(this.getNode(nodeID));
    }

    public void setCurrentNode(IndexTreeNode node) {
        super.setCurrentNode((Object)node);
    }

    public String getNodeID() {
        IndexTreeNode node = (IndexTreeNode)this.getCurrentNode();
        if (node != null) {
            return node.getPath();
        }
        return null;
    }

    public String getNodeHID() {
        IndexTreeNode node = (IndexTreeNode)this.getCurrentNode();
        if (node != null) {
            return node.getHighlightID();
        }
        return "0";
    }

    public String getIconName(boolean expanded) {
        IndexTreeNode node = (IndexTreeNode)this.getCurrentNode();
        if (node != null) {
            return node.getIconName(expanded);
        }
        return "props.gif";
    }

    public boolean isParentNode() {
        IndexTreeNode node = (IndexTreeNode)this.getCurrentNode();
        if (node != null) {
            return node.getChildren().size() > 0;
        }
        return false;
    }

    public boolean isChildNode() {
        IndexTreeNode node = (IndexTreeNode)this.getCurrentNode();
        if (node != null) {
            return node.getParent() != null;
        }
        return false;
    }

    public boolean firstChild() throws ModelControlException {
        IndexTreeNode node = (IndexTreeNode)this.getCurrentNode();
        if (node != null && this.isParentNode()) {
            this.setCurrentNode(node.getChildren().get(0));
            this.incrementNodeLevel();
            return true;
        }
        return false;
    }

    public boolean parent() throws ModelControlException {
        IndexTreeNode node = (IndexTreeNode)this.getCurrentNode();
        if (node != null && this.isChildNode()) {
            this.setCurrentNode(node.getParent());
            this.decrementNodeLevel();
            return true;
        }
        return false;
    }

    public boolean nextSibling() throws ModelControlException {
        IndexTreeNode node = (IndexTreeNode)this.getCurrentNode();
        if (node != null) {
            IndexTreeNode nextNode = node.getNextSibling();
            if (nextNode != null) {
                this.setCurrentNode(node.getNextSibling());
                return true;
            }
            return false;
        }
        return false;
    }

    public Object getValue(String name) {
        Object[] values = this.getValues(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public void setValue(String name, Object value) throws ValidationException {
        this.setValues(name, new Object[]{value});
    }

    public Object[] getValues(String name) {
        if (this.getCurrentNode() != null) {
            if (name.equals("name")) {
                return new Object[]{((IndexTreeNode)this.getCurrentNode()).getName()};
            }
            return new Object[]{((IndexTreeNode)this.getCurrentNode()).getAttribute(name)};
        }
        return null;
    }

    public void setValues(String name, Object[] values) throws ValidationException {
        if (this.getCurrentNode() != null) {
            ((IndexTreeNode)this.getCurrentNode()).setAttribute(name, values);
        }
    }

    protected void createIndexData() {
        block3: {
            try {
                InputStream inStream = this.getClass().getClassLoader().getResourceAsStream(this.treeFileName);
                if (inStream == null) {
                    inStream = RequestManager.getRequestContext().getServletContext().getResourceAsStream(this.treeFileName);
                }
                TreeReader reader = new TreeReader(inStream, ViewDescriptorManager.getInstance().getDTDURLBase());
                reader.populate(this);
                this.root();
            }
            catch (Exception ex) {
                if (!Util.isLoggableINFO()) break block3;
                Util.logINFO("ERROR IN READING TREE FILE: " + this.treeFileName + "  " + ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    public int getNextNodeID() {
        return this.nodeCount++;
    }

    public boolean isInitialExpand() {
        boolean b = this.initialExpand;
        this.initialExpand = false;
        return b;
    }

    public String getType(String string) {
        IndexTreeNode node = (IndexTreeNode)this.getCurrentNode();
        if (node != null) {
            return node.getType();
        }
        return "root";
    }

    public IndexTreeNode getRoot() {
        return this.root;
    }

    public void setRoot(IndexTreeNode node) {
        this.root = node;
    }
}

