/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBase;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.DescriptorCCPageTitle;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCActionTableDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.event.BeforeCreateEvent;
import com.sun.web.ui.model.CCActionTableModelInterface;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class FileUserHandler {
    private static final String GETUSER_GROUPNAME = "getUserGroupNames";
    private static final String GETUSER_NAME = "getUserNames";
    private static final String DELETE_USER = "removeUser";
    private static final String USER_ID = "userId";
    private static final String GROUP_LIST = "groupList";
    private static final String PASSWORD = "password";

    public boolean manageUsers(RequestContext ctx, HandlerContext handlerCtx) {
        Class<?> baseClass;
        Class<?> realm;
        String classname;
        DescriptorContainerView parent;
        block10: {
            block9: {
                parent = (DescriptorContainerView)handlerCtx.getView().getParent();
                classname = (String)handlerCtx.getInputValue("classname");
                if (classname == null) {
                    if (Util.isLoggableFINER()) {
                        Util.logFINER("The manageUsers 'classname' input variable was not specified. (" + classname + ")");
                    }
                    return false;
                }
                realm = null;
                try {
                    realm = Class.forName(classname);
                }
                catch (ClassNotFoundException ex) {
                    if (!Util.isLoggableFINER()) break block9;
                    Util.logFINER("The FileRealm classname, " + classname + " was not found.");
                }
            }
            baseClass = null;
            try {
                baseClass = Class.forName("com.sun.enterprise.security.auth.realm.IASRealm");
            }
            catch (ClassNotFoundException ex) {
                if (!Util.isLoggableFINER()) break block10;
                Util.logFINER("The class: \"com.sun.enterprise.security.auth.realm.IASRealm\" was not found.");
            }
        }
        if (realm == null || baseClass == null) {
            return false;
        }
        if (baseClass.isAssignableFrom(realm)) {
            return this.hasPropsForFileRealm(parent);
        }
        if (Util.isLoggableFINER()) {
            Util.logFINER("The FileRealm classname, \"" + classname + "\" does not extend \"com.sun.enterprise.security.auth.realm.IASRealm\".");
        }
        return false;
    }

    private boolean hasPropsForFileRealm(DescriptorContainerView parent) {
        Object objectName = parent.getViewDescriptor().getParameter("objectName");
        if (objectName == null) {
            return false;
        }
        AttributeList props = (AttributeList)MBeanUtil.invoke(objectName.toString(), "getProperties", null, null);
        if (props == null) {
            return false;
        }
        boolean jassContextFound = false;
        boolean fileRealmFound = false;
        for (int i = 0; i < props.size(); ++i) {
            Attribute prop = (Attribute)props.get(i);
            String name = prop.getName();
            if (name.equals("jaas-context") && prop.getValue() != null) {
                jassContextFound = true;
            }
            if (!name.equals("file") || prop.getValue() == null) continue;
            fileRealmFound = true;
        }
        return jassContextFound && fileRealmFound;
    }

    public void populateFileUsersModel(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        if (!(handlerCtx.getEvent() instanceof BeforeCreateEvent)) {
            ViewDescriptor desc = view instanceof DescriptorContainerView ? ((DescriptorContainerView)view).getViewDescriptor() : (ViewDescriptor)null;
            throw new FrameworkException("This handler is for 'beforeCreate' handlers only!", desc, view);
        }
        ViewDescriptor desc = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
        try {
            if (desc instanceof CCActionTableDescriptor) {
                CCActionTableDescriptor ccDesc = (CCActionTableDescriptor)desc;
                this.load(ccDesc.getModel(), ctx, handlerCtx);
            }
        }
        catch (Exception ex) {
            throw new FrameworkException((Throwable)ex, desc, view);
        }
    }

    private void load(CCActionTableModelInterface model, RequestContext ctx, HandlerContext handlerCtx) {
        Object[] userNames = (Object[])handlerCtx.getInputValue("userNames");
        String objectName = (String)handlerCtx.getInputValue("objectName");
        if (userNames == null) {
            return;
        }
        for (int rowNo = 0; rowNo < userNames.length; ++rowNo) {
            model.appendRow();
            model.setValue(USER_ID, userNames[rowNo]);
            String groupNames = this.getGroupNames((String)userNames[rowNo], objectName);
            model.setValue(GROUP_LIST, (Object)groupNames);
        }
    }

    public void addOrUpdateFileUser(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        if (!(view instanceof DescriptorContainerView)) {
            View parent = view.getParent();
            if (!(parent instanceof DescriptorContainerView)) {
                throw new FrameworkException("view is not DescriptorContainerView.", null, view);
            }
            view = parent;
        }
        if (view instanceof DescriptorCCPageTitle) {
            view = view.getParent();
        }
        DescriptorContainerView descView = (DescriptorContainerView)view;
        String user = (String)descView.getDisplayFieldValue(USER_ID);
        String passwd = (String)descView.getDisplayFieldValue(PASSWORD);
        String groupList = (String)descView.getDisplayFieldValue(GROUP_LIST);
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String methodName = (String)handlerCtx.getInputValue("methodName");
        if (methodName == null || !methodName.equals("addUser") && !methodName.equals("updateUser")) {
            throw new FrameworkException("Illegal method name, must be \"addUser\" or \"updateUser\": " + methodName, descView.getViewDescriptor(), view);
        }
        groupList = groupList.replaceAll(" ", "");
        String[] groups = this.getStringArray(groupList, ",");
        Object[] params = new Object[]{user, passwd, groups};
        String[] types = new String[]{"java.lang.String", "java.lang.String", groups.getClass().getName()};
        if (Util.isLoggableFINER()) {
            StringBuffer buf = new StringBuffer();
            buf.append("USER NAME = " + user);
            buf.append(", PASSWORD = " + passwd);
            buf.append(", GROUP = " + groupList);
            buf.append(", OBJECTNAME = " + objectName);
            buf.append(", METHODNAME = " + methodName);
            Util.logFINER(buf.toString());
        }
        try {
            Object object = MBeanUtil.invoke(objectName, methodName, params, types);
        }
        catch (Exception ex) {
            throw new FrameworkException((Throwable)ex, descView.getViewDescriptor(), view);
        }
    }

    private String[] getStringArray(String str, String delimiter) {
        if (str == null) {
            return null;
        }
        StringTokenizer strToken = new StringTokenizer(str, delimiter);
        String[] strArray = new String[strToken.countTokens()];
        int i = 0;
        while (strToken.hasMoreTokens()) {
            strArray[i++] = strToken.nextToken();
        }
        return strArray;
    }

    public void populateFileUsersDisplayFields(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        if (!(view instanceof DescriptorContainerView)) {
            View parent = view.getParent();
            if (!(parent instanceof DescriptorContainerView)) {
                throw new FrameworkException("view is not DescriptorContainerView", null, view);
            }
            view = parent;
        }
        if (view instanceof DescriptorCCPageTitle) {
            view = view.getParent();
        }
        DescriptorContainerView descView = (DescriptorContainerView)view;
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String userName = (String)handlerCtx.getInputValue("userName");
        String groupNames = this.getGroupNames(userName, objectName);
        descView.setDisplayFieldValue(USER_ID, (Object)userName);
        descView.setDisplayFieldValue(GROUP_LIST, (Object)groupNames);
    }

    private String getGroupNames(String userName, String objectName) {
        String[] groupList = null;
        String groupNames = null;
        try {
            Object obj = MBeanUtil.invoke(objectName, GETUSER_GROUPNAME, new Object[]{userName}, new String[]{"java.lang.String"});
            groupList = (String[])obj;
        }
        catch (Exception ex) {
            throw new FrameworkException((Throwable)ex);
        }
        if (groupList != null && groupList.length > 0) {
            groupNames = groupList[0];
            for (int i = 1; i < groupList.length; ++i) {
                groupNames = groupNames + "," + groupList[i];
            }
        }
        return groupNames;
    }

    public void deleteFileUser(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view).getParentViewBean();
        ViewDescriptor vd = descView.getViewDescriptor();
        String childName = (String)vd.getParameter("tableChildName");
        if (childName == null) {
            throw new FrameworkException("tableChildName not specified", vd, view);
        }
        ViewDescriptor tableDesc = vd.getChildDescriptor(childName);
        if (tableDesc == null) {
            throw new FrameworkException("tableDescriptor is null", vd, view);
        }
        if (!(tableDesc instanceof CCActionTableDescriptor)) {
            throw new FrameworkException("tableDescriptor is of wrong type", tableDesc, view);
        }
        CCActionTableModelInterface model = ((CCActionTableDescriptor)tableDesc).getModel();
        String deleteKey = (String)handlerCtx.getInputValue("deleteKey");
        String objectName = (String)handlerCtx.getInputValue("objectName");
        if (deleteKey == null) {
            throw new FrameworkException("No delete key specified", tableDesc, null);
        }
        if (objectName == null) {
            throw new FrameworkException("No ObjectName  specified", tableDesc, null);
        }
        model.setRowSelectionType("multiple");
        try {
            model.beforeFirst();
            while (model.next()) {
                if (!model.isRowSelected()) continue;
                ObjectName retObject = null;
                if (Util.isLoggableFINEST()) {
                    Util.logFINEST("USERNAME TO DELETE =" + model.getValue(deleteKey));
                }
                Object[] params = new Object[]{model.getValue(deleteKey)};
                String[] types = new String[]{"java.lang.String"};
                retObject = (ObjectName)MBeanUtil.invoke(objectName, DELETE_USER, params, types);
                model.setRowSelected(false);
            }
        }
        catch (Exception ex) {
            throw new FrameworkException("Exception while attempting to delete user!", (Throwable)ex, tableDesc, null);
        }
        ((ContainerViewBase)descView).removeChild(childName);
        ((DefaultModel)model).clear();
    }
}

