/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.guiframework.util;

import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.util.Util;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class PermissionChecker
implements Serializable {
    protected static final char POST_TRUE = 't';
    protected static final char POST_FALSE = 'f';
    protected static final char POST_TRUE_CAP = 'T';
    protected static final char POST_FALSE_CAP = 'F';
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final char FUNCTION_MARKER = 'F';
    public static final char LEFT_PAREN = '(';
    public static final char RIGHT_PAREN = ')';
    public static final char EQUALS_OPERATOR = '=';
    public static final char OR_OPERATOR = '|';
    public static final char AND_OPERATOR = '&';
    public static final char NOT_OPERATOR = '!';
    public static final char ARGUMENT_SEPARATOR = ',';
    private String _infixStr = null;
    private char[] _postfixArr = null;
    private static Map _functions = new HashMap();
    private List _functionList = null;
    private Stack _tmpFunctionStack = null;
    private int _currTmpFunction = 0;
    private ViewDescriptor _vd = null;

    public PermissionChecker(String infixStr, ViewDescriptor vd) {
        this.setViewDescriptor(vd);
        this.setInfix(PermissionChecker.stripWhiteSpace(infixStr));
    }

    protected void setViewDescriptor(ViewDescriptor vd) {
        this._vd = vd;
    }

    public ViewDescriptor getViewDescriptor() {
        return this._vd;
    }

    private static int getPrecedence(char op) {
        switch (op) {
            case '(': {
                return 2;
            }
            case ')': {
                return 999;
            }
            case '=': {
                return 3;
            }
            case '|': {
                return 4;
            }
            case '&': {
                return 5;
            }
            case '!': {
                return 6;
            }
        }
        return 1;
    }

    protected char[] preProcessString(String source) {
        source = this.substituteVariables(source, this.getViewDescriptor());
        char[] arr = source.toCharArray();
        int sourceLen = arr.length;
        int destLen = 0;
        Object str = null;
        block5: for (int idx = 0; idx < sourceLen; ++idx) {
            switch (arr[idx]) {
                case 'T': 
                case 't': {
                    if (idx + TRUE.length() <= sourceLen && TRUE.equalsIgnoreCase(new String(arr, idx, TRUE.length()))) {
                        arr[destLen++] = 116;
                        idx += TRUE.length() - 1;
                        continue block5;
                    }
                    idx = this.storeFunction(arr, idx);
                    arr[destLen++] = 70;
                    continue block5;
                }
                case 'F': 
                case 'f': {
                    if (idx + FALSE.length() <= sourceLen && FALSE.equalsIgnoreCase(new String(arr, idx, FALSE.length()))) {
                        arr[destLen++] = 102;
                        idx += FALSE.length() - 1;
                        continue block5;
                    }
                    idx = this.storeFunction(arr, idx);
                    arr[destLen++] = 70;
                    continue block5;
                }
                case '!': 
                case '&': 
                case '(': 
                case ')': 
                case '=': 
                case '|': {
                    arr[destLen++] = arr[idx];
                    continue block5;
                }
                default: {
                    idx = this.storeFunction(arr, idx);
                    arr[destLen++] = 70;
                }
            }
        }
        char[] dest = new char[destLen];
        for (int idx = 0; idx < destLen; ++idx) {
            dest[idx] = arr[idx];
        }
        return dest;
    }

    protected String substituteVariables(String string, ViewDescriptor vd) {
        int stringLen = string.length();
        int startTokenLen = "$".length();
        int delimLen = "(".length();
        int endTokenLen = ")".length();
        char firstEndChar = ")".charAt(0);
        char firstDelimChar = "(".charAt(0);
        Object obj = null;
        this._tmpFunctionStack = new Stack();
        this._currTmpFunction = 0;
        int startIndex = string.lastIndexOf("$");
        while (startIndex != -1) {
            int delimIndex = string.indexOf("(", startIndex + startTokenLen);
            if (delimIndex != -1) {
                int parenSemi = 0;
                int endIndex = -1;
                int curr = delimIndex + delimLen;
                while (curr < stringLen) {
                    char currChar = string.charAt(curr);
                    if (currChar == firstDelimChar && "(".equals(string.substring(curr, curr + delimLen))) {
                        ++parenSemi;
                        curr += delimLen;
                        continue;
                    }
                    if (currChar == firstEndChar && ")".equals(string.substring(curr, curr + endTokenLen))) {
                        if (--parenSemi < 0) {
                            endIndex = curr;
                            break;
                        }
                        curr += endTokenLen;
                        continue;
                    }
                    ++curr;
                }
                if (endIndex != -1) {
                    obj = Util.replaceVariablesWithAttributes(string.substring(startIndex, endIndex += endTokenLen), vd);
                    obj = obj == null ? new BooleanFunction(false) : (((String)(obj = obj.toString())).equalsIgnoreCase(FALSE) ? new BooleanFunction(false) : new StringFunction((String)obj));
                    this._tmpFunctionStack.push(obj);
                    string = string.substring(0, startIndex) + 'F' + string.substring(endIndex);
                }
            }
            startIndex = string.lastIndexOf("$", startIndex - 1);
        }
        return string;
    }

    protected int storeFunction(char[] arr, int idx) {
        int start = idx;
        int len = arr.length;
        while (idx < len && !this.isOperator(arr[idx])) {
            ++idx;
        }
        String str = new String(arr, start, idx - start);
        Function function = PermissionChecker.getFunction(str);
        if (function != null) {
            int left = idx;
            if (left >= len || arr[left] != '(') {
                throw new FrameworkException("Function '" + str + "' is expected to have a '" + '(' + "' immediately following it.  Equation: '" + new String(arr) + "'.");
            }
            ArrayList<String> arguments = new ArrayList<String>();
            while (++idx < len && arr[idx] != ')') {
                if (arr[idx] != ',') continue;
                arguments.add(new String(arr, ++left, idx - left));
                left = idx;
            }
            if (idx > ++left) {
                arguments.add(new String(arr, left, idx - left));
            }
            function.setArguments(arguments);
        } else {
            --idx;
            function = str.charAt(0) == 'F' && str.length() == 1 && !this._tmpFunctionStack.empty() ? (Function)this._tmpFunctionStack.pop() : new StringFunction(str);
        }
        this._functionList.add(function);
        return idx;
    }

    protected static Function getFunction(String functionName) {
        Class functionClass = (Class)_functions.get(functionName);
        if (functionClass == null) {
            return null;
        }
        Function function = null;
        try {
            function = (Function)functionClass.newInstance();
        }
        catch (Exception ex) {
            throw new FrameworkException("Unable to instantiate '" + functionClass.getName() + "' for '" + functionName + "'", ex);
        }
        return function;
    }

    public static void registerFunction(String functionName, Class function) {
        if (function == null) {
            _functions.remove(functionName);
        }
        if (!Function.class.isAssignableFrom(function)) {
            throw new FrameworkException("'" + function.getName() + "' must implement '" + Function.class.getName() + "'");
        }
        _functions.put(functionName, function);
    }

    public boolean isOperator(char ch) {
        switch (ch) {
            case '!': 
            case '&': 
            case '(': 
            case ')': 
            case '=': 
            case '|': {
                return true;
            }
        }
        return false;
    }

    protected char[] generatePostfix(String infixStr) {
        this._functionList = new ArrayList();
        char[] result = this.preProcessString(infixStr);
        int resultLen = result.length;
        int postIdx = 0;
        int precedence = 0;
        Stack<Character> opStack = new Stack<Character>();
        block5: for (int idx = 0; idx < resultLen; ++idx) {
            switch (result[idx]) {
                case 'F': 
                case 'f': 
                case 't': {
                    result[postIdx++] = result[idx];
                    continue block5;
                }
                case '(': {
                    opStack.push(new Character('('));
                    continue block5;
                }
                case ')': {
                    while (!opStack.empty() && ((Character)opStack.peek()).charValue() != '(') {
                        result[postIdx++] = ((Character)opStack.pop()).charValue();
                    }
                    if (opStack.empty()) continue block5;
                    opStack.pop();
                    continue block5;
                }
                default: {
                    precedence = PermissionChecker.getPrecedence(result[idx]);
                    while (!opStack.empty() && PermissionChecker.getPrecedence(((Character)opStack.peek()).charValue()) >= precedence) {
                        result[postIdx++] = ((Character)opStack.pop()).charValue();
                    }
                    opStack.push(new Character(result[idx]));
                }
            }
        }
        while (!opStack.empty()) {
            result[postIdx++] = ((Character)opStack.pop()).charValue();
        }
        char[] postfixStr = new char[postIdx];
        for (int idx = 0; idx < postIdx; ++idx) {
            postfixStr[idx] = result[idx];
        }
        return postfixStr;
    }

    protected boolean checkBoolean(String val) {
        return new Boolean("" + val);
    }

    public boolean hasPermission() {
        boolean val1;
        char[] postfixArr = this.getPostfixArr();
        int len = postfixArr.length;
        Stack<BooleanFunction> result = new Stack<BooleanFunction>();
        result.push(new BooleanFunction(false));
        Iterator it = this._functionList.iterator();
        Object func = null;
        block19: for (int idx = 0; idx < len; ++idx) {
            switch (postfixArr[idx]) {
                case 't': {
                    result.push(new BooleanFunction(true));
                    continue block19;
                }
                case 'f': {
                    result.push(new BooleanFunction(false));
                    continue block19;
                }
                case 'F': {
                    if (!it.hasNext()) {
                        throw new FrameworkException("Unable to evaluate: '" + this.toString() + "' -- found function marker w/o " + "cooresponding function!");
                    }
                    result.push((BooleanFunction)it.next());
                    continue block19;
                }
                case '=': {
                    try {
                        val1 = result.pop().toString().equals(result.pop().toString());
                    }
                    catch (EmptyStackException ex) {
                        throw new FrameworkException("Unable to evaluate: '" + this.toString() + "'.", ex);
                    }
                    result.push(new BooleanFunction(val1));
                    continue block19;
                }
                case '|': {
                    boolean val2;
                    try {
                        val1 = ((Function)result.pop()).evaluate();
                        val2 = ((Function)result.pop()).evaluate();
                    }
                    catch (EmptyStackException ex) {
                        throw new FrameworkException("Unable to evaluate: '" + this.toString() + "'.", ex);
                    }
                    result.push(new BooleanFunction(val1 || val2));
                    continue block19;
                }
                case '&': {
                    boolean val2;
                    try {
                        val1 = ((Function)result.pop()).evaluate();
                        val2 = ((Function)result.pop()).evaluate();
                    }
                    catch (EmptyStackException ex) {
                        throw new FrameworkException("Unable to evaluate: '" + this.toString() + "'.", ex);
                    }
                    result.push(new BooleanFunction(val1 && val2));
                    continue block19;
                }
                case '!': {
                    try {
                        val1 = ((Function)result.pop()).evaluate();
                    }
                    catch (EmptyStackException ex) {
                        throw new FrameworkException("Unable to evaluate: '" + this.toString() + "'.", ex);
                    }
                    result.push(new BooleanFunction(!val1));
                }
            }
        }
        try {
            val1 = ((Function)result.pop()).evaluate();
        }
        catch (EmptyStackException ex) {
            throw new FrameworkException("Unable to evaluate: '" + this.toString() + "'.", ex);
        }
        if (!result.empty()) {
            result.pop();
            if (!result.empty()) {
                throw new FrameworkException("Unable to evaluate: '" + this.toString() + "' -- values left on the stack.");
            }
        }
        return val1;
    }

    public String getInfix() {
        return this._infixStr;
    }

    public void setInfix(String equation) {
        this._infixStr = equation;
        this.setPostfixArr(this.generatePostfix(equation));
    }

    public char[] getPostfixArr() {
        if (this._postfixArr == null) {
            this._postfixArr = new char[]{' '};
        }
        return this._postfixArr;
    }

    protected void setPostfixArr(char[] postfix) {
        this._postfixArr = postfix;
    }

    public String getPostfix() {
        if (this.getPostfixArr() == null) {
            return "";
        }
        return new String(this.getPostfixArr());
    }

    public String toString() {
        return this._infixStr + " = " + this.toString(this.getPostfixArr());
    }

    private String toString(char[] post) {
        int len = post.length;
        String result = "";
        Iterator it = this._functionList.iterator();
        block5: for (int idx = 0; idx < len; ++idx) {
            switch (post[idx]) {
                case 't': {
                    result = result + TRUE;
                    continue block5;
                }
                case 'f': {
                    result = result + FALSE;
                    continue block5;
                }
                case 'F': {
                    result = result + ((Function)it.next()).toString();
                    continue block5;
                }
                default: {
                    result = result + post[idx];
                }
            }
        }
        return result;
    }

    public static String stripWhiteSpace(String input) {
        char[] arr = input.toCharArray();
        int len = arr.length;
        int destLen = 0;
        for (int idx = 0; idx < len; ++idx) {
            if (Character.isWhitespace(arr[idx])) continue;
            arr[destLen++] = arr[idx];
        }
        return new String(arr, 0, destLen);
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            for (int count = 0; count < args.length; ++count) {
                PermissionChecker checker = new PermissionChecker(args[count], null);
                System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            }
        } else {
            boolean success = true;
            PermissionChecker checker = new PermissionChecker("true |false", null);
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals("true|false = truefalse|")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\ntrue|false = truefalse|");
                success = false;
            }
            if (!checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            checker = new PermissionChecker("true&(false|true)", null);
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals("true&(false|true) = truefalsetrue|&")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\ntrue&(false|true) = truefalsetrue|&");
                success = false;
            }
            if (!checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            checker = new PermissionChecker("true&false|true", null);
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals("true&false|true = truefalse&true|")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\ntrue&false|true = truefalse&true|");
                success = false;
            }
            if (!checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            checker = new PermissionChecker("true&true|false&true", null);
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals("true&true|false&true = truetrue&falsetrue&|")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\ntrue&true|false&true = truetrue&falsetrue&|");
                success = false;
            }
            if (!checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            checker = new PermissionChecker("!true|false&!(false|true)", null);
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals("!true|false&!(false|true) = true!falsefalsetrue|!&|")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\n!true|false&!(false|true) = true!falsefalsetrue|!&|");
                success = false;
            }
            if (checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            checker = new PermissionChecker("!(!(true&!true)|!(false|false))|(true|false)&true", null);
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals("!(!(true&!true)|!(false|false))|(true|false)&true = truetrue!&!falsefalse|!|!truefalse|true&|")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\n!(!(true&!true)|!(false|false))|(true|false)&true = truetrue!&!falsefalse|!|!truefalse|true&|");
                success = false;
            }
            if (!checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            checker = new PermissionChecker("false =false", null);
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals("false=false = falsefalse=")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\nfalse=false = falsefalse=");
                success = false;
            }
            if (!checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            checker = new PermissionChecker(" test= me ", null);
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals("test=me = testme=")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\ntest=me = testme=");
                success = false;
            }
            if (checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            checker = new PermissionChecker(" this should work=thisshouldwork", null);
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals("thisshouldwork=thisshouldwork = thisshouldworkthisshouldwork=")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\nthisshouldwork=thisshouldwork = thisshouldworkthisshouldwork=");
                success = false;
            }
            if (!checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            checker = new PermissionChecker("false|ab=true", null);
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals("false|ab=true = falseab|true=")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\nfalse|ab=true = falseab|true=");
                success = false;
            }
            if (!checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            checker = new PermissionChecker("false|(ab=true)", null);
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals("false|(ab=true) = falseabtrue=|")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\nfalse|ab=true = falseab|true=");
                success = false;
            }
            if (checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            checker = new PermissionChecker("false|(ab=ab)", null);
            System.out.println("Output:\n" + checker.toString() + " (" + checker.hasPermission() + ")");
            if (!checker.toString().equals("false|(ab=ab) = falseabab=|")) {
                System.out.println("\tFAILED!");
                System.out.println("Should have been:\nfalse|ab=true = falseab|true=");
                success = false;
            }
            if (!checker.hasPermission()) {
                System.out.println("\tFAILED!");
                System.out.println("hasPermission(" + checker.toString(checker.getPostfixArr()) + ") returned the wrong result!");
                success = false;
            }
            if (success) {
                System.out.println("\n\tALL TESTS PASSED!");
            } else {
                System.out.println("\n\tNOT ALL TESTS PASSED!");
            }
        }
    }

    protected static class BooleanFunction
    implements Function {
        private boolean _value;

        public BooleanFunction() {
        }

        public BooleanFunction(boolean value) {
            this._value = value;
        }

        public List getArguments() {
            return null;
        }

        public void setArguments(List args) {
        }

        public boolean evaluate() {
            return this._value;
        }

        public String toString() {
            return this._value ? PermissionChecker.TRUE : PermissionChecker.FALSE;
        }
    }

    protected static class StringFunction
    implements Function {
        private String _value;

        public StringFunction(String value) {
            this._value = value;
        }

        public List getArguments() {
            return null;
        }

        public void setArguments(List args) {
        }

        public boolean evaluate() {
            return true;
        }

        public String toString() {
            return this._value;
        }
    }

    public static interface Function {
        public List getArguments();

        public void setArguments(List var1);

        public boolean evaluate();
    }
}

