/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.guiframework.event.handlers;

import com.iplanet.jato.RequestContext;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class AttributeHandlers {
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final String INDEX = "index";
    public static final String OBJECT = "object";
    public static final String METHOD = "method";

    public void getAttribute(RequestContext reqCtx, HandlerContext handlerCtx) {
        Object key = handlerCtx.getInputValue(KEY);
        if (key == null) {
            throw new IllegalArgumentException("The parameter map did not contain a key!");
        }
        handlerCtx.setOutputValue(VALUE, reqCtx.getRequest().getAttribute(key.toString()));
    }

    public void setAttribute(RequestContext reqCtx, HandlerContext handlerCtx) {
        Object key = handlerCtx.getInputValue(KEY);
        Object value = handlerCtx.getInputValue(VALUE);
        if (key == null) {
            throw new IllegalArgumentException("The parameter map did not contain a key!");
        }
        reqCtx.getRequest().setAttribute(key.toString(), value);
    }

    public void getListElement(RequestContext reqCtx, HandlerContext handlerCtx) {
        Object key = handlerCtx.getInputValue(KEY);
        if (key == null) {
            throw new IllegalArgumentException("The parameter map did not contain 'key'!");
        }
        int index = this.getIndex((Integer)handlerCtx.getInputValue(INDEX));
        Object attr = reqCtx.getRequest().getAttribute(key.toString());
        if (attr == null) {
            throw new IllegalArgumentException("No request attribute is stored under the key: '" + key + "'.");
        }
        if (attr instanceof List) {
            handlerCtx.setOutputValue(VALUE, ((List)attr).get(index));
            return;
        }
        if (attr.getClass().isArray()) {
            handlerCtx.setOutputValue(VALUE, Array.get(attr, index));
            return;
        }
        throw new IllegalArgumentException("Value stored under request attribute '" + key + "' is not an array or List!");
    }

    public void setListElement(RequestContext reqCtx, HandlerContext handlerCtx) {
        Object value = handlerCtx.getInputValue(VALUE);
        Object key = handlerCtx.getInputValue(KEY);
        if (key == null) {
            throw new IllegalArgumentException("The parameter map did not contain 'key'!");
        }
        int index = this.getIndex((Integer)handlerCtx.getInputValue(INDEX));
        ArrayList list = reqCtx.getRequest().getAttribute(key.toString());
        if (list == null) {
            list = new ArrayList(index);
        }
        if (list instanceof List) {
            int len = ((List)list).size();
            if (index >= len) {
                Object val = null;
                while (index > len) {
                    try {
                        try {
                            ((List)list).add(val);
                        }
                        catch (NullPointerException ex) {
                            val = "";
                            ((List)list).add(val);
                        }
                    }
                    catch (ClassCastException ex2) {
                        val = value;
                        ((List)list).add(val);
                    }
                    ++len;
                }
                ((List)list).add(value);
            } else {
                ((List)list).set(index, value);
            }
        } else if (list.getClass().isArray()) {
            int len = Array.getLength(list);
            Class<?> type = list.getClass().getComponentType();
            if (index >= len) {
                Object newList = Array.newInstance(type, index + 1);
                for (int count = 0; count < len; ++count) {
                    Array.set(newList, count, Array.get(list, count));
                }
                list = newList;
            }
            try {
                Array.set(list, index, value);
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to set '" + value + "' to array!", ex);
            }
        } else {
            throw new IllegalArgumentException("Value stored in request attribute '" + key + "' is not an array or List: '" + list.getClass() + "'.");
        }
        reqCtx.getRequest().setAttribute(key.toString(), list);
    }

    private int getIndex(Integer idx) {
        if (idx == null) {
            throw new IllegalArgumentException("The parameter map did not contain 'index'!");
        }
        int index = idx;
        if (index < 0) {
            throw new IllegalArgumentException("'index' must be non-negative (received '" + index + "').");
        }
        return index;
    }

    public String callMethod(RequestContext reqCtx, HandlerContext handlerCtx) {
        Object obj = handlerCtx.getInputValue(OBJECT);
        String methodName = (String)handlerCtx.getInputValue(METHOD);
        if (obj == null || methodName == null) {
            throw new IllegalArgumentException("Null parameter(s) sent to 'callMethod'.");
        }
        Method method = null;
        try {
            method = obj.getClass().getMethod(methodName, null);
        }
        catch (Exception ex) {
            throw new RuntimeException("Method not found: " + methodName, ex);
        }
        Object value = obj;
        try {
            value = method.invoke(obj, null);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error calling: " + methodName, ex);
        }
        handlerCtx.setOutputValue(VALUE, value);
        if (value != null) {
            return value.toString();
        }
        return "";
    }
}

