/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans.metadd;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.schema2beans.metadd.CommonBean;
import org.netbeans.modules.schema2beans.metadd.MetaDD;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetaProperty
implements CommonBean {
    private String _BeanName;
    private List _DefaultValue = new ArrayList();
    private List _KnownValue = new ArrayList();
    private boolean _Key;
    private boolean _Vetoable;

    public MetaProperty() {
        this._BeanName = "";
    }

    public MetaProperty(MetaProperty source) {
        this._BeanName = source._BeanName;
        Iterator it = source._DefaultValue.iterator();
        while (it.hasNext()) {
            this._DefaultValue.add((String)it.next());
        }
        Iterator it2 = source._KnownValue.iterator();
        while (it2.hasNext()) {
            this._KnownValue.add((String)it2.next());
        }
        this._Key = source._Key;
        this._Vetoable = source._Vetoable;
    }

    public void setBeanName(String value) {
        this._BeanName = value;
    }

    public String getBeanName() {
        return this._BeanName;
    }

    public void setDefaultValue(String[] value) {
        if (value == null) {
            value = new String[]{};
        }
        this._DefaultValue.clear();
        int i = 0;
        while (i < value.length) {
            this._DefaultValue.add(value[i]);
            ++i;
        }
    }

    public void setDefaultValue(int index, String value) {
        this._DefaultValue.set(index, value);
    }

    public String[] getDefaultValue() {
        String[] arr = new String[this._DefaultValue.size()];
        return this._DefaultValue.toArray(arr);
    }

    public List fetchDefaultValueList() {
        return this._DefaultValue;
    }

    public String getDefaultValue(int index) {
        return (String)this._DefaultValue.get(index);
    }

    public int sizeDefaultValue() {
        return this._DefaultValue.size();
    }

    public int addDefaultValue(String value) {
        this._DefaultValue.add(value);
        return this._DefaultValue.size() - 1;
    }

    public int removeDefaultValue(String value) {
        int pos = this._DefaultValue.indexOf(value);
        if (pos >= 0) {
            this._DefaultValue.remove(pos);
        }
        return pos;
    }

    public void setKnownValue(String[] value) {
        if (value == null) {
            value = new String[]{};
        }
        this._KnownValue.clear();
        int i = 0;
        while (i < value.length) {
            this._KnownValue.add(value[i]);
            ++i;
        }
    }

    public void setKnownValue(int index, String value) {
        this._KnownValue.set(index, value);
    }

    public String[] getKnownValue() {
        String[] arr = new String[this._KnownValue.size()];
        return this._KnownValue.toArray(arr);
    }

    public List fetchKnownValueList() {
        return this._KnownValue;
    }

    public String getKnownValue(int index) {
        return (String)this._KnownValue.get(index);
    }

    public int sizeKnownValue() {
        return this._KnownValue.size();
    }

    public int addKnownValue(String value) {
        this._KnownValue.add(value);
        return this._KnownValue.size() - 1;
    }

    public int removeKnownValue(String value) {
        int pos = this._KnownValue.indexOf(value);
        if (pos >= 0) {
            this._KnownValue.remove(pos);
        }
        return pos;
    }

    public void setKey(boolean value) {
        this._Key = value;
    }

    public boolean isKey() {
        return this._Key;
    }

    public void setVetoable(boolean value) {
        this._Vetoable = value;
    }

    public boolean isVetoable() {
        return this._Vetoable;
    }

    public void writeNode(Writer out, String nodeName, String indent) throws IOException {
        out.write(indent);
        out.write("<");
        out.write(nodeName);
        out.write(">\n");
        String nextIndent = indent + "\t";
        if (this._BeanName != null) {
            out.write(nextIndent);
            out.write("<bean-name");
            out.write(">");
            MetaDD.writeXML(out, this._BeanName, false);
            out.write("</bean-name>\n");
        }
        Iterator it = this._DefaultValue.iterator();
        while (it.hasNext()) {
            String element = (String)it.next();
            if (element == null) continue;
            out.write(nextIndent);
            out.write("<default-value");
            out.write(">");
            MetaDD.writeXML(out, element, false);
            out.write("</default-value>\n");
        }
        Iterator it2 = this._KnownValue.iterator();
        while (it2.hasNext()) {
            String element = (String)it2.next();
            if (element == null) continue;
            out.write(nextIndent);
            out.write("<known-value");
            out.write(">");
            MetaDD.writeXML(out, element, false);
            out.write("</known-value>\n");
        }
        if (this._Key) {
            out.write(nextIndent);
            out.write("<key");
            out.write("/>\n");
        }
        if (this._Vetoable) {
            out.write(nextIndent);
            out.write("<vetoable");
            out.write("/>\n");
        }
        out.write(indent);
        out.write("</" + nodeName + ">\n");
    }

    public void readNode(Node node) {
        NodeList children = node.getChildNodes();
        int i = 0;
        int size = children.getLength();
        while (i < size) {
            Node childNode = children.item(i);
            String childNodeName = childNode.getLocalName() == null ? childNode.getNodeName().intern() : childNode.getLocalName().intern();
            String childNodeValue = "";
            if (childNode.getFirstChild() != null) {
                childNodeValue = childNode.getFirstChild().getNodeValue();
            }
            if (childNodeName == "bean-name") {
                this._BeanName = childNodeValue;
            } else if (childNodeName == "default-value") {
                String aDefaultValue = childNodeValue;
                this._DefaultValue.add(aDefaultValue);
            } else if (childNodeName == "known-value") {
                String aKnownValue = childNodeValue;
                this._KnownValue.add(aKnownValue);
            } else if (childNodeName == "key") {
                this._Key = childNode.getFirstChild() == null ? true : Boolean.valueOf(childNodeValue);
            } else if (childNodeName == "vetoable") {
                this._Vetoable = childNode.getFirstChild() == null ? true : Boolean.valueOf(childNodeValue);
            }
            ++i;
        }
    }

    public void validate() throws MetaDD.ValidateException {
        boolean restrictionFailure = false;
        if (this.getBeanName() == null) {
            throw new MetaDD.ValidateException("getBeanName() == null", "beanName", this);
        }
        int _index = 0;
        while (_index < this.sizeDefaultValue()) {
            String element = this.getDefaultValue(_index);
            if (element != null) {
                // empty if block
            }
            ++_index;
        }
        int _index2 = 0;
        while (_index2 < this.sizeKnownValue()) {
            String element = this.getKnownValue(_index2);
            if (element != null) {
                // empty if block
            }
            ++_index2;
        }
    }

    public void changePropertyByName(String name, Object value) {
        if (name == null) {
            return;
        }
        if ((name = name.intern()) == "beanName") {
            this.setBeanName((String)value);
        } else if (name == "defaultValue") {
            this.addDefaultValue((String)value);
        } else if (name == "defaultValue[]") {
            this.setDefaultValue((String[])value);
        } else if (name == "knownValue") {
            this.addKnownValue((String)value);
        } else if (name == "knownValue[]") {
            this.setKnownValue((String[])value);
        } else if (name == "key") {
            this.setKey((Boolean)value);
        } else if (name == "vetoable") {
            this.setVetoable((Boolean)value);
        } else {
            throw new IllegalArgumentException(name + " is not a valid property name for MetaProperty");
        }
    }

    public Object fetchPropertyByName(String name) {
        if (name == "beanName") {
            return this.getBeanName();
        }
        if (name == "defaultValue[]") {
            return this.getDefaultValue();
        }
        if (name == "knownValue[]") {
            return this.getKnownValue();
        }
        if (name == "key") {
            return this.isKey() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name == "vetoable") {
            return this.isVetoable() ? Boolean.TRUE : Boolean.FALSE;
        }
        throw new IllegalArgumentException(name + " is not a valid property name for MetaProperty");
    }

    public CommonBean[] childBeans(boolean recursive) {
        LinkedList children = new LinkedList();
        this.childBeans(recursive, children);
        CommonBean[] result = new CommonBean[children.size()];
        return children.toArray(result);
    }

    public void childBeans(boolean recursive, List beans) {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetaProperty)) {
            return false;
        }
        MetaProperty inst = (MetaProperty)o;
        if (!(this._BeanName == null ? inst._BeanName == null : this._BeanName.equals(inst._BeanName))) {
            return false;
        }
        if (this.sizeDefaultValue() != inst.sizeDefaultValue()) {
            return false;
        }
        Iterator it = this._DefaultValue.iterator();
        Iterator it2 = inst._DefaultValue.iterator();
        while (it.hasNext() && it2.hasNext()) {
            String element = (String)it.next();
            String element2 = (String)it2.next();
            if (element == null ? element2 == null : element.equals(element2)) continue;
            return false;
        }
        if (this.sizeKnownValue() != inst.sizeKnownValue()) {
            return false;
        }
        Iterator it3 = this._KnownValue.iterator();
        Iterator it22 = inst._KnownValue.iterator();
        while (it3.hasNext() && it22.hasNext()) {
            String element = (String)it3.next();
            String element2 = (String)it22.next();
            if (element == null ? element2 == null : element.equals(element2)) continue;
            return false;
        }
        if (this._Key != inst._Key) {
            return false;
        }
        return this._Vetoable == inst._Vetoable;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this._BeanName == null ? 0 : this._BeanName.hashCode());
        result = 37 * result + (this._DefaultValue == null ? 0 : this._DefaultValue.hashCode());
        result = 37 * result + (this._KnownValue == null ? 0 : this._KnownValue.hashCode());
        result = 37 * result + (this._Key ? 0 : 1);
        result = 37 * result + (this._Vetoable ? 0 : 1);
        return result;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.writeNode(sw, "MetaProperty", "\t");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }
}

