/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans.gen;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Stack;

public class GenBuffer
extends Writer {
    protected int curOut;
    protected StringBuffer[] listOut;
    protected int bufferCount;
    protected Stack selectStack = new Stack();
    private CharArrayWriter caw = null;

    public GenBuffer(int bufferCount) {
        this.bufferCount = bufferCount;
        this.listOut = new StringBuffer[bufferCount];
        this.privateInit();
    }

    public void reset() {
        this.privateInit();
    }

    private void privateInit() {
        int i = 0;
        while (i < this.bufferCount) {
            this.listOut[i] = new StringBuffer();
            ++i;
        }
    }

    public void insertAdditionalBuffers(int offset, int count) {
        StringBuffer[] newListOut = new StringBuffer[this.bufferCount + count];
        System.arraycopy(this.listOut, 0, newListOut, 0, offset + 1);
        System.arraycopy(this.listOut, offset + 1, newListOut, offset + 1 + count, this.bufferCount - offset - 1);
        int i = 0;
        while (i < count) {
            newListOut[offset + 1 + i] = new StringBuffer();
            ++i;
        }
        this.bufferCount += count;
        this.listOut = newListOut;
    }

    public void close() {
    }

    public void flush() {
    }

    public void select(int bufferNum) {
        if (bufferNum >= this.bufferCount || bufferNum < 0) {
            throw new IllegalArgumentException("Invalid bufferNum " + bufferNum + " out of " + this.bufferCount);
        }
        this.curOut = bufferNum;
    }

    public void pushSelect(int bufferNum) {
        int prevOut = this.curOut;
        this.select(bufferNum);
        this.selectStack.push(new Integer(prevOut));
    }

    public void popSelect() {
        this.curOut = (Integer)this.selectStack.pop();
    }

    protected void beforeWriteHook() {
    }

    public void write(boolean b) throws IOException {
        this.beforeWriteHook();
        this.listOut[this.curOut].append(b);
    }

    public void write(char c) throws IOException {
        this.beforeWriteHook();
        this.listOut[this.curOut].append(c);
    }

    public void write(char[] str) throws IOException {
        this.beforeWriteHook();
        this.listOut[this.curOut].append(str);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.beforeWriteHook();
        this.listOut[this.curOut].append(cbuf, off, len);
    }

    public void write(double d) throws IOException {
        this.beforeWriteHook();
        this.listOut[this.curOut].append(d);
    }

    public void write(float f) throws IOException {
        this.beforeWriteHook();
        this.listOut[this.curOut].append(f);
    }

    public void write(int i) throws IOException {
        if (this.caw == null) {
            this.caw = new CharArrayWriter(2);
        }
        this.caw.write(i);
        this.beforeWriteHook();
        this.listOut[this.curOut].append(this.caw.toString());
        this.caw.reset();
    }

    public void write(long l) throws IOException {
        this.write((int)l);
    }

    public void write(Object obj) throws IOException {
        this.beforeWriteHook();
        this.listOut[this.curOut].append(obj);
    }

    public void write(String s) throws IOException {
        this.beforeWriteHook();
        this.listOut[this.curOut].append(s);
    }

    public void write(StringBuffer s) throws IOException {
        this.beforeWriteHook();
        this.listOut[this.curOut].append((Object)s);
    }

    public void write(String s1, String s2) throws IOException {
        this.beforeWriteHook();
        this.listOut[this.curOut].append(s1);
        this.listOut[this.curOut].append(s2);
    }

    public void write(String s1, String s2, String s3) throws IOException {
        this.beforeWriteHook();
        this.listOut[this.curOut].append(s1);
        this.listOut[this.curOut].append(s2);
        this.listOut[this.curOut].append(s3);
    }

    public void write(String str, int bufferNum) throws IOException {
        if (bufferNum >= this.bufferCount || bufferNum < 0) {
            throw new IllegalArgumentException("Invalid bufferNum " + bufferNum + " out of " + this.bufferCount);
        }
        this.beforeWriteHook();
        this.listOut[bufferNum].append(str);
    }

    public void writeTo(Writer out) throws IOException {
        int i = 0;
        while (i < this.bufferCount) {
            out.write(this.listOut[i].toString());
            ++i;
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        int i = 0;
        while (i < this.bufferCount) {
            out.write(this.listOut[i].toString().getBytes());
            ++i;
        }
    }

    public StringBuffer getBuffer() {
        return this.listOut[this.curOut];
    }

    public void ensureCapacity(int minimumCapacity) {
        int i = 0;
        while (i < this.bufferCount) {
            this.listOut[i].ensureCapacity(minimumCapacity);
            ++i;
        }
    }
}

