/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.BaseProperty;
import org.netbeans.modules.schema2beans.BeanProp;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.DDFactory;
import org.netbeans.modules.schema2beans.DDLogFlags;
import org.netbeans.modules.schema2beans.DOMBinding;
import org.netbeans.modules.schema2beans.NodeFactory;
import org.netbeans.modules.schema2beans.NullEntityResolver;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.schema2beans.Schema2BeansNestedException;
import org.netbeans.modules.schema2beans.Schema2BeansRuntimeException;
import org.netbeans.modules.schema2beans.TraceLogger;
import org.netbeans.modules.schema2beans.XMLUtil;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GraphManager {
    Document document = null;
    NodeFactory factory = null;
    HashMap bindingsMap = new HashMap();
    BaseBean root;
    private Factory docFactory;
    private Writer docWriter;
    private String docTypePublic;
    private String docTypeSystem;
    static Map factoryMap = Collections.synchronizedMap(new HashMap());
    static Map writerMap = Collections.synchronizedMap(new HashMap());

    public GraphManager(BaseBean root) {
        this.root = root;
    }

    public static void setFactory(InputStream in, Factory factory) throws Schema2BeansException {
        GraphManager.setFactory(in, factory, null);
    }

    public static void setFactory(InputStream in, Factory factory, Writer writer) throws Schema2BeansException {
        if (in == null) {
            throw new Schema2BeansException(Common.getMessage("InputStreamCantBeNull_msg"));
        }
        if (factory != null) {
            factoryMap.put(in, factory);
        } else {
            factoryMap.remove(in);
        }
        if (writer != null) {
            writerMap.put(in, writer);
        } else {
            writerMap.remove(in);
        }
    }

    public void setWriter(Writer writer) {
        this.docWriter = writer;
    }

    public static Node createRootElementNode(String name) throws Schema2BeansRuntimeException {
        String s = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<" + name + "/>";
        ByteArrayInputStream in = new ByteArrayInputStream(s.getBytes());
        Document doc = GraphManager.createXmlDocument(in, false);
        NodeList children = doc.getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            Node node = children.item(i);
            if (node instanceof DocumentType) {
                doc.removeChild(node);
                --length;
            }
            ++i;
        }
        return doc;
    }

    public void setXmlDocument(Node doc) throws Schema2BeansRuntimeException {
        if (doc instanceof Document) {
            this.document = (Document)doc;
            this.setNodeFactory((Document)doc);
            Object o = factoryMap.get(doc);
            if (o != null) {
                this.docFactory = (Factory)o;
                factoryMap.remove(doc);
            }
            if ((o = writerMap.get(doc)) != null) {
                this.docWriter = (Writer)o;
                writerMap.remove(doc);
            }
        } else {
            throw new Schema2BeansRuntimeException(Common.getMessage("CantFindFactory_msg"));
        }
    }

    public Document getXmlDocument() {
        return this.document;
    }

    public void setDoctype(String publicId, String systemId) {
        this.docTypePublic = publicId;
        this.docTypeSystem = systemId;
    }

    public static Node getElementNode(String name, Node doc) {
        Node n = doc.getFirstChild();
        while (n != null) {
            if (n.getNodeType() == 1 && n.getNodeName().equals(name)) break;
            n = n.getNextSibling();
        }
        return n;
    }

    public void createRootBinding(BaseBean beanRoot, BeanProp prop, Node doc) throws Schema2BeansException {
        prop.registerDomNode(doc, null, beanRoot);
        if (doc != null) {
            this.bindingsMap.put(doc, beanRoot.binding);
        }
    }

    public void completeRootBinding(BaseBean beanRoot, Node doc) {
        this.bindingsMap.put(doc, beanRoot.binding);
        beanRoot.binding.setNode(doc);
    }

    public void setNodeFactory(Document doc) {
        this.factory = new NodeFactory(doc);
    }

    public NodeFactory getNodeFactory() {
        return this.factory;
    }

    public BaseBean getBeanRoot() {
        return this.root;
    }

    protected static Element getRootElement(Document doc) {
        return doc.getDocumentElement();
    }

    protected static String getDocTypeName(Document doc) {
        NodeList children = doc.getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            Node node = children.item(i);
            if (node instanceof DocumentType) {
                DocumentType docType = (DocumentType)node;
                return docType.getName();
            }
            ++i;
        }
        Element rootNode = GraphManager.getRootElement(doc);
        return rootNode.getNodeName();
    }

    void write(OutputStream out) throws IOException, Schema2BeansException {
        if (this.document == null) {
            throw new Schema2BeansException(Common.getMessage("CantGetDocument_msg"));
        }
        if (this.docWriter != null) {
            this.docWriter.write(out, this.document);
        } else {
            this.write(out, null);
        }
    }

    protected void write(OutputStream out, String encoding) throws IOException, Schema2BeansException {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(out, encoding));
        this.write((java.io.Writer)w, encoding);
        ((java.io.Writer)w).flush();
    }

    protected void write(java.io.Writer out) throws IOException, Schema2BeansException {
        this.write(out, (String)null);
    }

    protected void write(java.io.Writer out, String encoding) throws IOException, Schema2BeansException {
        out.write("<?xml version=\"1.0\"");
        if (encoding != null) {
            out.write(" encoding=\"" + encoding + "\"?>\n");
        } else {
            out.write(" encoding=\"UTF-8\"?>\n");
        }
        if (this.docTypePublic != null || this.docTypeSystem != null) {
            String docName = GraphManager.getDocTypeName(this.document);
            DocumentType docType = this.document.getDoctype();
            NamedNodeMap entities = null;
            if (docType != null) {
                entities = docType.getEntities();
            }
            this.write(out, docName, this.docTypePublic, this.docTypeSystem, entities);
            out.write("\n");
        }
        NodeList children = this.document.getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            Node node = children.item(i);
            if (node instanceof DocumentType) {
                this.write(out, node);
                out.write("\n");
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < length) {
            Node node = children.item(i2);
            if (!(node instanceof DocumentType)) {
                this.write(out, node);
                out.write("\n");
            }
            ++i2;
        }
        out.flush();
    }

    public void write(java.io.Writer out, Node node) throws IOException, Schema2BeansException {
        boolean needsReturnBetweenChildren = false;
        NodeList children = node.getChildNodes();
        if (node instanceof Element) {
            out.write("<" + node.getNodeName());
            this.write(out, node.getAttributes());
            if (children.getLength() == 0) {
                out.write("/>");
                return;
            }
            out.write(">");
        } else if (node instanceof Text) {
            XMLUtil.printXML(out, node.getNodeValue(), false);
        } else if (node instanceof Document) {
            needsReturnBetweenChildren = true;
        } else if (node instanceof DocumentType) {
            this.write(out, (DocumentType)node);
        } else if (node instanceof Comment) {
            this.write(out, (Comment)node);
        } else if (node instanceof Entity) {
            this.write(out, (Entity)node);
        } else if (node instanceof ProcessingInstruction) {
            this.write(out, (ProcessingInstruction)node);
        } else {
            System.out.println("! schema2beans found unknown node type in DOM graph:");
            System.out.println("write: node.getClass=" + node.getClass() + " node=" + node);
            System.out.println("write: nodename=" + node.getNodeName() + " nodevalue=" + node.getNodeValue());
            System.out.println("write: getAttributes=" + node.getAttributes());
        }
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            this.write(out, children.item(i));
            if (needsReturnBetweenChildren) {
                out.write("\n");
            }
            ++i;
        }
        if (node instanceof Element) {
            out.write("</" + node.getNodeName() + ">");
        }
    }

    protected void write(java.io.Writer out, DocumentType docType) throws IOException, Schema2BeansException {
        if (this.docTypePublic != null || this.docTypeSystem != null) {
            return;
        }
        this.write(out, docType.getName(), docType.getPublicId(), docType.getSystemId(), docType.getEntities());
    }

    protected void write(java.io.Writer out, String docName, String publicId, String systemId, NamedNodeMap entities) throws IOException, Schema2BeansException {
        int length;
        out.write("<!DOCTYPE " + docName);
        if (publicId != null) {
            out.write(" PUBLIC \"");
            XMLUtil.printXML(out, publicId);
            out.write("\"");
            if (systemId == null) {
                systemId = "SYSTEM";
            }
        }
        if (systemId != null) {
            out.write(" \"");
            XMLUtil.printXML(out, systemId);
            out.write("\"");
        }
        if (entities != null && (length = entities.getLength()) > 0) {
            out.write(" [");
            int i = 0;
            while (i < length) {
                Node node = entities.item(i);
                this.write(out, node);
                ++i;
            }
            out.write("]");
        }
        out.write(">");
    }

    protected void write(java.io.Writer out, Comment comment) throws IOException {
        out.write("<!--");
        String text = comment.getNodeValue();
        int pos = text.indexOf("--");
        while (pos >= 0) {
            out.write(text.substring(0, pos));
            out.write("&#x2d;&#x2d;");
            text = text.substring(pos + 2, text.length());
            pos = text.indexOf("--");
        }
        out.write(text);
        out.write("-->");
    }

    protected void write(java.io.Writer out, Entity entity) throws IOException {
        out.write("<!ENTITY " + entity.getNodeName());
        out.write(" UNKNOWN>");
    }

    protected void write(java.io.Writer out, ProcessingInstruction pi) throws IOException {
        if ("xml".equals(pi.getTarget())) {
            return;
        }
        out.write("<?" + pi.getTarget() + " " + pi.getData() + "?>");
    }

    protected void write(java.io.Writer out, NamedNodeMap nodes) throws IOException {
        int length = nodes.getLength();
        int i = 0;
        while (i < length) {
            Node node = nodes.item(i);
            out.write(" ");
            out.write(node.getNodeName());
            out.write("=\"");
            XMLUtil.printXML(out, node.getNodeValue());
            out.write("\"");
            ++i;
        }
    }

    public void reindent(String indent) {
        this.reindent(this.document, -1, indent);
    }

    protected boolean reindent(Node node, int level, String indent) {
        String nodeValue = node.getNodeValue();
        boolean hasOnlyWhitespaceTextChildren = true;
        NodeList children = node.getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            if (!this.reindent(children.item(i), level + 1, indent)) {
                hasOnlyWhitespaceTextChildren = false;
            }
            ++i;
        }
        if (hasOnlyWhitespaceTextChildren && level >= 0 && length > 0) {
            StringBuffer idealWhitespaceBuf = new StringBuffer();
            GraphManager.printLevel(idealWhitespaceBuf, level, indent);
            String idealFinalWhitespace = "\n" + idealWhitespaceBuf.toString().intern();
            GraphManager.printLevel(idealWhitespaceBuf, 1, indent);
            String idealChildWhitespace = "\n" + idealWhitespaceBuf.toString().intern();
            if (length > 1 && !(children.item(length - 1) instanceof Text)) {
                node.appendChild(this.document.createTextNode(idealFinalWhitespace));
                ++length;
            }
            boolean shouldBeTextNode = true;
            int i2 = 0;
            while (i2 < length) {
                Text textNode;
                String childNodeValue;
                Node childNode = children.item(i2);
                boolean isTextNode = childNode instanceof Text;
                if (shouldBeTextNode) {
                    if (isTextNode) {
                        childNodeValue = childNode.getNodeValue().intern();
                        if (length != 1) {
                            textNode = (Text)childNode;
                            if (i2 == length - 1) {
                                if (idealFinalWhitespace != childNodeValue) {
                                    if (textNode.getLength() > 0) {
                                        textNode.deleteData(0, textNode.getLength());
                                    }
                                    textNode.appendData(idealFinalWhitespace);
                                }
                            } else if (idealChildWhitespace != childNodeValue) {
                                textNode.deleteData(0, textNode.getLength());
                                textNode.appendData(idealChildWhitespace);
                            }
                            shouldBeTextNode ^= true;
                        }
                    } else {
                        if (i2 == length - 1) {
                            node.insertBefore(this.document.createTextNode(idealChildWhitespace), childNode);
                            node.appendChild(this.document.createTextNode(idealFinalWhitespace));
                            ++length;
                        } else {
                            node.insertBefore(this.document.createTextNode(idealChildWhitespace), childNode);
                        }
                        ++i2;
                        ++length;
                    }
                } else if (isTextNode) {
                    node.removeChild(childNode);
                    if (--i2 == --length - 1 && i2 >= 0 && idealFinalWhitespace != (childNodeValue = (childNode = children.item(i2)).getNodeValue().intern())) {
                        textNode = (Text)childNode;
                        if (textNode.getLength() > 0) {
                            textNode.deleteData(0, textNode.getLength());
                        }
                        textNode.appendData(idealFinalWhitespace);
                    }
                } else {
                    shouldBeTextNode ^= true;
                }
                ++i2;
            }
        }
        if (node instanceof Text) {
            if (nodeValue == null) {
                return true;
            }
            return nodeValue.trim().equals("");
        }
        return true;
    }

    protected static void printLevel(java.io.Writer out, int level, String indent) throws IOException {
        StringBuffer outBuf = new StringBuffer();
        GraphManager.printLevel(outBuf, level, indent);
        out.write(outBuf.toString());
    }

    protected static void printLevel(StringBuffer out, int level, String indent) {
        int i = 0;
        while (i < level) {
            out.append(indent);
            ++i;
        }
    }

    protected static void printLevel(java.io.Writer out, int level, String indent, String text) throws IOException {
        StringBuffer outBuf = new StringBuffer();
        GraphManager.printLevel(outBuf, level, indent, text);
        out.write(outBuf.toString());
    }

    protected static void printLevel(OutputStream out, int level, String indent, String text) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out);
        GraphManager.printLevel(w, level, indent, text);
        w.flush();
    }

    protected static void printLevel(StringBuffer out, int level, String indent, String text) {
        GraphManager.printLevel(out, level, indent);
        out.append(text);
    }

    public static Document createXmlDocument(InputStream in, boolean validate) throws Schema2BeansRuntimeException {
        return GraphManager.createXmlDocument(in, validate, null);
    }

    /*
     * WARNING - void declaration
     */
    private static InputStream tee(InputStream in) throws IOException {
        int len;
        byte[] buf = new byte[4096];
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        int totalLength = 0;
        while ((len = in.read(buf, 0, 4096)) > 0) {
            void var4_4;
            ba.write(buf, 0, (int)var4_4);
            totalLength += var4_4;
        }
        System.out.println("schema2beans: in (length=" + totalLength + "):");
        System.out.println(ba.toString());
        ByteArrayInputStream bain = new ByteArrayInputStream(ba.toByteArray());
        return bain;
    }

    public static Document createXmlDocument(InputStream in, boolean validate, EntityResolver er) throws Schema2BeansRuntimeException {
        try {
            Object o;
            if (DDLogFlags.debug) {
                in = GraphManager.tee(in);
            }
            if ((o = factoryMap.get(in)) != null) {
                Factory f = (Factory)o;
                Document doc = f.createDocument(in, validate);
                factoryMap.remove(in);
                factoryMap.put(doc, o);
                Object o2 = writerMap.get(in);
                if (o2 != null) {
                    writerMap.remove(in);
                    writerMap.put(doc, o2);
                }
                return doc;
            }
            return GraphManager.createXmlDocument(new InputSource(in), validate, er, null);
        }
        catch (Schema2BeansException e) {
            throw new Schema2BeansRuntimeException(e);
        }
        catch (IOException e) {
            throw new Schema2BeansRuntimeException(e);
        }
    }

    public static Document createXmlDocument(InputSource in, boolean validate) throws Schema2BeansException {
        return GraphManager.createXmlDocument(in, validate, null, null);
    }

    public static Document createXmlDocument(InputSource in, boolean validate, EntityResolver er, ErrorHandler eh) throws Schema2BeansException {
        if (!validate && er == null) {
            er = NullEntityResolver.newInstance();
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(validate);
            DocumentBuilder db = dbf.newDocumentBuilder();
            if (er != null) {
                db.setEntityResolver(er);
            }
            if (eh != null) {
                db.setErrorHandler(eh);
            }
            if (DDLogFlags.debug) {
                System.out.println("createXmlDocument: validate=" + validate + " dbf=" + dbf + " db=" + db + " er=" + er);
            }
            return db.parse(in);
        }
        catch (ParserConfigurationException e) {
            throw new Schema2BeansNestedException(Common.getMessage("CantCreateXMLDOMDocument_msg"), e);
        }
        catch (SAXException e) {
            throw new Schema2BeansNestedException(Common.getMessage("CantCreateXMLDOMDocument_msg"), e);
        }
        catch (IOException e) {
            throw new Schema2BeansNestedException(Common.getMessage("CantCreateXMLDOMDocument_msg"), e);
        }
    }

    public void fillProperties(BeanProp[] prop, Node node) throws Schema2BeansException {
        boolean found = false;
        if (prop == null || node == null) {
            return;
        }
        if (this.bindingsMap.get(node) == null) {
            throw new Schema2BeansException(Common.getMessage("CurrentNodeHasNoBinding_msg", new Integer(node.hashCode())));
        }
        Node n = node.getFirstChild();
        while (n != null) {
            if (n.getNodeType() == 1) {
                String eltName = n.getNodeName();
                int i = 0;
                while (i < prop.length) {
                    if (prop[i].dtdName.equals(eltName)) {
                        DOMBinding newBinding;
                        String s;
                        found = true;
                        DOMBinding binding = (DOMBinding)this.bindingsMap.get(n);
                        if (DDLogFlags.debug) {
                            s = eltName + " N(" + n.hashCode() + ") - " + (binding == null ? "new node" : "already bound B(" + binding.hashCode() + ")");
                            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 9, s);
                        }
                        if ((newBinding = prop[i].registerDomNode(n, binding, null)) == null) break;
                        BaseBean bean = Common.isBean(prop[i].type) ? (BaseBean)newBinding.getBean(prop[i]) : null;
                        if (DDLogFlags.debug) {
                            s = "B(" + newBinding.hashCode() + ") - " + prop[i].getPropClass().getName();
                            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 10, s);
                        }
                        if (bean == null) break;
                        if (binding == null) {
                            this.bindingsMap.put(n, newBinding);
                        }
                        bean.createBean(n, this);
                        break;
                    }
                    ++i;
                }
                if (!found && DDLogFlags.debug) {
                    TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 11, eltName);
                }
            } else {
                short t = n.getNodeType();
                String v = n.getNodeValue();
                if (DDLogFlags.debug) {
                    TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 12, DDFactory.typeToString(t) + " = " + Common.dumpHex(v));
                }
            }
            n = n.getNextSibling();
        }
    }

    public BaseBean getPropertyParent(String name) {
        if (!name.startsWith("/")) {
            throw new IllegalArgumentException(Common.getMessage("NameShouldStartWithSlash_msg", name));
        }
        BaseBean curBean = null;
        int i1 = 0;
        do {
            String indexName;
            int i2;
            if ((i1 = name.indexOf(47, i1)) == -1) continue;
            if ((i2 = name.indexOf(47, ++i1)) == -1) {
                if (curBean != null) break;
                curBean = this.root;
                break;
            }
            String beanName = name.substring(i1, i2);
            int i = beanName.indexOf(46);
            if (i != -1) {
                indexName = beanName.substring(i + 1);
                beanName = beanName.substring(0, i);
                if (indexName.indexOf(105) != -1) {
                    throw new IllegalStateException(Common.getMessage("CantFindBeanBecausePartOfNameRemoved_msg", beanName, name));
                }
            } else {
                indexName = "0";
            }
            if ((curBean = curBean == null ? this.root : curBean.propertyById(beanName, Integer.parseInt(indexName, 16))) != null) continue;
            throw new IllegalStateException(Common.getMessage("CantFindBeanMayHaveBeenRemoved_msg", beanName, name));
        } while (i1 != -1);
        return curBean;
    }

    public String getKeyPropertyName(String propName, String[] prop, String[] key) {
        return this.getKeyPropertyName(propName, prop, key, false);
    }

    public String getKeyPropertyName(String propName) {
        return this.getKeyPropertyName(propName, null, null, true);
    }

    public String getKeyPropertyName(String propName, String[] prop, String[] key, boolean keyName) {
        StringBuffer keyPropName = new StringBuffer();
        BaseBean curBean = this.root;
        String name = propName;
        if (name.charAt(0) == '/') {
            name = name.substring(1);
        }
        do {
            String indexName;
            String beanName;
            int i;
            if ((i = name.indexOf(47)) != -1) {
                beanName = name.substring(0, i);
                name = name.substring(i + 1);
            } else {
                beanName = name;
                name = null;
            }
            i = beanName.indexOf(46);
            if (i != -1) {
                indexName = beanName.substring(i + 1);
                beanName = beanName.substring(0, i);
                if (indexName.indexOf(105) != -1) {
                    throw new IllegalStateException(Common.getMessage("CantFindBeanBecausePartOfNameRemoved_msg", beanName, propName));
                }
            } else {
                indexName = "0";
            }
            curBean = this.root.hasName(beanName) ? this.root : (curBean.getProperty(beanName).isBean() ? curBean.propertyById(beanName, Integer.parseInt(indexName, 16)) : null);
            keyPropName.append(beanName);
            if (prop != null && curBean != null) {
                i = 0;
                while (i < prop.length) {
                    if (prop[i].equals(beanName)) {
                        keyPropName.append(".");
                        keyPropName.append(key[i]);
                        keyPropName.append("=");
                        String v = (String)curBean.getValue(key[i], 0);
                        if (v == null) break;
                        keyPropName.append(v);
                        break;
                    }
                    ++i;
                }
            } else if (keyName && curBean != null) {
                BaseProperty[] l = curBean.listProperties();
                i = 0;
                while (i < l.length) {
                    String n = l[i].getName();
                    if (n.toLowerCase().indexOf("name") != -1) {
                        keyPropName.append(".");
                        keyPropName.append(n);
                        keyPropName.append("=");
                        String v = (String)curBean.getValue(n, 0);
                        if (v == null) break;
                        keyPropName.append(v);
                        break;
                    }
                    ++i;
                }
            }
            if (name == null) continue;
            keyPropName.append("/");
        } while (name != null && curBean != null);
        return keyPropName.toString();
    }

    public static String trimPropertyName(String propName) {
        int j;
        StringBuffer name = new StringBuffer();
        int i = 0;
        do {
            if ((j = propName.indexOf(46, i)) == -1) {
                name.append(propName.substring(i));
                continue;
            }
            name.append(propName.substring(i, j));
            i = propName.indexOf(47, j);
        } while (j != -1 && i != -1);
        return name.toString();
    }

    public String getPropertyParentName(String name) {
        int i = name.lastIndexOf(47);
        if (i != -1) {
            name = name.substring(0, i);
        }
        if ((i = name.lastIndexOf(47)) != -1) {
            name = name.substring(i + 1);
        }
        if ((i = name.lastIndexOf(46)) != -1) {
            name = name.substring(0, i);
        }
        return name;
    }

    public String getPropertyName(String name) {
        int i = name.lastIndexOf(47);
        if (i != -1) {
            name = name.substring(i + 1);
        }
        if ((i = name.lastIndexOf(46)) != -1) {
            name = name.substring(0, i);
        }
        if ((i = name.lastIndexOf(58)) != -1) {
            name = name.substring(0, i);
        }
        return name;
    }

    public String getAttributeName(String name) {
        int i = name.lastIndexOf(58);
        name = i != -1 ? name.substring(i + 1) : null;
        return name;
    }

    public boolean isAttribute(String name) {
        int i = name.lastIndexOf(58);
        return i != -1;
    }

    private String extractPropertyIndex(String name) {
        int i = name.lastIndexOf(47);
        if (i != -1) {
            name = name.substring(i + 1);
        }
        if ((i = name.lastIndexOf(46)) != -1) {
            if ((i = (name = name.substring(i + 1)).lastIndexOf(58)) != -1) {
                name = name.substring(0, i);
            }
        } else {
            name = null;
        }
        return name;
    }

    public int getPropertyIndex(String name) {
        String index = this.extractPropertyIndex(name);
        if (index != null) {
            BeanProp bp;
            int i = index.lastIndexOf(105);
            if (i != -1) {
                return Integer.parseInt(index.substring(i + 1));
            }
            BaseBean bean = this.getPropertyParent(name);
            if (bean != null && (bp = bean.beanProp(this.getPropertyName(name))) != null) {
                return bp.idToIndex(Integer.parseInt(index, 16));
            }
        }
        return -1;
    }

    public static void debug(boolean d) {
        DDLogFlags.debug = d;
    }

    public Object defaultScalarValue(int type) {
        switch (type & 0xFF00) {
            case 256: {
                return "";
            }
            case 768: {
                return Boolean.FALSE;
            }
            case 1024: {
                return new Byte(0);
            }
            case 1280: {
                return new Character('\u0000');
            }
            case 1536: {
                return new Short(0);
            }
            case 1792: {
                return new Integer(0);
            }
            case 2048: {
                return new Long(0L);
            }
            case 2304: {
                return new Float(0.0);
            }
            case 2560: {
                return new Double(0.0);
            }
        }
        throw new IllegalArgumentException(Common.getMessage("UnknownType", type));
    }

    public static interface Factory {
        public Document createDocument(InputStream var1, boolean var2);
    }

    public static interface Writer {
        public void write(OutputStream var1, Document var2);
    }
}

