/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.netbeans.modules.schema2beans.GraphNode;

public class GraphLink {
    GraphNode element;
    GraphLink parent;
    GraphLink sibling;
    GraphLink child;
    int propElement = 33;
    int propChildren = 33;
    String name;
    private String defaultValue;
    private Object object;
    private GraphLink lastInGroup = null;
    List extraData = new ArrayList();

    GraphLink(String name) {
        this.name = name;
    }

    boolean isSequenceAnd() {
        return (this.propChildren & 1) == 1;
    }

    boolean isSequenceOr() {
        return (this.propChildren & 2) == 2;
    }

    void setSequence(int prop) {
        this.propChildren = this.propChildren & 0xFF00 | prop;
    }

    void setElementInstance(int instance) {
        this.propElement = this.propElement & 0xF | instance;
    }

    int getElementInstance() {
        return this.propElement & 0xF0;
    }

    void setGroupInstance(int instance) {
        this.propChildren = this.propChildren & 0xF | instance;
    }

    int getGroupInstance() {
        return this.propChildren & 0xF0;
    }

    GraphLink getLastInGroup() {
        return this.lastInGroup;
    }

    void calculateLastInGroup() {
        GraphLink.calculateLastInGroup(this);
    }

    private static void calculateLastInGroup(GraphLink l) {
        while (l != null) {
            GraphLink lastLink;
            if (l.lastInGroup == null) {
                l.lastInGroup = l;
            }
            if (l.element != null && !l.element.getMarked()) {
                l.element.setMarked(true);
                GraphLink.calculateLastInGroup(l.element.getGraphLink());
                l.element.setMarked(false);
            }
            GraphLink.calculateLastInGroup(l.child);
            if (l.getGroupInstance() != 32 && (lastLink = l.child) != null) {
                while (lastLink.sibling != null) {
                    lastLink = lastLink.sibling;
                }
                GraphLink child = l.child;
                while (child != null) {
                    child.lastInGroup = lastLink;
                    child = child.sibling;
                }
            }
            l = l.sibling;
        }
    }

    String getDefaultValue() {
        return this.defaultValue;
    }

    void setDefaultValue(String d) {
        this.defaultValue = d;
    }

    void setObject(Object obj) {
        this.object = obj;
    }

    Object getObject() {
        return this.object;
    }

    public XPathIterator xPathIterator(String xpath) {
        return new XPathIterator(this, xpath);
    }

    public static class XPathIterator
    implements Iterator {
        private String xpath;
        private String step;
        private GraphLink curLink;
        private int position;

        public XPathIterator(GraphLink startingLink, String xpath) {
            this.xpath = xpath;
            this.curLink = startingLink;
            this.findNextStep();
        }

        private void findNextStep() {
            if (this.position >= this.xpath.length()) {
                this.step = null;
                return;
            }
            int startingPos = this.position;
            while (this.position < this.xpath.length()) {
                if (this.xpath.charAt(this.position) == '/') {
                    this.step = this.xpath.substring(startingPos, this.position);
                    ++this.position;
                    if (".".equals(this.step)) {
                        startingPos = this.position;
                    } else {
                        return;
                    }
                }
                ++this.position;
            }
            this.step = this.xpath.substring(startingPos, this.position);
            if (startingPos > 0 && ".".equals(this.step)) {
                this.step = null;
            }
        }

        public boolean hasNext() {
            return this.step != null;
        }

        public Object next() {
            if (this.step == null) {
                throw new NoSuchElementException();
            }
            GraphLink result = this.curLink;
            while (".".equals(this.step)) {
                this.findNextStep();
                if (this.step != null) continue;
                return result;
            }
            int colonPos = this.step.indexOf(58);
            if (colonPos >= 0) {
                this.step = this.step.substring(colonPos + 1, this.step.length());
            }
            while (result != null) {
                if (this.step.equals(result.name)) break;
                if (result.sibling != null) {
                    result = result.sibling;
                    continue;
                }
                if (result.child != null) {
                    result = result.child;
                    continue;
                }
                this.step = null;
                this.position = this.xpath.length();
                return null;
            }
            this.curLink = result.element == null ? null : result.element.getGraphLink();
            this.findNextStep();
            return result;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

