/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.DocDefHandler;
import org.netbeans.modules.schema2beans.GenBeans;
import org.netbeans.modules.schema2beans.GeneralParser;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.schema2beans.SchemaParseException;
import org.netbeans.modules.schema2beans.SchemaParser;

public class DocDefParser
extends GeneralParser
implements SchemaParser {
    private static final int WORD_NO_CONTEXT = 0;
    private static final int WORD_CHECK = 1;
    private static final int WORD_COMMENT = 2;
    private static final int WORD_ELEMENT1 = 3;
    private static final int WORD_ELEMENT = 4;
    private static final int WORD_ATTLIST1 = 5;
    private static final int WORD_ATTLIST = 6;
    private static final int WORD_PI = 7;
    static String errHeader = "DTD parsing failed: ";
    private char[] buffer = new char[BUFFER_SIZE];
    private int bufSize;
    private int bufScan;
    protected static int BUFFER_SIZE = 4096;
    private DocDefHandler handler;
    private GenBeans.Config config = null;

    public DocDefParser() {
    }

    public DocDefParser(GenBeans.Config config, DocDefHandler handler) {
        this.config = config;
        this.filename = config.filename;
        this.schemaIn = config.fileIn;
        this.handler = handler;
    }

    public void setFilename(String filename) {
        this.filename = new String(filename);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setHandler(DocDefHandler handler) {
        this.handler = handler;
    }

    public DocDefHandler getHandler() {
        return this.handler;
    }

    protected boolean checkBuffer() throws IOException {
        if (this.bufScan >= this.bufSize) {
            this.bufSize = this.reader.read(this.buffer);
            if (this.bufSize == -1) {
                return false;
            }
            this.bufScan = 0;
        }
        return true;
    }

    protected char getNext() throws IOException {
        if (this.checkBuffer()) {
            return this.buffer[this.bufScan++];
        }
        return '\u0000';
    }

    protected char peekNext() throws IOException {
        if (this.checkBuffer()) {
            return this.buffer[this.bufScan];
        }
        return '\u0000';
    }

    private int getInstanceValue(char c) {
        switch (c) {
            case '*': {
                return 48;
            }
            case '+': {
                return 64;
            }
            case '?': {
                return 16;
            }
        }
        return 32;
    }

    private int processWord(StringBuffer curWord, int wordContext) throws SchemaParseException {
        String word = curWord.toString();
        int len = word.length();
        if (len > 0) {
            switch (wordContext) {
                case 1: {
                    if (word.startsWith("--")) {
                        word = len > 2 ? curWord.substring(2) : "";
                        this.handler.startElement(word, 1);
                        wordContext = 2;
                        break;
                    }
                    if (word.equals("ELEMENT")) {
                        wordContext = 3;
                        break;
                    }
                    if (word.equals("ATTLIST")) {
                        wordContext = 5;
                        break;
                    }
                    throw new SchemaParseException("Error: found an unknown '<!' sequence (" + word + ")");
                }
                case 2: {
                    this.handler.element(word, 0);
                    break;
                }
                case 3: {
                    this.handler.startElement(word, 2);
                    wordContext = 4;
                    break;
                }
                case 5: {
                    this.handler.startElement(word, 3);
                    wordContext = 6;
                    break;
                }
                case 4: 
                case 6: {
                    int instance = this.getInstanceValue(word.charAt(len - 1));
                    if (instance != 32) {
                        word = curWord.substring(0, len - 1);
                    }
                    try {
                        this.handler.element(word, instance);
                    }
                    catch (MissingEndOfEltException e) {
                        if (wordContext != 6) break;
                        this.handler.startElement(e.propName, 3);
                        this.handler.element(word, instance);
                    }
                    break;
                }
            }
            curWord.delete(0, len);
        }
        return wordContext;
    }

    /*
     * WARNING - void declaration
     */
    void parse() throws IOException, SchemaParseException {
        char c;
        StringBuffer curWord = new StringBuffer();
        int wordContext = 0;
        boolean level = false;
        block13: while ((c = this.getNext()) != '\u0000') {
            void var1_4;
            block0 : switch (var1_4) {
                case 60: {
                    char c1 = this.getNext();
                    if (c1 == '!') {
                        if (wordContext != 0 && wordContext != 2) {
                            System.err.println("Error: found a '<!' sequence within another '<!' sequence");
                            throw new SchemaParseException("Warning: found a '<!' sequence within another '<!' sequence");
                        }
                        if (wordContext == 2) continue block13;
                        wordContext = 1;
                        break;
                    }
                    if (c1 == '?') {
                        wordContext = 7;
                        break;
                    }
                    curWord.append((char)var1_4);
                    curWord.append(c1);
                    break;
                }
                case 62: {
                    switch (wordContext) {
                        case 0: {
                            throw new SchemaParseException("Error: Found '>' without '<!'");
                        }
                        case 7: {
                            String word = curWord.toString();
                            int len = word.length();
                            if (word.endsWith("?")) {
                                curWord.delete(0, len);
                                wordContext = 0;
                                break block0;
                            }
                            curWord.append((char)var1_4);
                            break block0;
                        }
                        case 2: {
                            String word = curWord.toString();
                            int len = word.length();
                            if (word.endsWith("--")) {
                                this.handler.endElement();
                                curWord.delete(0, len);
                                wordContext = 0;
                                break block0;
                            }
                            curWord.append((char)var1_4);
                            break block0;
                        }
                    }
                    wordContext = this.processWord(curWord, wordContext);
                    this.handler.endElement();
                    wordContext = 0;
                    break;
                }
                case 40: {
                    if (wordContext == 4 || wordContext == 6) {
                        wordContext = this.processWord(curWord, wordContext);
                        this.handler.startGroupElements();
                        break;
                    }
                    curWord.append((char)var1_4);
                    break;
                }
                case 41: {
                    wordContext = this.processWord(curWord, wordContext);
                    if (wordContext == 4 || wordContext == 6) {
                        int instance = this.getInstanceValue(this.peekNext());
                        if (instance != 32) {
                            this.getNext();
                        }
                        this.handler.endGroupElements(instance);
                        break;
                    }
                    curWord.append((char)var1_4);
                    break;
                }
                case 124: {
                    wordContext = this.processWord(curWord, wordContext);
                    if (wordContext == 4 || wordContext == 6) {
                        this.handler.character((char)var1_4);
                        break;
                    }
                    curWord.append((char)var1_4);
                    break;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: 
                case 44: {
                    wordContext = this.processWord(curWord, wordContext);
                    break;
                }
                default: {
                    curWord.append((char)var1_4);
                }
            }
        }
        if (wordContext != 0) {
            System.out.println("Warning: unexpected EOF");
        }
    }

    public void process() throws IOException, Schema2BeansException {
        if (this.filename == null && this.schemaIn == null) {
            throw new IllegalArgumentException(Common.getMessage("FilenameNotSpecified_msg", errHeader));
        }
        if (this.handler == null) {
            throw new IllegalArgumentException(Common.getMessage("HandlerNotSpecified_msg", errHeader));
        }
        if (this.config.getTraceParse()) {
            this.config.messageOut.println("Parsing file " + this.filename + " with handler " + this.handler.getClass());
        }
        try {
            this.startupReader();
            this.handler.startDocument(this.config.docroot);
            this.parse();
            this.shutdownReader();
            this.handler.endDocument();
        }
        catch (FileNotFoundException e) {
            this.config.messageOut.println("Error: file " + this.filename + " not found");
            throw e;
        }
    }

    static class MissingEndOfEltException
    extends RuntimeException {
        String propName;

        public MissingEndOfEltException(String propName) {
            this.propName = propName;
        }
    }
}

