/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.ListUtil;
import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import com.sun.enterprise.management.support.TypeData;
import com.sun.enterprise.management.support.TypeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;

public final class TypeInfos {
    private static TypeInfos INSTANCE;
    private final Map mTypeToInfoMap = new HashMap();
    private static final Set CLUSTER_OR_SERVER_CONFIG;
    private static TypeData[] DATA;
    static final /* synthetic */ boolean $assertionsDisabled;

    private TypeInfos() throws ClassNotFoundException {
        this.initMap();
    }

    public static synchronized TypeInfos getInstance() {
        try {
            if (INSTANCE == null) {
                INSTANCE = new TypeInfos();
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            throw new RuntimeException(e);
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            throw new RuntimeException(t);
        }
        return INSTANCE;
    }

    private void add(TypeData typeData) throws ClassNotFoundException {
        String j2eeType = typeData.getJ2EEType();
        TypeInfo info = new TypeInfo(typeData);
        this.mTypeToInfoMap.put(j2eeType, info);
    }

    private void initData() throws ClassNotFoundException {
        TypeData[] data = DATA;
        for (int i = 0; i < data.length; ++i) {
            TypeData typeData = data[i];
            if (!$assertionsDisabled && this.mTypeToInfoMap.containsKey(typeData.getJ2EEType())) {
                throw new AssertionError((Object)("init(): type already exists: " + typeData.getJ2EEType()));
            }
            this.add(typeData);
        }
    }

    private void initParentsForChildType(TypeInfo info) {
        if (info.isSubType()) {
            Set possibleParents = info.getLegalParentJ2EETypes();
            Iterator parentTypeIter = possibleParents.iterator();
            while (parentTypeIter.hasNext()) {
                String parentJ2EEType = (String)parentTypeIter.next();
                TypeInfo parentInfo = this.getInfo(parentJ2EEType);
                parentInfo.addChildJ2EEType(info.getJ2EEType());
            }
        }
    }

    private void initChildAndContaineeTypes() {
        Set keys = this.getJ2EETypes();
        Iterator childIter = keys.iterator();
        while (childIter.hasNext()) {
            String childJ2EEType = (String)childIter.next();
            TypeInfo info = this.getInfo(childJ2EEType);
            if (info.isSubType()) {
                this.initParentsForChildType(info);
                continue;
            }
            String containedByJ2EEType = info.getContainedByJ2EEType();
            if (containedByJ2EEType == null) continue;
            TypeInfo parentInfo = this.getInfo(containedByJ2EEType);
            parentInfo.addContaineeJ2EEType(childJ2EEType);
        }
    }

    private void initMap() throws ClassNotFoundException {
        this.initData();
        this.initChildAndContaineeTypes();
    }

    public TypeInfo getInfo(String j2eeType) {
        if (j2eeType == null) {
            throw new IllegalArgumentException("null");
        }
        TypeInfo info = (TypeInfo)this.mTypeToInfoMap.get(j2eeType);
        if (info == null) {
            throw new IllegalArgumentException(j2eeType);
        }
        return info;
    }

    public Set getJ2EETypes() {
        return this.mTypeToInfoMap.keySet();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Set keys = this.getJ2EETypes();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String j2eeType = (String)iter.next();
            TypeInfo info = this.getInfo(j2eeType);
            buf.append(info.toString());
            buf.append("\n");
        }
        return buf.toString();
    }

    public String[] getContaineeByChain(String j2eeType) {
        TypeInfo info = this.getInfo(j2eeType);
        if (info.isSubType()) {
            throw new IllegalArgumentException("j2eeType is a subtype: " + j2eeType);
        }
        ArrayList<String> list = new ArrayList<String>();
        String containedByType = null;
        while ((containedByType = info.getContainedByJ2EEType()) != null) {
            list.add(containedByType);
            info = this.getInfo(containedByType);
        }
        Collections.reverse(list);
        return ListUtil.toStringArray(list);
    }

    public String[] getJ2EETypeChain(ObjectName objectName) {
        String j2eeType = Util.getJ2EEType(objectName);
        if (j2eeType == null) {
            throw new IllegalArgumentException(objectName.toString());
        }
        TypeInfo info = this.getInfo(j2eeType);
        if (info == null) {
            throw new IllegalArgumentException("uknown j2eeType: " + j2eeType);
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(j2eeType);
        while (info.isSubType()) {
            Set possibleParentTypes = info.getLegalParentJ2EETypes();
            String parentJ2EEType = null;
            parentJ2EEType = possibleParentTypes.size() == 1 ? (String)SetUtil.getSingleton(possibleParentTypes) : JMXUtil.findKey(possibleParentTypes, objectName);
            if (parentJ2EEType == null) {
                throw new IllegalArgumentException("MBean: " + objectName + " does not have any of the possible parent keys: {" + this.toString(possibleParentTypes) + "}");
            }
            list.add(parentJ2EEType);
            info = this.getInfo(parentJ2EEType);
        }
        Collections.reverse(list);
        return ListUtil.toStringArray(list);
    }

    private String toString(Object o) {
        return SmartStringifier.toString(o);
    }

    static {
        $assertionsDisabled = !TypeInfos.class.desiredAssertionStatus();
        CLUSTER_OR_SERVER_CONFIG = SetUtil.newSet("X-ClusterConfig", "X-StandaloneServerConfig", "X-ClusteredServerConfig");
        DATA = new TypeData[]{new MiscChild("X-DomainRoot", null, null), new DomainRootChild("X-SystemInfo"), new DomainRootChild("X-UploadDownloadMgr"), new DomainRootChild("X-DomainConfig"), new DomainRootChild("X-NotificationServiceMgr"), new DomainRootChild("X-DeploymentMgr"), new DomainRootChild("X-QueryMgr"), new DomainRootChild("X-BulkAccess"), new DomainRootChild("X-Sample"), new DomainRootChild("X-ConfigDottedNames"), new DomainRootChild("X-MonitoringDottedNames"), new MiscChild("X-NotificationService", "X-NotificationServiceMgr"), new DomainConfigChild("X-ConfigConfig"), new DomainConfigChild("X-WebModuleConfig"), new DomainConfigChild("X-EJBModuleConfig"), new DomainConfigChild("X-J2EEApplicationConfig"), new DomainConfigChild("X-RARModuleConfig"), new DomainConfigChild("X-AppClientModuleConfig"), new DomainConfigChild("X-NodeAgentConfig"), new DomainConfigChild("X-ResourceAdapterConfig"), new DomainConfigChild("X-LifecycleModuleConfig"), new DomainConfigChild("X-SystemPropertiesConfig"), new DomainConfigChild("X-LBConfig"), new DomainConfigChild("X-ClusterConfig"), new DomainConfigChild("X-StandaloneServerConfig"), new DomainConfigChild("X-ConnectorModuleConfig"), new DomainConfigChild("X-ClusteredServerConfig"), new ConfigResource("X-ConnectorConnectionPoolConfig"), new ConfigResource("X-CustomResourceConfig"), new ConfigResource("X-JDBCResourceConfig"), new ConfigResource("X-JMSResourceConfig"), new ConfigResource("X-JNDIResourceConfig"), new ConfigResource("X-PersistenceManagerFactoryResourceConfig"), new ConfigResource("X-MailResourceConfig"), new ConfigResource("X-JDBCConnectionPoolConfig"), new ConfigResource("X-AdminObjectResourceConfig"), new ConfigResource("X-ConnectorResourceConfig"), new AdminServiceConfigChild("X-DASConfig"), new MixedChild("X-JMXConnectorConfig", SetUtil.newSet("X-AdminServiceConfig", "X-NodeAgentConfig")), new SecurityServiceChild("X-AuditModuleConfig"), new MixedChild("X-AuthRealmConfig", SetUtil.newSet("X-SecurityServiceConfig", "X-NodeAgentConfig")), new SecurityServiceChild("X-JACCProviderConfig"), new SecurityServiceChild("X-MessageSecurityConfig"), new ConfigConfigChild("X-AdminServiceConfig"), new ConfigConfigChild("X-AvailabilityServiceConfig"), new ConfigConfigChild("X-EJBContainerConfig"), new ConfigConfigChild("X-HTTPServiceConfig"), new ConfigConfigChild("X-IIOPServiceConfig"), new ConfigConfigChild("X-JavaConfig"), new MixedChild("X-LogServiceConfig", SetUtil.newSet("X-ConfigConfig", "X-NodeAgentConfig")), new ConfigConfigChild("X-MDBContainerConfig"), new ConfigConfigChild("X-MonitoringServiceConfig"), new ConfigConfigChild("X-QuorumServiceConfig"), new ConfigConfigChild("X-SecurityServiceConfig"), new ConfigConfigChild("X-ConnectorServiceConfig"), new ConfigConfigChild("X-WebContainerConfig"), new ConfigConfigChild("X-TransactionServiceConfig"), new ConfigConfigChild("X-JMSServiceConfig"), new ConfigConfigChild("X-ThreadPoolConfig"), new HTTPServiceChild("X-HTTPListenerConfig"), new HTTPServiceChild("X-AccessLogConfig"), new HTTPServiceChild("X-KeepAliveConfig"), new HTTPServiceChild("X-RequestProcessingConfig"), new HTTPServiceChild("X-ConnectionPoolConfig"), new HTTPServiceChild("X-HTTPProtocolConfig"), new HTTPServiceChild("X-HTTPFileCacheConfig"), new HTTPServiceChild("X-VirtualServerConfig"), new IIOPServiceChild("X-IIOPListenerConfig"), new IIOPServiceChild("X-ORBConfig"), new MiscChild("X-ProfilerConfig", "X-JavaConfig"), new MiscChild("X-JMSHostConfig", "X-JMSServiceConfig"), new MiscChild("X-HTTPAccessLogConfig", "X-VirtualServerConfig"), new MiscChild("X-LBClusterRefConfig", "X-LBConfig"), new MiscChild("X-ModuleLogLevelsConfig", "X-LogServiceConfig"), new MiscChild("X-ModuleMonitoringLevelsConfig", "X-MonitoringServiceConfig"), new MiscChild("X-SessionConfig", "X-WebContainerConfig"), new MiscChild("X-SessionManagerConfig", "X-SessionConfig"), new MiscChild("X-SessionPropertiesConfig", "X-SessionConfig"), new MiscChild("X-ManagerPropertiesConfig", "X-SessionManagerConfig"), new MiscChild("X-StorePropertiesConfig", "X-SessionManagerConfig"), new MiscChild("X-EJBTimerServiceConfig", "X-EJBContainerConfig"), new MiscChild("X-EJBContainerAvailabilityConfig", "X-AvailabilityServiceConfig"), new MiscChild("X-WebContainerAvailabilityConfig", "X-AvailabilityServiceConfig"), new MixedChild("X-DeployedItemRefConfig", CLUSTER_OR_SERVER_CONFIG), new MixedChild("X-ResourceRefConfig", CLUSTER_OR_SERVER_CONFIG), new MixedChild("X-SSLConfig", SetUtil.newSet("X-IIOPListenerConfig", "X-IIOPServiceConfig", "X-HTTPListenerConfig", "X-JMXConnectorConfig")), new MixedChild("X-HealthCheckerConfig", SetUtil.newSet("X-ServerRefConfig", "X-LBClusterRefConfig")), new MiscChild("X-ServerRefConfig", "X-ClusterConfig"), new MiscChild("X-ProviderConfig", "X-MessageSecurityConfig"), new MiscChild("X-RequestPolicyConfig", "X-ProviderConfig"), new MiscChild("X-ResponsePolicyConfig", "X-ProviderConfig"), new DomainRootChild("J2EEDomain"), new J2EEDomainChild("X-J2EECluster"), new J2EEDomainChild("J2EEServer"), new J2EEServerChild("JVM"), new J2EEServerChild("J2EEApplication"), new J2EEServerChild("JDBCDriver"), new J2EEServerChild("JDBCResource"), new J2EEServerChild("JMSResource"), new J2EEServerChild("JNDIResource"), new J2EEServerChild("JTAResource"), new J2EEServerChild("ResourceAdapterModule"), new J2EEServerChild("RMI_IIOPResource"), new J2EEServerChild("URL_Resource"), new J2EEServerChild("JavaMailResource"), new J2EEServerChild("JCAResource"), new MiscChild("AppClientModule", "J2EEApplication"), new MiscChild("EJBModule", "J2EEApplication"), new MiscChild("WebModule", "J2EEApplication"), new MiscChild("ResourceAdapter", "ResourceAdapterModule"), new EJBModuleChild("EntityBean"), new EJBModuleChild("StatefulSessionBean"), new EJBModuleChild("MessageDrivenBean"), new EJBModuleChild("StatelessSessionBean"), new MiscChild("JCAConnectionFactory", "JCAResource"), new MiscChild("JCAManagedConnectionFactory", "JCAResource"), new MiscChild("JDBCDataSource", "JDBCResource"), new MiscChild("Servlet", "WebModule"), new DomainRootChild("X-JMXMonitorMgr"), new DomainRootChild("X-AMXCounterMonitor"), new DomainRootChild("X-AMXGaugeMonitor"), new DomainRootChild("X-AMXStringMonitor"), new DomainRootChild("X-MonitoringRoot"), new Containee("X-ServerRootMonitor", "X-MonitoringRoot"), new ServerRootMonitorChild("X-JVMMonitor"), new ServerRootMonitorChild("X-TransactionServiceMonitor"), new ServerRootMonitorChild("X-HTTPServiceMonitor"), new ServerRootMonitorChild("X-JDBCConnectionPoolMonitor"), new ServerRootMonitorChild("X-ApplicationMonitor"), new MiscChild("X-WebModuleVirtualServerMonitor", "X-ApplicationMonitor"), new MiscChild("X-ServletMonitor", "X-WebModuleVirtualServerMonitor"), new MiscChild("X-EJBModuleMonitor", "X-ApplicationMonitor"), new MiscChild("X-StatelessSessionBeanMonitor", "X-EJBModuleMonitor"), new MiscChild("X-StatefulSessionBeanMonitor", "X-EJBModuleMonitor"), new MiscChild("X-EntityBeanMonitor", "X-EJBModuleMonitor"), new MiscChild("X-MessageDrivenBeanMonitor", "X-EJBModuleMonitor"), new MiscChild("X-BeanPoolMonitor", SetUtil.newSet("X-EntityBeanMonitor", "X-StatefulSessionBeanMonitor", "X-StatelessSessionBeanMonitor")), new MiscChild("X-BeanCacheMonitor", SetUtil.newSet("X-EntityBeanMonitor", "X-MessageDrivenBeanMonitor", "X-StatefulSessionBeanMonitor", "X-StatelessSessionBeanMonitor")), new MiscChild("X-BeanMethodMonitor", SetUtil.newSet("X-EntityBeanMonitor", "X-StatefulSessionBeanMonitor", "X-StatelessSessionBeanMonitor", "X-MessageDrivenBeanMonitor")), new ServerRootMonitorChild("X-ConnectorConnectionPoolMonitor"), new ServerRootMonitorChild("X-ThreadPoolMonitor"), new ServerRootMonitorChild("X-ConnectionManagerMonitor"), new MiscChild("X-HTTPServiceVirtualServerMonitor", "X-HTTPServiceMonitor"), new HTTPServiceMonitorChild("X-HTTPListenerMonitor"), new MiscChild("X-NativeWebCoreVirtualServerRequestMonitor", "X-HTTPServiceVirtualServerMonitor"), new HTTPServiceMonitorChild("X-FileCacheMonitor"), new HTTPServiceMonitorChild("X-NativeWebCoreThreadPoolMonitor"), new HTTPServiceMonitorChild("X-KeepAliveMonitor"), new HTTPServiceMonitorChild("X-DNSMonitor"), new HTTPServiceMonitorChild("X-ConnectionQueueMonitor")};
    }

    private static final class EJBModuleChild
    extends TypeData {
        public EJBModuleChild(String j2eeType) {
            super(j2eeType, "EJBModule");
        }
    }

    private static final class HTTPServiceMonitorChild
    extends TypeData {
        public HTTPServiceMonitorChild(String j2eeType) {
            super(j2eeType, "X-HTTPServiceMonitor");
        }
    }

    private static final class ServerRootMonitorChild
    extends TypeData {
        public ServerRootMonitorChild(String j2eeType) {
            super(j2eeType, "X-ServerRootMonitor");
        }
    }

    private static final class J2EEDomainChild
    extends TypeData {
        public J2EEDomainChild(String j2eeType) {
            super(j2eeType, null, "J2EEDomain");
        }
    }

    private static final class J2EEServerChild
    extends TypeData {
        public J2EEServerChild(String j2eeType) {
            super(j2eeType, "J2EEServer");
        }
    }

    private static final class AdminServiceConfigChild
    extends TypeData {
        public AdminServiceConfigChild(String j2eeType) {
            super(j2eeType, "X-AdminServiceConfig");
        }
    }

    private static final class IIOPServiceChild
    extends TypeData {
        public IIOPServiceChild(String j2eeType) {
            super(j2eeType, "X-IIOPServiceConfig");
        }
    }

    private static final class HTTPServiceChild
    extends TypeData {
        public HTTPServiceChild(String j2eeType) {
            super(j2eeType, "X-HTTPServiceConfig");
        }
    }

    private static final class SecurityServiceChild
    extends TypeData {
        public SecurityServiceChild(String j2eeType) {
            super(j2eeType, "X-SecurityServiceConfig");
        }
    }

    private static final class ResourceConfigMgr
    extends TypeData {
        public ResourceConfigMgr(String j2eeType) {
            super(j2eeType, null, "X-DomainConfig");
        }
    }

    private static final class ConfigResource
    extends TypeData {
        public ConfigResource(String j2eeType) {
            super(j2eeType, null, "X-DomainConfig");
        }
    }

    private static final class ConfigConfigChild
    extends TypeData {
        public ConfigConfigChild(String j2eeType) {
            super(j2eeType, "X-ConfigConfig");
        }
    }

    private static class DomainConfigChild
    extends TypeData {
        public DomainConfigChild(String j2eeType) {
            super(j2eeType, null, "X-DomainConfig");
        }
    }

    private static final class DomainRootChild
    extends TypeData {
        public DomainRootChild(String j2eeType) {
            super(j2eeType, null, "X-DomainRoot");
        }
    }

    private static final class MixedChild
    extends TypeData {
        public MixedChild(String j2eeType, Set legalParentJ2EETypes) {
            super(j2eeType, legalParentJ2EETypes);
        }
    }

    private static final class Containee
    extends TypeData {
        public Containee(String j2eeType, String containerType) {
            super(j2eeType, null, containerType);
        }
    }

    private static final class MiscChild
    extends TypeData {
        public MiscChild(String j2eeType, String parentJ2EEType) {
            super(j2eeType, parentJ2EEType);
        }

        public MiscChild(String j2eeType, Set legalParentJ2EETypes) {
            super(j2eeType, legalParentJ2EETypes);
        }

        public MiscChild(String j2eeType, Set legalParentJ2EETypes, String containedByJ2EEType) {
            super(j2eeType, legalParentJ2EETypes, containedByJ2EEType);
        }
    }
}

