/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.base.AllTypesMapper;
import com.sun.appserv.management.util.misc.ClassUtil;
import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import com.sun.enterprise.management.support.TypeData;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class TypeInfo {
    private final TypeData mTypeData;
    private final Set mChildJ2EETypes;
    private final Set mNonChildJ2EETypes;
    private final Class mInterface;
    private final Class mImplClass;
    private static final String[] IMPL_PACKAGES;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TypeInfo(TypeData typeData) throws ClassNotFoundException {
        this.mTypeData = typeData;
        this.mInterface = TypeInfo.deriveInterface(typeData.getJ2EEType());
        this.mImplClass = TypeInfo.deriveImplClass(this.mInterface);
        this.mChildJ2EETypes = new HashSet();
        this.mNonChildJ2EETypes = new HashSet();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String PR = "\n  ";
        buf.append(this.getJ2EEType() + ": ");
        buf.append("\n  parent type = " + SmartStringifier.toString(this.getLegalParentJ2EETypes()));
        buf.append("\n  child types = " + SmartStringifier.toString(this.mChildJ2EETypes));
        buf.append("\n  mbean = " + this.mInterface.getName());
        buf.append("\n  impl = " + this.mImplClass.getName());
        buf.append("\n");
        return buf.toString();
    }

    private static Class deriveInterface(String j2eeType) throws ClassNotFoundException {
        return AllTypesMapper.getInstance().getInterfaceForType(j2eeType);
    }

    private static String getBaseName(String mbeanClassName) {
        String classname = ClassUtil.stripPackageName(mbeanClassName);
        int mbeanStart = classname.lastIndexOf("MBean");
        String baseName = mbeanStart < 0 ? classname : classname.substring(0, mbeanStart);
        return baseName;
    }

    private static Class deriveImplClass(Class mbeanInterface) throws ClassNotFoundException {
        String baseName;
        String implClass = baseName = TypeInfo.getBaseName(mbeanInterface.getName());
        return TypeInfo.locateImplClass(implClass);
    }

    private static Class locateImplClass(String packageName, String baseName) {
        String implClassname = packageName + "." + baseName + "Impl";
        Class implClass = null;
        try {
            implClass = ClassUtil.getClassFromName(implClassname);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        return implClass;
    }

    private static Class locateImplClass(String classname) throws ClassNotFoundException {
        Class implClass = null;
        for (int i = 0; i < IMPL_PACKAGES.length && (implClass = TypeInfo.locateImplClass(IMPL_PACKAGES[i], classname)) == null; ++i) {
        }
        if (implClass == null) {
            throw new ClassNotFoundException(classname);
        }
        return implClass;
    }

    public void addChildJ2EEType(String j2eeType) {
        if (!$assertionsDisabled && j2eeType.equals(this.getJ2EEType())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mNonChildJ2EETypes.contains(j2eeType)) {
            throw new AssertionError();
        }
        this.mChildJ2EETypes.add(j2eeType);
    }

    public void addContaineeJ2EEType(String j2eeType) {
        if (!$assertionsDisabled && j2eeType.equals(this.getJ2EEType())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mChildJ2EETypes.contains(j2eeType)) {
            throw new AssertionError();
        }
        this.mNonChildJ2EETypes.add(j2eeType);
    }

    public String getJ2EEType() {
        return this.mTypeData.getJ2EEType();
    }

    public Set getLegalParentJ2EETypes() {
        return this.mTypeData.getLegalParentJ2EETypes();
    }

    public String getContainedByJ2EEType() {
        return this.mTypeData.getContaineeByJ2EEType();
    }

    public boolean isSubType() {
        return this.mTypeData.isSubType();
    }

    public Class getInterface() {
        return this.mInterface;
    }

    public Class getImplClass() {
        return this.mImplClass;
    }

    public String getParentJ2EEType() {
        Set legalParentJ2EETypes = this.getLegalParentJ2EETypes();
        if (legalParentJ2EETypes == null) {
            throw new IllegalArgumentException("no legal parent types for: " + this.getJ2EEType());
        }
        if (legalParentJ2EETypes.size() != 1) {
            throw new IllegalArgumentException("expecting single parent for " + this.getJ2EEType() + ", have: " + TypeInfo.toString(legalParentJ2EETypes));
        }
        return (String)SetUtil.getSingleton(legalParentJ2EETypes);
    }

    public Set getChildJ2EETypes() {
        return Collections.unmodifiableSet(this.mChildJ2EETypes);
    }

    public Set getNonChildJ2EETypes() {
        return Collections.unmodifiableSet(this.mNonChildJ2EETypes);
    }

    public Set getContaineeJ2EETypes() {
        Set all = SetUtil.newSet(this.mChildJ2EETypes, this.mNonChildJ2EETypes);
        return Collections.unmodifiableSet(all);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypeInfo)) {
            return false;
        }
        TypeInfo rhs = (TypeInfo)o;
        boolean equals = false;
        if (this.getJ2EEType().equals(rhs.getJ2EEType()) && this.mInterface == rhs.mInterface && this.mImplClass == rhs.mImplClass && ((Object)this.mChildJ2EETypes).equals(rhs.mChildJ2EETypes) && ((Object)this.getLegalParentJ2EETypes()).equals(rhs.getLegalParentJ2EETypes())) {
            equals = true;
        }
        return equals;
    }

    private static String toString(Object o) {
        return SmartStringifier.toString(o);
    }

    static {
        $assertionsDisabled = !TypeInfo.class.desiredAssertionStatus();
        IMPL_PACKAGES = new String[]{"com.sun.enterprise.management.config", "com.sun.enterprise.management.j2ee", "com.sun.enterprise.management.monitor", "com.sun.enterprise.management.support", "com.sun.enterprise.management.deploy", "com.sun.enterprise.management"};
    }
}

