/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.OverflowHandler;
import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.enterprise.management.support.AMXImplBase;
import com.sun.enterprise.management.support.NotificationBuffer;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public final class NotificationServiceImpl
extends AMXImplBase
implements NotificationListener,
NotificationEmitter {
    private Map mListenees;
    private final Object mUserData;
    private final Map mIncludePatterns;
    private final Map mExcludePatterns;
    private final Map mBuffers;
    private final String[] NOTIF_TYPES = new String[]{"X-NotificationService.BufferOverflow"};
    private static int sBufferID = 0;

    public NotificationServiceImpl(Object userData, int bufferSize) {
        if (userData == null || !(userData instanceof Serializable)) {
            throw new IllegalArgumentException();
        }
        this.mUserData = userData;
        this.mListenees = Collections.synchronizedMap(new HashMap());
        this.mBuffers = Collections.synchronizedMap(new HashMap());
        this.mIncludePatterns = new HashMap();
        this.mExcludePatterns = new HashMap();
    }

    public final Object getUserData() {
        return this.mUserData;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo info = new MBeanNotificationInfo(this.NOTIF_TYPES, Notification.class.getName(), "");
        MBeanNotificationInfo[] selfInfos = new MBeanNotificationInfo[]{info};
        return this.mergeNotificationInfos(super.getNotificationInfo(), selfInfos);
    }

    protected void issueBufferOverflowNotification(Notification oldNotif) {
        if (this.shouldEmitNotifications()) {
            this.sendNotification("X-NotificationService.BufferOverflow", "X-NotificationService.OverflowedNotification", oldNotif);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification notif, Object handback) {
        Map map = this.mBuffers;
        synchronized (map) {
            Iterator iter = this.mBuffers.keySet().iterator();
            while (iter.hasNext()) {
                Object id = iter.next();
                this.getBuffer(id).bufferNotification(notif);
            }
        }
        this.sendNotification(notif);
    }

    private NotificationBuffer getBuffer(Object bufferID) {
        return (NotificationBuffer)this.mBuffers.get(bufferID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createBuffer(int bufferSize, NotificationFilter filter) {
        OverflowHandlerImpl handler = new OverflowHandlerImpl();
        NotificationBuffer buffer = new NotificationBuffer(bufferSize, filter, handler);
        String id = null;
        Map map = this.mBuffers;
        synchronized (map) {
            id = "" + ++sBufferID;
            this.mBuffers.put(id, buffer);
        }
        return id;
    }

    public void removeBuffer(Object bufferID) {
        NotificationBuffer buffer = (NotificationBuffer)this.mBuffers.remove(bufferID);
    }

    public Map getBufferNotifications(Object bufferID, long sequenceNumberIn) {
        NotificationBuffer buffer = this.getBuffer(bufferID);
        return buffer.getNotifications(sequenceNumberIn);
    }

    public String getGroup() {
        return "utility";
    }

    protected Set getMatchingObjectNames(ObjectName pattern) {
        Set<ObjectName> s = null;
        s = pattern.isPattern() ? this.getMBeanServer().queryNames(pattern, null) : SetUtil.newSet(pattern);
        return s;
    }

    protected void listenToIfMatch(ObjectName objectName) {
        if (!this.mListenees.keySet().contains(objectName)) {
            String defaultDomain = this.getMBeanServer().getDefaultDomain();
            Iterator iter = this.mIncludePatterns.keySet().iterator();
            while (iter.hasNext()) {
                ObjectName pattern = (ObjectName)iter.next();
                if (!JMXUtil.matchesPattern(defaultDomain, pattern, objectName)) continue;
                NotificationFilter filter = (NotificationFilter)this.mIncludePatterns.get(pattern);
                this.listenToSingle(objectName, filter);
            }
        }
    }

    protected void listenToSingle(ObjectName objectName, NotificationFilter filter) {
        this.mListenees.put(objectName, filter);
        try {
            this.getMBeanServer().addNotificationListener(objectName, this, filter, null);
        }
        catch (Exception e) {
            this.mListenees.remove(objectName);
        }
    }

    public void listenTo(ObjectName pattern, NotificationFilter filter) throws InstanceNotFoundException {
        this.mIncludePatterns.put(pattern, filter);
        Set listenees = this.getMatchingObjectNames(pattern);
        MBeanServer server = this.getMBeanServer();
        Iterator iter = listenees.iterator();
        while (iter.hasNext()) {
            ObjectName objectName = (ObjectName)iter.next();
            if (objectName.equals(this.getObjectName())) continue;
            this.listenToSingle(objectName, filter);
        }
    }

    private void checkListeningTo(ObjectName objectName) {
        if (!this.mListenees.containsKey(objectName)) {
            throw new IllegalArgumentException(objectName.toString());
        }
    }

    public void dontListenTo(ObjectName pattern) {
        this.mIncludePatterns.remove(pattern);
        Set listenees = this.getMatchingObjectNames(pattern);
        MBeanServer server = this.getMBeanServer();
        Iterator iter = listenees.iterator();
        while (iter.hasNext()) {
            ObjectName objectName = (ObjectName)iter.next();
            try {
                server.removeNotificationListener(objectName, this);
                this.mListenees.remove(objectName);
            }
            catch (ListenerNotFoundException e) {
            }
            catch (InstanceNotFoundException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getListeneeObjectNameSet() {
        HashSet objectNames = new HashSet();
        Map map = this.mListenees;
        synchronized (map) {
            objectNames.addAll(this.mListenees.keySet());
        }
        return objectNames;
    }

    private NotificationFilter _getFilter(ObjectName objectName) {
        NotificationFilter filter = (NotificationFilter)this.mListenees.get(objectName);
        return filter;
    }

    public NotificationFilter getFilter(ObjectName objectName) {
        this.checkListeningTo(objectName);
        return this._getFilter(objectName);
    }

    public ObjectName preRegister(MBeanServer server, ObjectName objectNameIn) throws Exception {
        ObjectName objectName = super.preRegister(server, objectNameIn);
        JMXUtil.listenToMBeanServerDelegate(server, new RegistrationListener(), null, null);
        return objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDeregister() throws Exception {
        super.preDeregister();
        Map map = this.mListenees;
        synchronized (map) {
            Set s = this.getListeneeObjectNameSet();
            ObjectName[] objectNames = new ObjectName[s.size()];
            s.toArray(objectNames);
            for (int i = 0; i < objectNames.length; ++i) {
                this.dontListenTo(objectNames[i]);
            }
        }
        map = this.mBuffers;
        synchronized (map) {
            Iterator iter = this.mBuffers.keySet().iterator();
            while (iter.hasNext()) {
                NotificationBuffer buffer = (NotificationBuffer)this.mBuffers.get(iter.next());
                this.removeBuffer(buffer);
            }
        }
    }

    private final class RegistrationListener
    implements NotificationListener {
        public void handleNotification(Notification notifIn, Object handback) {
            if (notifIn instanceof MBeanServerNotification) {
                MBeanServerNotification notif = (MBeanServerNotification)notifIn;
                ObjectName objectName = notif.getMBeanName();
                String type = notif.getType();
                if (type.equals("JMX.mbean.registered")) {
                    NotificationServiceImpl.this.listenToIfMatch(objectName);
                } else if (type.equals("JMX.mbean.unregistered")) {
                    NotificationServiceImpl.this.dontListenTo(objectName);
                }
            }
        }
    }

    private final class OverflowHandlerImpl
    implements OverflowHandler {
        public void handleBufferOverflow(Object o) {
            Notification notif = (Notification)o;
            NotificationServiceImpl.this.issueBufferOverflowNotification(notif);
        }
    }
}

