/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.jmx.MBeanProxyHandler;
import com.sun.appserv.management.util.jmx.MBeanServerConnectionSource;
import com.sun.appserv.management.util.jmx.stringifier.NotificationStringifier;
import com.sun.appserv.management.util.jmx.stringifier.StringifierRegistryIniter;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.stringifier.StringifierRegistryImpl;
import com.sun.appserv.management.util.stringifier.StringifierRegistryIniterImpl;
import com.sun.enterprise.management.support.AMXMBeanRootLogger;
import com.sun.enterprise.management.support.BootUtil;
import com.sun.enterprise.management.support.DeferRegistrationException;
import com.sun.enterprise.management.support.LoaderMBean;
import com.sun.enterprise.management.support.LoaderOfOld;
import com.sun.enterprise.management.support.LoaderOfOld77;
import com.sun.enterprise.management.support.LoaderOfOldConfig;
import com.sun.enterprise.management.support.LoaderOfOldMonitor;
import com.sun.enterprise.management.support.LoaderRegHandler;
import com.sun.enterprise.management.support.LoaderRegThread;
import com.sun.enterprise.management.support.MBeanImplBase;
import com.sun.enterprise.management.support.ObjectNames;
import com.sun.enterprise.management.support.SystemInfoImpl;
import com.sun.enterprise.management.support.TypeInfo;
import com.sun.enterprise.management.support.TypeInfos;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.relation.MBeanServerNotificationFilter;

public final class Loader
extends MBeanImplBase
implements LoaderMBean,
LoaderRegHandler {
    private ObjectNames mObjectNames;
    private LoaderRegThread mRegThread;
    private boolean mStarted;
    private boolean mQueuedAll;
    private List mLoaders;
    private Map mOldToNewObjectNames;
    private final DeferredRegistrationThread mDeferredRegistrationThread;
    private static final boolean LOAD_77 = true;
    public static final boolean LOAD_MONITOR = true;
    private static final boolean SYNCHRONOUS_NOTIFICATION_HANDLING = true;
    private static final long WAIT_THRESHOLD_MILLIS = 5000L;
    private static LoaderMBean LOADER;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Loader(String appserverDomainName) {
        BootUtil.init(appserverDomainName);
        this.mServer = null;
        new StringifierRegistryIniterImpl(StringifierRegistryImpl.DEFAULT);
        new StringifierRegistryIniter(StringifierRegistryImpl.DEFAULT);
        this.mOldToNewObjectNames = Collections.synchronizedMap(new HashMap());
        this.mStarted = false;
        this.mQueuedAll = false;
        this.mLoaders = null;
        this.mDeferredRegistrationThread = new DeferredRegistrationThread();
        this.mDeferredRegistrationThread.start();
    }

    public String getAMXJMXDomainName() {
        return BootUtil.getInstance().getAMXJMXDomainName();
    }

    public String getAdministrativeDomainName() {
        return BootUtil.getInstance().getAppserverDomainName();
    }

    public void handleNotification(Notification notifIn, Object handback) {
        String type = notifIn.getType();
        if (notifIn instanceof MBeanServerNotification) {
            this.trace("Loader.handleNotification: received: " + NotificationStringifier.toString(notifIn));
            MBeanServerNotification notif = (MBeanServerNotification)notifIn;
            ObjectName objectName = notif.getMBeanName();
            if (this.shouldSync(objectName)) {
                boolean register;
                boolean bl = register = type == "JMX.mbean.registered";
                if (register) {
                    this.mRegThread.processRegistration(objectName);
                } else {
                    this.mRegThread.processUnregistration(objectName);
                }
            }
        }
    }

    public void handleMBeanRegistered(ObjectName oldObjectName) throws InstanceNotFoundException {
        block5: {
            this.trace("handleMBeanRegistered: " + oldObjectName);
            if (this.shouldSync(oldObjectName)) {
                long start = Loader.now();
                while (!this.getMBeanServer().isRegistered(oldObjectName) && Loader.now() - start < 5000L) {
                    this.mySleep(50L);
                }
                if (!this.getMBeanServer().isRegistered(oldObjectName)) {
                    this.trace("Loader.handleMBeanRegistered: not found!!!");
                    throw new InstanceNotFoundException(oldObjectName.toString());
                }
                try {
                    this.sync(oldObjectName);
                }
                catch (Exception e) {
                    Throwable rootCause = ExceptionUtil.getRootCause(e);
                    if (!(rootCause instanceof DeferRegistrationException)) break block5;
                    this.mDeferredRegistrationThread.defer(oldObjectName);
                }
            }
        }
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    public void handleMBeanUnregistered(ObjectName oldObjectName) throws InstanceNotFoundException, MBeanRegistrationException {
        this.trace("handleMBeanUnregistered: " + oldObjectName);
        ObjectName newObjectName = (ObjectName)this.mOldToNewObjectNames.remove(oldObjectName);
        if (newObjectName != null && this.getMBeanServer().isRegistered(newObjectName)) {
            this.getMBeanServer().unregisterMBean(newObjectName);
        }
    }

    synchronized ObjectName registerNew(Object impl, ObjectName implObjectName, ObjectName oldObjectName) throws MBeanRegistrationException, InstanceAlreadyExistsException, NotCompliantMBeanException {
        ObjectName resultName = this.getMBeanServer().registerMBean(impl, implObjectName).getObjectName();
        this.mOldToNewObjectNames.put(oldObjectName, resultName);
        return resultName;
    }

    public ObjectName loadSystemInfo(MBeanServer server) throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException {
        BootUtil bootUtil = BootUtil.getInstance();
        SystemInfoImpl systemInfo = new SystemInfoImpl(server, bootUtil);
        ObjectName tempName = this.mObjectNames.getSingletonObjectName("X-SystemInfo");
        ObjectName objectName = this.mServer.registerMBean(systemInfo, tempName).getObjectName();
        return objectName;
    }

    private void addLoaders() {
        if (!$assertionsDisabled && this.getMBeanServer() == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.getMBeanLogger() == null) {
            throw new AssertionError();
        }
        ArrayList<LoaderOfOld> loaders = new ArrayList<LoaderOfOld>();
        loaders.add(new LoaderOfOldConfig(this));
        loaders.add(new LoaderOfOld77(this));
        loaders.add(new LoaderOfOldMonitor(this));
        this.mLoaders = Collections.unmodifiableList(loaders);
    }

    public ObjectName preRegister(MBeanServer server, ObjectName objectNameIn) throws Exception {
        ObjectName superObjectName = super.preRegister(server, objectNameIn);
        this.mObjectNames = ObjectNames.getInstance(this.getAMXJMXDomainName());
        this.mSelfObjectName = Util.newObjectName(this.getAMXJMXDomainName() + "-support:" + "name=mbean-loader");
        this.mLogger = AMXMBeanRootLogger.getInstance();
        this.mRegThread = new LoaderRegThread(this, this.mLogger);
        this.mRegThread.start();
        try {
            this.loadSystemInfo(server);
            MBeanServerNotificationFilter filter = new MBeanServerNotificationFilter();
            filter.enableAllObjectNames();
            JMXUtil.listenToMBeanServerDelegate(this.mServer, this, filter, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            throw new RuntimeException(e);
        }
        return this.mSelfObjectName;
    }

    public void postRegister(Boolean registrationDone) {
        super.postRegister(registrationDone);
        if (registrationDone.booleanValue()) {
            Loader.initLOADER(this.getMBeanServer(), this.getObjectName());
        }
    }

    private boolean shouldSync(ObjectName oldObjectName) {
        return this.findLoaderOfOld(oldObjectName) != null;
    }

    private boolean mySleep(long millis) {
        boolean interrupted = false;
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            interrupted = true;
        }
        return interrupted;
    }

    private LoaderOfOld findLoaderOfOld(ObjectName candidate) {
        LoaderOfOld oldLoader = null;
        Iterator iter = this.mLoaders.iterator();
        while (iter.hasNext()) {
            LoaderOfOld loo = (LoaderOfOld)iter.next();
            if (!loo.shouldSync(candidate)) continue;
            oldLoader = loo;
            break;
        }
        return oldLoader;
    }

    public ObjectName sync(ObjectName oldObjectName) {
        if (!this.mStarted) {
            throw new IllegalArgumentException();
        }
        if (!this.shouldSync(oldObjectName)) {
            throw new IllegalArgumentException(oldObjectName.toString());
        }
        long millis = 200L;
        while (!this.getMBeanServer().isRegistered(oldObjectName)) {
            this.mySleep(millis);
            if ((millis *= 2L) <= 500L) continue;
            this.getMBeanLogger().fine("Loader.sync: waiting for MBean to load: " + oldObjectName);
        }
        ObjectName result = null;
        try {
            LoaderOfOld loaderOfOld = this.findLoaderOfOld(oldObjectName);
            if (loaderOfOld != null && (result = loaderOfOld.syncWithOld(oldObjectName)) == null) {
                throw new IllegalArgumentException(oldObjectName.toString());
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return result;
    }

    private void queueAll() {
        Iterator iter = this.mLoaders.iterator();
        while (iter.hasNext()) {
            LoaderOfOld oldLoader = (LoaderOfOld)iter.next();
            List oldObjectNames = oldLoader.findAllOld();
            this.mRegThread.enqueue(true, oldObjectNames);
            this.getMBeanLogger().fine("Loader: Queued " + oldObjectNames.size() + " MBeans for loader " + oldLoader.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean waitTillDone) {
        Loader loader = this;
        synchronized (loader) {
            if (this.mStarted) {
                throw new IllegalArgumentException("Can't start Loader twice");
            }
            this.mStarted = true;
        }
        this.loadDomainRoot();
        this.addLoaders();
        this.mRegThread.waitEmpty();
        this.queueAll();
        this.mQueuedAll = true;
        if (waitTillDone) {
            this.mRegThread.waitEmpty();
        }
    }

    public boolean isStarted() {
        return this.mStarted && this.mQueuedAll && this.mRegThread.getRegistrationQueueSize() == 0;
    }

    private void loadDomainRoot() {
        try {
            TypeInfo info = TypeInfos.getInstance().getInfo("X-DomainRoot");
            Class implClass = info.getImplClass();
            ObjectName objectName = this.mObjectNames.getDomainRootObjectName();
            Object impl = implClass.newInstance();
            this.mServer.registerMBean(impl, objectName);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            throw new RuntimeException(e);
        }
    }

    public DomainRoot getDomainRoot() {
        ProxyFactory factory = ProxyFactory.getInstance(this.getMBeanServer());
        return factory.getDomainRoot();
    }

    public static void initLOADER(MBeanServer server, ObjectName loaderObjectName) {
        if (!$assertionsDisabled && LOADER != null) {
            throw new AssertionError();
        }
        try {
            MBeanServerConnectionSource conn = new MBeanServerConnectionSource(server);
            MBeanProxyHandler handler = new MBeanProxyHandler(conn, loaderObjectName);
            LOADER = (LoaderMBean)Proxy.newProxyInstance(LoaderMBean.class.getClassLoader(), new Class[]{LoaderMBean.class}, (InvocationHandler)handler);
        }
        catch (IOException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"can't happen");
            }
            throw new RuntimeException(e);
        }
    }

    public static LoaderMBean getLoader(MBeanServer server) {
        return LOADER;
    }

    static {
        $assertionsDisabled = !Loader.class.desiredAssertionStatus();
        LOADER = null;
    }

    private final class DeferredRegistrationThread
    extends Thread {
        private final List mDeferredItems = Collections.synchronizedList(new ArrayList());
        private boolean mSleeping = false;
        private final long MAX_DELAY_MILLIS = 300000L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void internalDefer(ObjectName oldObjectName) {
            List list = this.mDeferredItems;
            synchronized (list) {
                this.mDeferredItems.add(new DeferredItem(oldObjectName));
            }
        }

        public synchronized void defer(ObjectName oldObjectName) {
            this.internalDefer(oldObjectName);
            if (this.mSleeping) {
                this.interrupt();
            }
            Loader.this.getMBeanLogger().info("Deferring registration for " + MBeanImplBase.quote(oldObjectName));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DeferredItem[] takeAllItems() {
            List list = this.mDeferredItems;
            synchronized (list) {
                DeferredItem[] items = new DeferredItem[this.mDeferredItems.size()];
                this.mDeferredItems.toArray(items);
                this.mDeferredItems.clear();
                return items;
            }
        }

        private ObjectName retry(ObjectName oldObjectName) {
            return Loader.this.sync(oldObjectName);
        }

        private void retryItem(DeferredItem item) {
            ObjectName oldObjectName = item.mObjectName;
            String prefix = "DeferredRegistrationThread.retryItem: ";
            long elapsed = Loader.now() - item.mStartMillis;
            try {
                ObjectName result = this.retry(oldObjectName);
                Loader.this.getMBeanLogger().info("DeferredRegistrationThread.retryItem: deferred registration SUCCEEDED after " + elapsed + " milliseconds for " + MBeanImplBase.quote(oldObjectName) + ", amx ObjectName = " + MBeanImplBase.quote(result));
            }
            catch (Throwable t) {
                Throwable rootCause = ExceptionUtil.getRootCause(t);
                if (rootCause instanceof DeferRegistrationException) {
                    if (elapsed < 300000L) {
                        Loader.this.getMBeanLogger().fine("DeferredRegistrationThread.retryItem: deferred registration RETRY failed after " + elapsed + " milliseconds for " + MBeanImplBase.quote(oldObjectName) + " (DEFERRING AGAIN)");
                        this.internalDefer(oldObjectName);
                    } else {
                        Loader.this.getMBeanLogger().warning("DeferredRegistrationThread.retryItem: Deferred registration FAILED for " + MBeanImplBase.quote(oldObjectName) + "after deferral of " + elapsed + " ms, ignoring MBean.");
                    }
                }
                Loader.this.getMBeanLogger().warning("DeferredRegistrationThread.retryItem: Deferred registration FAILED for " + MBeanImplBase.quote(oldObjectName) + "due to Exception of type " + rootCause.getClass().getName());
            }
        }

        private void checkList() {
            DeferredItem[] items = this.takeAllItems();
            Loader.this.getMBeanLogger().fine("DeferredRegistrationThread.checkList: numItems = " + items.length);
            for (int i = 0; i < items.length; ++i) {
                DeferredItem item = items[i];
                if (Loader.this.getMBeanServer().isRegistered(item.mObjectName)) {
                    this.retryItem(item);
                    continue;
                }
                Loader.this.getMBeanLogger().info("DeferredRegistrationThread.checkList: MBean is no longer registered: " + MBeanImplBase.quote(item.mObjectName));
            }
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        Loader.this.getMBeanLogger().fine("DeferredRegistrationThread.run: CHECKING LIST@" + Loader.now());
                        this.checkList();
                        long sleepMillis = this.mDeferredItems.size() == 0 ? 60000L : 500L;
                        Loader.this.getMBeanLogger().fine("DeferredRegistrationThread.run: SLEEPING FOR: " + sleepMillis + "@" + Loader.now());
                        this.mSleeping = true;
                        boolean interrupted = Loader.this.mySleep(sleepMillis);
                        this.mSleeping = false;
                    }
                }
                catch (Throwable t) {
                    Loader.this.getMBeanLogger().warning("DeferredRegistrationThread.run: caught Throwable:\n" + ExceptionUtil.getStackTrace(t));
                    continue;
                }
                break;
            }
        }

        private final class DeferredItem {
            public long mStartMillis;
            public final ObjectName mObjectName;

            public DeferredItem(ObjectName objectName) {
                this.mObjectName = objectName;
                this.mStartMillis = Loader.now();
            }
        }
    }
}

