/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.base.DottedNames;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.enterprise.management.support.AMXImplBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public abstract class DottedNamesBase
extends AMXImplBase
implements DottedNames {
    private static final String DOTTED_NAMES = "com.sun.appserv:name=dotted-name-get-set,type=dotted-name-support";
    private OldDottedNamesProxy mOldDottedNamesProxy = null;
    private MBeanInfo mMBeanInfo = null;
    private Map mAttributes;
    private Set mParentAttributeNames = null;
    private static final String ALL = "*";
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$String;

    public abstract Object[] dottedNameGet(String[] var1);

    public abstract Object dottedNameGet(String var1);

    public abstract Object[] dottedNameList(String[] var1);

    public abstract Object[] dottedNameSet(String[] var1);

    protected abstract boolean isWriteableDottedName(String var1);

    public boolean getMBeanInfoIsInvariant() {
        return false;
    }

    public MBeanInfo getMBeanInfo() {
        MBeanInfo mbeanInfo = null;
        if (this.getOldDottedNames() != null) {
            this.ensureMBeanInfo();
            mbeanInfo = this.mMBeanInfo;
        } else {
            mbeanInfo = super.getMBeanInfo();
        }
        return mbeanInfo;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName objectName) throws Exception {
        ObjectName resultName = super.preRegister(server, objectName);
        this.setupOldDottedNamesProxy();
        return resultName;
    }

    protected void setupOldDottedNamesProxy() {
        this.setupOldDottedNamesProxy(Util.newObjectName(DOTTED_NAMES));
    }

    protected void setupOldDottedNamesProxy(ObjectName target) {
        MBeanServer server = this.getMBeanServer();
        this.mOldDottedNamesProxy = (OldDottedNamesProxy)MBeanServerInvocationHandler.newProxyInstance(server, target, OldDottedNamesProxy.class, false);
    }

    protected OldDottedNamesProxy getOldDottedNames() {
        return this.mOldDottedNamesProxy;
    }

    protected final boolean isDottedName(String name) {
        return this.getAttributes().keySet().contains(name);
    }

    protected final boolean isParentAttributeName(String name) {
        return this.mParentAttributeNames.contains(name);
    }

    protected final void filterNames(String[] in, Set dotted, Set parent) {
        HashSet s = new HashSet();
        for (int i = 0; i < in.length; ++i) {
            String name = in[i];
            if (this.isDottedName(name)) {
                dotted.add(name);
                continue;
            }
            if (!this.isParentAttributeName(name)) continue;
            parent.add(name);
        }
    }

    public AttributeList getAttributes(String[] names) {
        HashSet dotted = new HashSet();
        HashSet parent = new HashSet();
        this.filterNames(names, dotted, parent);
        Object[] dottedResults = this.dottedNameGet(dotted.toArray(new String[dotted.size()]));
        String[] namesForParent = new String[parent.size()];
        AttributeList parentResults = super.getAttributes(parent.toArray(namesForParent));
        AttributeList successList = new AttributeList();
        successList.addAll(parentResults);
        for (int i = 0; i < dottedResults.length; ++i) {
            if (dottedResults[i] instanceof Attribute) {
                successList.add(dottedResults[i]);
                continue;
            }
            if (!$assertionsDisabled && !(dottedResults[i] instanceof Exception)) {
                throw new AssertionError();
            }
        }
        return successList;
    }

    public Object getAttribute(String name) throws AttributeNotFoundException {
        this.checkLegalName(name);
        Object result = null;
        if (this.isDottedName(name)) {
            result = this.dottedNameGet(name);
            if (!$assertionsDisabled && result instanceof Attribute) {
                throw new AssertionError();
            }
        } else if (this.isParentAttributeName(name)) {
            result = super.getAttribute(name);
        } else {
            throw new AttributeNotFoundException(name);
        }
        return result;
    }

    public void setAttribute(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException {
        this.checkLegalName(attr.getName());
        AttributeList inList = new AttributeList();
        inList.add(attr);
        AttributeList result = this.setAttributes(inList);
        if (result.size() != 1) {
            throw new InvalidAttributeValueException(attr.getName());
        }
    }

    public AttributeList setAttributes(AttributeList attributes) {
        int numAttrsIn = attributes.size();
        ArrayList<String> legalPairs = new ArrayList<String>();
        for (int i = 0; i < numAttrsIn; ++i) {
            Attribute attr = (Attribute)attributes.get(i);
            if (!this.isLegalAttributeName(attr.getName())) continue;
            legalPairs.add(DottedNamesBase.attributeToNamePair(attr));
        }
        String[] pairs = legalPairs.toArray(new String[legalPairs.size()]);
        Object[] results = this.dottedNameSet(pairs);
        AttributeList attributeList = new AttributeList();
        for (int i = 0; i < results.length; ++i) {
            if (results[i] instanceof Attribute) {
                attributeList.add(results[i]);
                continue;
            }
            if (!$assertionsDisabled && !(results[i] instanceof Exception)) {
                throw new AssertionError();
            }
        }
        return attributeList;
    }

    public Object invokeManually(String operationName, Object[] params, String[] types) throws ReflectionException, MBeanException, NoSuchMethodException {
        boolean noParams = params == null || params.length == 0;
        Object result = null;
        if (operationName.equals("refresh") && noParams) {
            this.refresh();
            result = null;
        } else {
            result = super.invokeManually(operationName, params, types);
        }
        return result;
    }

    private synchronized void ensureMBeanInfo() {
        if (this.mMBeanInfo == null) {
            this.trace("##### DottedNamesBase.ensureMBeanInfo");
            this.refresh();
            if (!$assertionsDisabled && this.mMBeanInfo == null) {
                throw new AssertionError();
            }
        }
    }

    protected MBeanAttributeInfo[] buildAttributeInfos(MBeanAttributeInfo[] parentAttributeInfos) {
        Object[] parentAttributeNames = JMXUtil.getAttributeNames(parentAttributeInfos);
        this.mParentAttributeNames = SetUtil.newSet(parentAttributeNames);
        Map attributes = this.getAttributes();
        MBeanAttributeInfo[] infos = new MBeanAttributeInfo[attributes.size() + parentAttributeInfos.length];
        Iterator iter = attributes.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Attribute attr = (Attribute)attributes.get(name);
            Object value = attr.getValue();
            Class theClass = value == null ? (class$java$lang$String == null ? DottedNamesBase.class$("java.lang.String") : class$java$lang$String) : attr.getValue().getClass();
            infos[i] = new MBeanAttributeInfo(name, theClass.getName(), "", true, this.isWriteableDottedName(name), false);
            ++i;
        }
        System.arraycopy(parentAttributeInfos, 0, infos, attributes.size(), parentAttributeInfos.length);
        return infos;
    }

    protected MBeanOperationInfo[] buildOperationInfos(MBeanOperationInfo[] existing) {
        MBeanOperationInfo refreshInfo = new MBeanOperationInfo("refresh", "update MBeanInfo to reflect all available dotted names", null, Void.class.getName(), 1);
        MBeanOperationInfo[] infos = new MBeanOperationInfo[existing.length + 1];
        System.arraycopy(existing, 0, infos, 0, existing.length);
        infos[infos.length - 1] = refreshInfo;
        return infos;
    }

    protected MBeanInfo buildMBeanInfo() {
        MBeanInfo superMBeanInfo = super.getMBeanInfo();
        MBeanAttributeInfo[] attributeInfos = this.buildAttributeInfos(superMBeanInfo.getAttributes());
        MBeanOperationInfo[] operationInfos = this.buildOperationInfos(superMBeanInfo.getOperations());
        MBeanInfo info = new MBeanInfo(this.getClass().getName(), "exposes dotted-names as Attributes", attributeInfos, superMBeanInfo.getConstructors(), operationInfos, superMBeanInfo.getNotifications());
        return info;
    }

    private static Attribute namePairToAttribute(String pair) {
        int delimIndex = pair.indexOf("=");
        if (!$assertionsDisabled && delimIndex < 1) {
            throw new AssertionError();
        }
        String name = pair.substring(0, delimIndex);
        String value = pair.substring(delimIndex + 1, pair.length());
        return new Attribute(name, value);
    }

    private static String attributeToNamePair(Attribute attr) {
        return attr.getName() + "=" + attr.getValue();
    }

    protected final boolean isLegalAttributeName(String name) {
        this.ensureAttributes();
        return this.getAttributes().keySet().contains(name) || this.mParentAttributeNames.contains(name);
    }

    protected final void ensureAttributes() {
        if (this.mAttributes == null) {
            this.refreshAttributes();
        }
    }

    protected final Map getAttributes() {
        this.ensureAttributes();
        return this.mAttributes;
    }

    protected final String[] getDottedNamesArray() {
        Map map = this.getAttributes();
        Set keySet = map.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    private final void checkLegalName(String name) throws AttributeNotFoundException {
        if (!this.isLegalAttributeName(name)) {
            throw new AttributeNotFoundException("illegal attribute name: " + name);
        }
    }

    final void refreshAttributes() {
        Object result = null;
        result = this.dottedNameGet(ALL);
        Attribute[] values = (Attribute[])result;
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        for (int i = 0; i < values.length; ++i) {
            map.put(values[i].getName(), values[i]);
        }
        this.mAttributes = map;
    }

    public final void refresh() {
        this.trace("##### DottedNamesBase.refresh");
        this.refreshAttributes();
        this.mMBeanInfo = this.buildMBeanInfo();
    }

    static {
        $assertionsDisabled = !DottedNamesBase.class.desiredAssertionStatus();
    }

    protected static interface OldDottedNamesProxy {
        public Object[] dottedNameGet(String[] var1);

        public Object dottedNameGet(String var1);

        public Object[] dottedNameMonitoringGet(String[] var1);

        public Object dottedNameMonitoringGet(String var1);

        public String[] dottedNameList(String[] var1);

        public String[] dottedNameMonitoringList(String[] var1);

        public Object[] dottedNameSet(String[] var1);
    }
}

