/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.j2ee;

import com.sun.appserv.management.j2ee.WebModule;
import com.sun.appserv.management.util.jmx.AttributeNameMapper;
import com.sun.appserv.management.util.misc.CollectionUtil;
import com.sun.enterprise.management.j2ee.J2EEModuleImplBase;
import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.support.WebModuleSupport;
import java.util.Map;
import javax.management.ObjectName;

public final class WebModuleImpl
extends J2EEModuleImplBase {
    public WebModuleImpl(Delegate delegate) {
        super(delegate);
    }

    protected String getConfigPeerName() {
        String compositeName = this.getName();
        String webModuleName = WebModuleSupport.extractWebModuleName(compositeName);
        return webModuleName;
    }

    public boolean isConfigProvider() {
        String name;
        boolean isConfigProvider = super.isConfigProvider();
        if (super.isConfigProvider() && this.getObjectName() != null && ((name = this.getConfigPeerName()).length() == 0 || name.equals("asadmin") || name.equals("web1"))) {
            isConfigProvider = false;
        }
        return isConfigProvider;
    }

    public String[] getservlets() {
        return CollectionUtil.toStringArray(this.getServletObjectNameMap().values());
    }

    public Map getServletObjectNameMap() {
        return this.getContaineeObjectNameMap("Servlet");
    }

    protected String getMonitoringPeerJ2EEType() {
        return "X-WebModuleVirtualServerMonitor";
    }

    protected void addCustomMappings(AttributeNameMapper mapper) {
        super.addCustomMappings(mapper);
        mapper.addMapping("tldScanTime", "TLDScanTime");
        mapper.addMapping("defaultWebXml", "DefaultWebXML");
    }

    private final String deduceModuleName() {
        int index2;
        String workDir = ((WebModule)this.getSelf()).getWorkDir();
        int index1 = workDir.lastIndexOf("/");
        int index = index1 > (index2 = workDir.lastIndexOf("\\")) ? index1 : index2;
        String result = null;
        if (index > 0) {
            result = workDir.substring(index + 1, workDir.length());
        }
        return result;
    }

    protected ObjectName queryConfigPeerFailed(Map propsMap) {
        String potentialName = this.deduceModuleName();
        propsMap.put("name", potentialName);
        ObjectName result = this.queryProps(propsMap);
        return result;
    }

    protected ObjectName queryMonitoringPeerFailed(Map propsMap) {
        String selfName = this.getName();
        String virtualServerName = WebModuleSupport.extractVirtualServerName(selfName);
        ObjectName result = null;
        String potentialName = this.deduceModuleName();
        if (potentialName != null) {
            String name = WebModuleSupport.formCompositeName(virtualServerName, potentialName);
            propsMap.put("name", name);
            result = this.queryProps(propsMap);
        }
        return result;
    }
}

