/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.deploy;

import com.sun.appserv.management.base.Singleton;
import com.sun.appserv.management.base.UploadDownloadMgr;
import com.sun.appserv.management.base.Utility;
import com.sun.appserv.management.deploy.DeploymentMgr;
import com.sun.appserv.management.deploy.DeploymentProgress;
import com.sun.appserv.management.deploy.DeploymentSource;
import com.sun.appserv.management.deploy.DeploymentStatus;
import com.sun.appserv.management.deploy.DeploymentSupport;
import com.sun.appserv.management.util.jmx.NotificationBuilder;
import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.enterprise.management.deploy.DeployThread;
import com.sun.enterprise.management.deploy.DeployThreadParams;
import com.sun.enterprise.management.deploy.DeploymentCallback;
import com.sun.enterprise.management.deploy.DownloadFileSource;
import com.sun.enterprise.management.deploy.Undeployer;
import com.sun.enterprise.management.support.AMXNonConfigImplBase;
import com.sun.enterprise.management.support.UniqueIDGenerator;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;

public final class DeploymentMgrImpl
extends AMXNonConfigImplBase
implements Utility,
Singleton,
DeploymentMgr {
    private final Map mDeployThreads;
    private final UniqueIDGenerator mDeployIDs;
    private long mDeploymentCompletedNotificationSequenceNumber = 0L;
    private final String[] NOTIF_TYPES = new String[]{"X-DeploymentMgr.DeploymentStarted", "X-DeploymentMgr.DeploymentAborted", "X-DeploymentMgr.DeploymentProgress", "X-DeploymentMgr.DeploymentCompleted"};
    private static final long SECOND_MILLIS = 60000L;
    private static final long MINUTE_MILLIS = 3600000L;
    private static final long DEPLOY_KEEP_ALIVE_MILLIS = 54000000L;

    public void remove(String name) {
        throw new RuntimeException("not applicable");
    }

    public DeploymentMgrImpl() {
        this.mDeployThreads = Collections.synchronizedMap(new HashMap());
        this.mDeployIDs = new UniqueIDGenerator("deploy:");
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo info = new MBeanNotificationInfo(this.NOTIF_TYPES, Notification.class.getName(), "");
        MBeanNotificationInfo[] selfInfos = new MBeanNotificationInfo[]{info};
        return this.mergeNotificationInfos(super.getNotificationInfo(), selfInfos);
    }

    private DeployThread removeDeployThread(Object deployID) {
        this.trace("\n###Removing deploy thread: " + deployID);
        return (DeployThread)this.mDeployThreads.remove(deployID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void staleDeployCheck() {
        Set keySet = this.mDeployThreads.keySet();
        Map map = this.mDeployThreads;
        synchronized (map) {
            String[] deployIDs = SetUtil.toStringArray(keySet);
            for (int i = 0; i < deployIDs.length; ++i) {
                String deployID = deployIDs[i];
                DeployThread deployThread = (DeployThread)this.mDeployThreads.get(deployID);
                if (deployThread.getMillisSinceDone() <= 54000000L) continue;
                this.removeDeployThread(deployID);
            }
        }
    }

    private DeployThread addDeployThread(Object deployID) {
        InternalDeploymentCallback callback = new InternalDeploymentCallback(deployID);
        DeployThread deployThread = new DeployThread(deployID, callback, null);
        this.mDeployThreads.put(deployThread.getID(), deployThread);
        return deployThread;
    }

    public Object initDeploy() {
        Object deployID = this.mDeployIDs.createID();
        DeployThread deployThread = this.addDeployThread(deployID);
        return deployID;
    }

    public void startDeploy(Object deployID, Object uploadID, Object planUploadID, Map options) {
        this.staleDeployCheck();
        UploadDownloadMgr mgr = this.getUploadDownloadMgr();
        File deployFile = mgr.takeUpload(uploadID);
        File planFile = planUploadID == null ? null : mgr.takeUpload(planUploadID);
        DeployThreadParams params = new DeployThreadParams(this.getQueryMgr(), options, deployFile, planFile);
        this.startDeploy(deployID, params);
    }

    public void startDeploy(Object deployID, Map sourceData, Map planData, Map options) {
        DeploymentSource source = DeploymentSupport.mapToDeploymentSource(sourceData);
        DeploymentSource plan = planData == null ? null : DeploymentSupport.mapToDeploymentSource(planData);
        DeployThreadParams params = new DeployThreadParams(this.getQueryMgr(), options, source, plan);
        this.startDeploy(deployID, params);
    }

    private void startDeploy(Object deployID, DeployThreadParams params) {
        DeployThread deployThread = this.getDeployThread(deployID);
        if (deployThread == null) {
            throw new IllegalArgumentException(deployID.toString());
        }
        deployThread.setParams(params);
        this.issueDeploymentStartedNotification(deployID);
        deployThread.start();
    }

    private DeployThread getDeployThread(Object deployID) {
        DeployThread deployThread = (DeployThread)this.mDeployThreads.get(deployID);
        if (deployThread == null) {
            IllegalArgumentException e = new IllegalArgumentException("" + deployID);
            e.printStackTrace();
            throw e;
        }
        return deployThread;
    }

    private boolean notifsAreDone(Notification[] notifs) {
        boolean done = false;
        for (int i = notifs.length - 1; i >= 0; --i) {
            String notifType = notifs[notifs.length - 1].getType();
            if (!notifType.equals("X-DeploymentMgr.DeploymentCompleted") && !notifType.equals("X-DeploymentMgr.DeploymentAborted")) continue;
            done = true;
            break;
        }
        return done;
    }

    public Notification[] takeNotifications(Object deployID) {
        DeployThread deployThread = this.getDeployThread(deployID);
        Notification[] notifs = deployThread.takeNotifications();
        return notifs;
    }

    public boolean abortDeploy(Object deployID) {
        DeployThread deployThread = this.getDeployThread(deployID);
        boolean abortedSuccessfully = deployThread.quit();
        this.issueDeploymentAbortedNotification(deployID);
        return abortedSuccessfully;
    }

    private void issueNotification(Object deployID, Notification notif) {
        this.sendNotification(notif);
        this.trace("\nDeploymentMgrImpl.issueNotification: sent notification for " + deployID + " = " + notif.toString());
        DeployThread deployThread = this.getDeployThread(deployID);
        deployThread.queueNotification(notif);
    }

    protected void issueDeploymentStartedNotification(Object deployID) {
        NotificationBuilder builder = this.getNotificationBuilder("X-DeploymentMgr.DeploymentStarted");
        Notification notif = builder.buildNew();
        NotificationBuilder.putMapData(notif, "X-DeploymentMgr.DeploymentID", deployID);
        this.issueNotification(deployID, notif);
    }

    protected void issueDeploymentDoneNotification(Object deployID, DeploymentStatus deploymentStatus) {
        NotificationBuilder builder = this.getNotificationBuilder("X-DeploymentMgr.DeploymentCompleted");
        Notification notif = builder.buildNew();
        NotificationBuilder.putMapData(notif, "X-DeploymentMgr.DeploymentID", deployID);
        NotificationBuilder.putMapData(notif, "X-DeploymentMgr.DeploymentCompletedStatus", deploymentStatus.asMap());
        this.issueNotification(deployID, notif);
    }

    protected void issueDeploymentProgressNotification(Object deployID, DeploymentProgress progress) {
        NotificationBuilder builder = this.getNotificationBuilder("X-DeploymentMgr.DeploymentProgress");
        Notification notif = builder.buildNew();
        NotificationBuilder.putMapData(notif, "X-DeploymentMgr.DeploymentID", deployID);
        NotificationBuilder.putMapData(notif, "X-DeploymentMgr.DeploymentProgress", progress.asMap());
        this.issueNotification(deployID, notif);
    }

    protected void issueDeploymentAbortedNotification(Object deployID) {
        NotificationBuilder builder = this.getNotificationBuilder("X-DeploymentMgr.DeploymentAborted");
        Notification notif = builder.buildNew();
        NotificationBuilder.putMapData(notif, "X-DeploymentMgr.DeploymentID", deployID);
        this.issueNotification(deployID, notif);
    }

    public Map undeploy(String moduleID, Map optionalParams) {
        Undeployer undeployer = new Undeployer(moduleID, optionalParams);
        DeploymentStatus undeploymentStatus = undeployer.undeploy();
        return undeploymentStatus.asMap();
    }

    public Map getFinalDeploymentStatus(Object deployID) {
        DeployThread deployThread = this.removeDeployThread(deployID);
        if (deployThread == null) {
            throw new IllegalArgumentException(deployID.toString());
        }
        return deployThread.getDeploymentStatus().asMap();
    }

    private UploadDownloadMgr getUploadDownloadMgr() {
        return this.getDomainRoot().getUploadDownloadMgr();
    }

    public Object initiateFileUpload(long totalSize) throws IOException {
        return this.getUploadDownloadMgr().initiateUpload(null, totalSize);
    }

    public boolean uploadBytes(Object uploadID, byte[] bytes) throws IOException {
        return this.getUploadDownloadMgr().uploadBytes(uploadID, bytes);
    }

    public Object initiateFileDownload(String moduleID, String filename) throws IOException {
        DownloadFileSource source = new DownloadFileSource(moduleID, filename);
        File theFile = source.getDownloadFile();
        boolean deleteWhenDone = source.isTempFile();
        return this.getUploadDownloadMgr().initiateDownload(theFile, deleteWhenDone);
    }

    public long getDownloadLength(Object downloadID) {
        return this.getUploadDownloadMgr().getDownloadLength(downloadID);
    }

    public byte[] downloadBytes(Object downloadID, int requestSize) throws IOException {
        return this.getUploadDownloadMgr().downloadBytes(downloadID, requestSize);
    }

    private final class InternalDeploymentCallback
    implements DeploymentCallback {
        final Object mDeployID;

        public InternalDeploymentCallback(Object deployID) {
            this.mDeployID = deployID;
        }

        public void deploymentDone(DeploymentStatus status) {
            DeploymentMgrImpl.this.issueDeploymentDoneNotification(this.mDeployID, status);
        }

        public void deploymentProgress(DeploymentProgress progress) {
            DeploymentMgrImpl.this.issueDeploymentProgressNotification(this.mDeployID, progress);
        }
    }
}

