/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.deploy;

import com.sun.appserv.management.deploy.DeploymentSource;
import com.sun.appserv.management.deploy.DeploymentStatus;
import com.sun.appserv.management.deploy.DeploymentStatusImpl;
import com.sun.enterprise.deployment.backend.DeploymentRequestRegistry;
import com.sun.enterprise.deployment.phasing.DeploymentService;
import com.sun.enterprise.deployment.util.DeploymentProperties;
import com.sun.enterprise.management.deploy.DeployThreadParams;
import com.sun.enterprise.management.deploy.DeploymentCallback;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.management.Notification;

public final class DeployThread
extends Thread {
    private DeployThreadParams mParams;
    private final Object mDeployID;
    private String moduleID;
    private final DeploymentCallback mDeploymentCallback;
    private boolean mQuit;
    private boolean mDone;
    private long mDoneMillis;
    private DeploymentStatusImpl mDeploymentStatus;
    private final List mQueuedNotifications;

    public DeployThread(Object id, DeploymentCallback deploymentCallback, DeployThreadParams params) {
        this.mDeployID = id;
        this.mDeploymentCallback = deploymentCallback;
        this.mParams = params;
        this.mDeploymentStatus = null;
        this.mDone = false;
        this.mQuit = false;
        this.mDoneMillis = 0L;
        this.mQueuedNotifications = new ArrayList();
    }

    public void setParams(DeployThreadParams params) {
        if (this.mParams != null) {
            throw new IllegalArgumentException();
        }
        this.mParams = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueNotification(Notification notif) {
        if (this.isDone()) {
            throw new IllegalArgumentException("Notification cannot be queued after being done for: " + this.mDeployID);
        }
        List list = this.mQueuedNotifications;
        synchronized (list) {
            this.mQueuedNotifications.add(notif);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Notification[] takeNotifications() {
        Notification[] notifs = null;
        List list = this.mQueuedNotifications;
        synchronized (list) {
            notifs = new Notification[this.mQueuedNotifications.size()];
            this.mQueuedNotifications.toArray(notifs);
            this.mQueuedNotifications.clear();
        }
        return notifs;
    }

    public DeploymentStatus getDeploymentStatus() {
        return this.mDeploymentStatus;
    }

    public boolean quit() {
        this.mQuit = true;
        return DeploymentService.getDeploymentService().quit(this.moduleID);
    }

    private void trace(Object o) {
        String name = this.getClass().getName();
        Logger.getLogger(name).fine(o.toString());
    }

    private DeploymentStatusImpl deploy(DeployThreadParams params, DeploymentCallback callback) {
        try {
            DeploymentProperties dProps;
            String archiveName;
            DeploymentSource deploySource;
            Map options = params.getOptions();
            File deployFile = params.getDeployFile();
            File planFile = params.getPlanFile();
            if (deployFile == null && (deploySource = params.getDeploymentSource()) != null) {
                deployFile = deploySource.getArchive();
            }
            if ((archiveName = (dProps = new DeploymentProperties(options)).getArchiveName()) == null && deployFile != null) {
                archiveName = deployFile.getAbsolutePath();
            }
            this.moduleID = dProps.getName(archiveName);
            com.sun.enterprise.deployment.backend.DeploymentStatus ds = DeploymentService.getDeploymentService().deploy(deployFile, planFile, archiveName, this.moduleID, dProps, callback);
            ds.setStageStatus(ds.getStatus());
            DeploymentRequestRegistry.getRegistry().removeDeploymentRequest(this.moduleID);
            return new DeploymentStatusImpl(ds.asMap());
        }
        catch (Exception e) {
            com.sun.enterprise.deployment.backend.DeploymentStatus ds = new com.sun.enterprise.deployment.backend.DeploymentStatus();
            ds.setStageException((Throwable)e);
            ds.setStageStatus(0);
            ds.setStageStatusMessage(e.getMessage());
            ds.setStageDescription("Deployment");
            DeploymentRequestRegistry.getRegistry().removeDeploymentRequest(this.moduleID);
            return new DeploymentStatusImpl(ds.asMap());
        }
    }

    public void run() {
        this.mDone = false;
        this.trace("DeployThread.run: starting: " + this.getID());
        if (this.mParams == null) {
            throw new IllegalArgumentException("no params specified");
        }
        this.trace("DeployThread.run: calling deploy() for: " + this.getID());
        this.mDeploymentStatus = this.deploy(this.mParams, this.mDeploymentCallback);
        this.trace("DeployThread.run: deploy() successful for: " + this.getID());
        this.mDeploymentCallback.deploymentDone(this.mDeploymentStatus);
        if (this.mParams.getDeployFile() != null) {
            this.trace("DeployThread.run: deleting deploy file: " + this.mParams.getDeployFile());
            this.mParams.getDeployFile().delete();
        }
        if (this.mParams.getPlanFile() != null) {
            this.trace("DeployThread.run: deleting plan file: " + this.mParams.getPlanFile());
            this.mParams.getPlanFile().delete();
        }
        this.mDoneMillis = System.currentTimeMillis();
        this.mDone = true;
        this.trace("DeployThread.run: done with: " + this.getID());
    }

    public long getMillisSinceDone() {
        return this.isDone() ? System.currentTimeMillis() - this.mDoneMillis : 0L;
    }

    public Object getID() {
        return this.mDeployID;
    }

    public boolean isDone() {
        return this.mDone;
    }
}

