/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.support.oldconfig.OldClusterMBean;
import java.util.HashMap;
import java.util.Map;
import javax.management.AttributeList;
import javax.management.ObjectName;

final class ServerRefConfigFactory
extends ConfigFactory {
    private final OldClusterMBean mOldClusterMBean;

    public ServerRefConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
        String containerName = this.getFactoryContainer().getName();
        this.mOldClusterMBean = this.getOldConfigProxies().getOldClusterMBean(containerName);
    }

    protected Map getParamNameOverrides() {
        return MapUtil.newMap("name", "ref");
    }

    protected ObjectName createOldChildConfig(AttributeList translatedAttrs) {
        return this.mOldClusterMBean.createServerRef(translatedAttrs);
    }

    public ObjectName create(String referencedServerName, Map optional) {
        Object[] requiredParams = new Object[]{};
        Map params = this.initParams(referencedServerName, requiredParams, optional);
        ObjectName amxName = this.createNamedChild(referencedServerName, params);
        return amxName;
    }

    public ObjectName create(String referencedServerName, String disableTimeoutInMinutes, boolean lbEnabled, boolean enabled) {
        HashMap<String, String> optionalParams = new HashMap<String, String>();
        optionalParams.put("DisableTimeoutInMinutes", disableTimeoutInMinutes);
        optionalParams.put("LBEnabled", Boolean.toString(lbEnabled));
        optionalParams.put("Enabled", Boolean.toString(enabled));
        return this.create(referencedServerName, optionalParams);
    }

    public void removeByName(String referencedServerName) {
        this.mOldClusterMBean.removeServerRefByRef(referencedServerName);
    }
}

