/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;

public class ResourceRefConfigFactory
extends ConfigFactory {
    public ResourceRefConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
    }

    protected Map getParamNameOverrides() {
        return MapUtil.newMap("name", "ref");
    }

    public ObjectName create(String referencedResourceName, Map optional) {
        String j2eeType = this.getFactoryContainer().getJ2EEType();
        String containerName = this.getFactoryContainer().getName();
        this.getOldResourcesMBean().createResourceReference(containerName, true, referencedResourceName);
        ObjectName pattern = null;
        pattern = "X-StandaloneServerConfig".equals(j2eeType) ? Util.newObjectNamePattern("com.sun.appserv", "type=resource-ref,ref=" + referencedResourceName + ",server=" + containerName) : Util.newObjectNamePattern("com.sun.appserv", "type=resource-ref,ref=" + referencedResourceName + ",cluster=" + containerName);
        Set<ObjectName> oldNames = this.getCallbacks().getMBeanServer().queryNames(pattern, null);
        ObjectName oldObjectName = (ObjectName)SetUtil.getSingleton(oldNames);
        ObjectName amxName = this.syncNewAMXMBeanWithOld(oldObjectName);
        return amxName;
    }

    public ObjectName create(String referencedResourceName) {
        return this.create(referencedResourceName, null);
    }

    public ObjectName create(String referencedResourceName, boolean enabled) {
        HashMap<String, String> optionalParams = new HashMap<String, String>();
        optionalParams.put("Enabled", Boolean.toString(enabled));
        return this.create(referencedResourceName, optionalParams);
    }

    protected void internalRemove(ObjectName objectName) {
        String containerName = this.getFactoryContainer().getName();
        this.getOldResourcesMBean().deleteResourceReference(containerName, Util.getName(objectName));
    }
}

