/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ddgenerator.sun;

import com.sun.enterprise.ddgenerator.sun.Application;
import com.sun.enterprise.ddgenerator.sun.DummyRoleMapperFactory;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.EjbArchivist;
import com.sun.enterprise.deployment.archivist.FileArchive;
import com.sun.enterprise.deployment.interfaces.DDGenerator;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactory;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactoryMgr;
import com.sun.enterprise.deployment.io.DescriptorConstants;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.xml.sax.SAXParseException;

public class EjbModule
implements DDGenerator {
    private EjbBundleDescriptor ejbBundleDescriptor = null;
    private String applicationDirectory = null;

    public EjbModule() {
    }

    public EjbModule(EjbBundleDescriptor ejbBundleDescriptor, String applicationDirectory) {
        this.ejbBundleDescriptor = ejbBundleDescriptor;
        this.applicationDirectory = applicationDirectory;
    }

    public void setApplicationDirectory(String applicationDirectory) {
        this.applicationDirectory = applicationDirectory;
    }

    public void setDescriptor(Descriptor descriptor) {
        this.ejbBundleDescriptor = (EjbBundleDescriptor)descriptor;
    }

    public void generate() {
        if (this.ejbBundleDescriptor == null) {
            return;
        }
        Set ejbDescriptors = this.ejbBundleDescriptor.getEjbs();
        Iterator it = ejbDescriptors.iterator();
        while (it.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)it.next();
            String jndiName = ejbDescriptor.getJndiName();
            if (jndiName != null && jndiName.length() >= 1) continue;
            String homeName = ejbDescriptor.getHomeClassName();
            ejbDescriptor.setJndiName(homeName);
        }
    }

    public boolean hasSunDescriptor() {
        File file = this.getSunDescriptorFile();
        if (file == null) {
            return false;
        }
        return file.exists();
    }

    public void backupSunDescriptor() {
        File file = this.getSunDescriptorFile();
        if (file == null) {
            return;
        }
        if (file.exists()) {
            try {
                FileUtils.copy(file, new File(file.getAbsolutePath() + ".bak"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private File getSunDescriptorFile() {
        File file = null;
        String archiveUri = this.ejbBundleDescriptor.getModuleDescriptor().getArchiveUri();
        String friendlyFileName = FileUtils.makeFriendlyFilename(archiveUri);
        String sunXmlFileName = this.applicationDirectory + File.separator + friendlyFileName + File.separator + DescriptorConstants.S1AS_EJB_DD_ENTRY;
        file = new File(sunXmlFileName);
        return file;
    }

    public static void main(String[] args) {
        System.out.println("Ejb");
        String appDir = "/home/sreeni/TEMP/stateless-converterEjb_1";
        System.out.println("Press enter to continue ...");
        try {
            System.in.read();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        FileArchive in = new FileArchive();
        try {
            in.open(appDir);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        EjbArchivist ejbArchivist = new EjbArchivist();
        ejbArchivist.setXMLValidation(false);
        ejbArchivist.setClassLoader(null);
        com.sun.enterprise.deployment.Application application = null;
        if (SecurityRoleMapperFactoryMgr.getFactory() == null) {
            DummyRoleMapperFactory srmf = new DummyRoleMapperFactory();
            SecurityRoleMapperFactoryMgr.registerFactory((SecurityRoleMapperFactory)srmf);
        }
        try {
            application = ApplicationArchivist.openArchive((Archivist)ejbArchivist, (AbstractArchive)in, (boolean)true);
        }
        catch (IOException ioe) {
        }
        catch (SAXParseException saxpe) {
            // empty catch block
        }
        Application app = new Application(application, appDir);
        app.generate();
    }
}

