/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.serverbeans.MdbContainer;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;

public class MdbContainerTest
extends GenericValidator {
    public MdbContainerTest(ValidationDescriptor desc) {
        super(desc);
    }

    public Result validate(ConfigContextEvent cce) {
        Result result = super.validate(cce);
        if (cce.getChoice().equals("UPDATE")) {
            ConfigContext context = cce.getConfigContext();
            this.validateAttribute(cce.getName(), (String)cce.getObject(), result, (MdbContainer)cce.getClassObject());
        }
        return result;
    }

    public void validateAttribute(String name, String value, Result result, MdbContainer mdbcontainer) {
        if (name.equals(ServerTags.MAX_POOL_SIZE)) {
            int maxpoolsize;
            try {
                maxpoolsize = Integer.parseInt(value);
                if (maxpoolsize < Integer.parseInt(mdbcontainer.getSteadyPoolSize())) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidMaxPoolWRTSteadyPool", "Attribute(id=max-pool-size) : max-pool-size ({0}) should be no less than steady pool size ({1})", new Object[]{value, mdbcontainer.getSteadyPoolSize()}));
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            try {
                maxpoolsize = Integer.parseInt(value);
                if (maxpoolsize < Integer.parseInt(mdbcontainer.getPoolResizeQuantity())) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidMaxPoolWRTPoolResizeQuantity", "Attribute(id=max-pool-size) : max-pool-size ({0}) should be no less than pool resize quantity ({1})", new Object[]{value, mdbcontainer.getPoolResizeQuantity()}));
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (name.equals(ServerTags.STEADY_POOL_SIZE)) {
            try {
                int steadypoolsize = Integer.parseInt(value);
                if (steadypoolsize > Integer.parseInt(mdbcontainer.getMaxPoolSize())) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidSteadyPool", "Attribute(id=steady-pool-size) : steady-pool-size ({0}) should be no greater than Maximum pool size ({1})", new Object[]{value, mdbcontainer.getMaxPoolSize()}));
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (name.equals(ServerTags.POOL_RESIZE_QUANTITY)) {
            try {
                int poolresize = Integer.parseInt(value);
                if (poolresize > Integer.parseInt(mdbcontainer.getMaxPoolSize())) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidPoolResizeQuantity", "Attribute(id=pool-resize-quantity) : pool-resize-quantity ({0}) should be no greater than Maximum pool size ({1})", new Object[]{value, mdbcontainer.getMaxPoolSize()}));
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }
}

