/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.serverbeans.validation.AttrType;
import com.sun.enterprise.config.serverbeans.validation.DomainCheck;
import com.sun.enterprise.config.serverbeans.validation.GenericDesc;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.StringManagerHelper;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import com.sun.enterprise.config.serverbeans.validation.tests.StaticTest;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GenericValidator
implements DomainCheck {
    protected static Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.tools.verifier");
    protected LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    ValidationDescriptor desc;

    public GenericValidator(ValidationDescriptor desc) {
        this.desc = desc;
        try {
            StringManagerHelper.setLocalStringsManager(Class.forName(this.getClass().getSuperclass().getName()));
            this.smh = StringManagerHelper.getLocalStringsManager();
        }
        catch (ClassNotFoundException e) {
            _logger.log(Level.FINE, "domainxmlverifier.class_notfound_exception", e);
        }
    }

    public GenericDesc initialize(ConfigContextEvent cce) {
        GenericDesc genDesc = new GenericDesc(new Result(), cce.getObject(), cce.getBeanName(), cce.getConfigContext(), cce.getName(), cce.getChoice(), this.desc.getKey(), this.smh);
        String key = this.desc.getKey();
        String element = this.desc.getElementName();
        if (genDesc.value instanceof ConfigBean) {
            genDesc.result.setAssertion(element);
            try {
                genDesc.result.setTestName(this.smh.getLocalString(this.getClass().getName() + ".Elementkeyvalue", "{0} = {1}", new Object[]{key, ((ConfigBean)genDesc.value).getAttributeValue(key)}));
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "domainxmlverifier.keynotfound", e);
            }
        }
        genDesc.result.setStatus(0);
        return genDesc;
    }

    public Result basicValidator(GenericDesc genDesc) {
        block6: {
            Vector attrs;
            block5: {
                _logger.log(Level.CONFIG, "GenericValidator processing choice: " + genDesc.choice);
                attrs = this.desc.getAttributes();
                if (genDesc.choice == null || !genDesc.choice.equals("ADD") && !genDesc.choice.equals("OFFLINE")) break block5;
                String key = this.desc.getKey();
                for (int i = 0; i < attrs.size(); ++i) {
                    AttrType attr = (AttrType)attrs.get(i);
                    String attrName = attr.getName();
                    genDesc.setAttrName(attrName);
                    try {
                        String o = ((ConfigBean)genDesc.value).getAttributeValue(attrName);
                        if (StaticTest.valueContainsTokenExpression(o)) continue;
                        attr.validate(o, genDesc);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        genDesc.result.failed(e.getMessage());
                        continue;
                    }
                    catch (Exception e) {
                        _logger.log(Level.WARNING, "domainxmlverifier.errorinvokingmethod", e);
                    }
                }
                break block6;
            }
            if ((genDesc.choice == null || !genDesc.choice.equals("UPDATE")) && !genDesc.choice.equals("SET")) break block6;
            this.preventChangesToPrimaryKey(genDesc);
            for (int i = 0; i < attrs.size(); ++i) {
                Object type = null;
                AttrType attr = (AttrType)attrs.get(i);
                if (!attr.getName().equals(genDesc.name) || StaticTest.valueContainsTokenExpression((String)genDesc.value)) continue;
                _logger.log(Level.WARNING, "setting attribute: " + attr.getName() + " to: " + genDesc.value);
                genDesc.setAttrName(attr.getName());
                attr.validate(genDesc.value, genDesc);
            }
        }
        return genDesc.result;
    }

    private void preventChangesToPrimaryKey(GenericDesc genDesc) {
        if (this.desc != null && this.desc.getKey() != null && this.desc.getKey().equals(genDesc.name)) {
            genDesc.result.failed(genDesc.smh.getLocalString(this.getClass().getName() + ".accessDenied", "Cannot change a primary key", new Object[]{genDesc.name}));
        }
    }

    public Result validate(ConfigContextEvent cce) {
        GenericDesc genDesc = this.initialize(cce);
        Result result = this.basicValidator(genDesc);
        return result;
    }
}

