/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.backup;

import com.sun.enterprise.config.backup.BackupRequest;
import com.sun.enterprise.config.backup.LoggerHelper;
import com.sun.enterprise.config.backup.StringHelper;
import com.sun.enterprise.config.backup.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import java.util.zip.ZipInputStream;

class Status {
    private BackupRequest request;
    private File statusFile;
    private Properties props;

    Status() {
    }

    String write(BackupRequest req) {
        this.props = new Properties();
        this.request = req;
        this.statusFile = new File(this.request.domainDir, "backup.properties");
        try {
            this.setProps();
            FileOutputStream out = new FileOutputStream(this.statusFile);
            this.props.store(out, "Backup Status");
            return this.propsToString(false);
        }
        catch (Exception e) {
            return StringHelper.get("backup-res.CantWriteStatus", this.statusFile);
        }
    }

    String read(File file, boolean terse) {
        this.props = null;
        this.setPropsFromFile(file);
        if (this.props == null) {
            return this.badStatusFileMessage(file);
        }
        return this.propsToString(terse);
    }

    long getInternalTimestamp(File f) {
        this.props = null;
        this.setPropsFromFile(f);
        try {
            String s = this.props.getProperty("timestamp.msec");
            return Long.parseLong(s);
        }
        catch (Exception e) {
            LoggerHelper.warning(this.badStatusFileMessage(f));
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setPropsFromFile(File file) {
        this.props = null;
        zis = null;
        if (file.getName().toLowerCase().endsWith(".properties")) {
            this.readPropertiesFile(file);
            return;
        }
        try {
            try {
                zis = new ZipInputStream(new FileInputStream(file));
                while ((ze = zis.getNextEntry()) != null) {
                    if (!ze.getName().equals("backup.properties")) continue;
                    this.props = new Properties();
                    this.props.load(zis);
                    break;
                }
            }
            catch (Exception e) {
                this.props = null;
                var5_6 = null;
                if (zis == null) return;
                try {
                    zis.close();
                    return;
                }
                catch (Exception e) {
                    return;
                }
            }
            var5_5 = null;
            if (zis == null) return;
        }
        catch (Throwable var4_11) {
            var5_7 = null;
            if (zis == null) throw var4_11;
            ** try [egrp 2[TRYBLOCK] [4 : 119->126)] { 
lbl34:
            // 1 sources

            zis.close();
            throw var4_11;
lbl36:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
            throw var4_11;
        }
        try {}
        catch (Exception e) {}
        zis.close();
        return;
    }

    private void readPropertiesFile(File propsFile) {
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(propsFile));
            this.props = new Properties();
            this.props.load(in);
            in.close();
        }
        catch (IOException ioe) {
            this.props = null;
        }
    }

    void delete() {
        if (!this.statusFile.delete()) {
            this.statusFile.deleteOnExit();
        }
    }

    private void setProps() {
        this.props.setProperty("user.name", System.getProperty("user.name"));
        this.props.setProperty("timestamp.msec", "" + this.request.timestamp);
        this.props.setProperty("domains.dir", FileUtils.safeGetCanonicalPath(this.request.domainsDir));
        this.props.setProperty("domain.dir", FileUtils.safeGetCanonicalPath(this.request.domainDir));
        this.props.setProperty("backup.file", FileUtils.safeGetCanonicalPath(this.request.backupFile));
        this.props.setProperty("domain.name", this.request.domainName);
        this.props.setProperty("description", this.request.description);
        this.props.setProperty("timestamp.human", new Date(this.request.timestamp).toString());
    }

    private String propsToString(boolean terse) {
        String pre = "backup-res.Props.";
        StringBuffer sb = new StringBuffer();
        if (terse) {
            sb.append(this.props.getProperty("backup.file"));
        } else {
            sb.append(StringHelper.get("backup-res.Props.description", this.props.getProperty("description")));
            sb.append("\n");
            sb.append(StringHelper.get("backup-res.Props.backup.file", this.props.getProperty("backup.file")));
            sb.append("\n");
            sb.append(StringHelper.get("backup-res.Props.timestamp.human", this.props.getProperty("timestamp.human")));
            sb.append("\n");
            sb.append(StringHelper.get("backup-res.Props.domains.dir", this.props.getProperty("domains.dir")));
            sb.append("\n");
            sb.append(StringHelper.get("backup-res.Props.domain.dir", this.props.getProperty("domain.dir")));
            sb.append("\n");
            sb.append(StringHelper.get("backup-res.Props.domain.name", this.props.getProperty("domain.name")));
            sb.append("\n");
            sb.append(StringHelper.get("backup-res.Props.user.name", this.props.getProperty("user.name")));
        }
        return sb.toString();
    }

    private String badStatusFileMessage(File file) {
        String msg = StringHelper.get("backup-res.Props.backup.file", file);
        msg = msg + "\n";
        msg = msg + StringHelper.get("backup-res.CorruptBackupFile.NoStatusFile");
        return msg;
    }
}

