/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermodel.controllers;

import com.sun.enterprise.admin.common.exception.AFException;
import com.sun.enterprise.admin.servermodel.beans.Profiler;
import com.sun.enterprise.admin.servermodel.context.ContextHolder;
import com.sun.enterprise.admin.servermodel.controllers.Controller;
import com.sun.enterprise.admin.servermodel.controllers.SOMRequestDispatcher;
import com.sun.enterprise.admin.util.ArgChecker;
import javax.management.ObjectName;

public class ProfilerController
implements Controller {
    private static final String GET_JVM_OPTIONS = "getJvmOptions";
    private static final String SET_JVM_OPTIONS = "setJvmOptions";
    private Profiler profiler;

    public ProfilerController(Profiler profiler) {
        this.profiler = profiler;
    }

    public String[] getJvmOptions() throws AFException {
        String[] options = (String[])this.invoke(GET_JVM_OPTIONS, null, null);
        return options;
    }

    public void setJvmOptions(String[] options) throws AFException {
        ArgChecker.checkValid(options, "options");
        String[] signature = new String[]{options.getClass().getName()};
        Object[] params = new Object[]{options};
        this.invoke(SET_JVM_OPTIONS, params, signature);
    }

    private Object invoke(String operation, Object[] params, String[] signature) throws AFException {
        try {
            ContextHolder ctxHolder = this.profiler.getContextHolder();
            ObjectName mbeanName = new ObjectName(this.profiler.getIdentifier());
            SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
            return dispatcher.invoke(mbeanName, operation, params, signature);
        }
        catch (Exception e) {
            if (e instanceof AFException) {
                throw (AFException)e;
            }
            throw new AFException(e.getLocalizedMessage());
        }
    }
}

