/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermodel.controllers;

import com.sun.enterprise.admin.common.ObjectNames;
import com.sun.enterprise.admin.common.exception.AFException;
import com.sun.enterprise.admin.common.exception.AFOtherException;
import com.sun.enterprise.admin.servermodel.beans.DeployedEJBModuleComponentBean;
import com.sun.enterprise.admin.servermodel.beans.DeployedEntityBeanComponentBean;
import com.sun.enterprise.admin.servermodel.beans.DeployedSessionBeanComponentBean;
import com.sun.enterprise.admin.servermodel.context.ContextHolder;
import com.sun.enterprise.admin.servermodel.controllers.Controller;
import com.sun.enterprise.admin.servermodel.controllers.SOMRequestDispatcher;
import com.sun.enterprise.admin.servermodel.util.ServerModelIterator;
import com.sun.enterprise.admin.util.Assert;
import com.sun.enterprise.admin.util.Debug;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class DeployedEJBModuleComponentController
implements Controller {
    private static final String LIST_ALL_EJBS = "getEnterpriseBeans";
    private static final String LIST_SESSION_BEANS = "getSessionEJBs";
    private static final String LIST_ENTITY_BEANS = "getEntityEJBs";
    private DeployedEJBModuleComponentBean deployedModule;

    public DeployedEJBModuleComponentController(DeployedEJBModuleComponentBean deployedModule) {
        this.deployedModule = deployedModule;
    }

    public String[] getEJBs() throws AFException {
        String[] ejbs = (String[])this.invoke(LIST_ALL_EJBS, null, null);
        return ejbs;
    }

    public ServerModelIterator getEntityBeans() throws AFException {
        String[] entityBeans = (String[])this.invoke(LIST_ENTITY_BEANS, null, null);
        Vector<DeployedEntityBeanComponentBean> list = new Vector<DeployedEntityBeanComponentBean>();
        if (entityBeans != null && entityBeans.length > 0) {
            for (int i = 0; i < entityBeans.length; ++i) {
                ObjectName mbeanName = null;
                String instanceName = this.deployedModule.getInstanceName();
                String moduleName = this.deployedModule.getModuleName();
                boolean isStandAloneModule = this.deployedModule.isStandAlone();
                if (isStandAloneModule) {
                    mbeanName = ObjectNames.getEjbObjectName(instanceName, moduleName, entityBeans[i]);
                } else {
                    String appName = this.deployedModule.getAppName();
                    mbeanName = ObjectNames.getEjbObjectName(instanceName, appName, moduleName, entityBeans[i]);
                }
                Assert.assertit(mbeanName != null, "null value returned");
                Debug.println("DeployedEJBModuleComponentController.getEntityBeans: mbeanName = " + mbeanName);
                DeployedEntityBeanComponentBean entityBean = new DeployedEntityBeanComponentBean(mbeanName.toString(), entityBeans[i]);
                entityBean.setContextHolder(this.deployedModule.getContextHolder());
                list.add(entityBean);
            }
        }
        return new ServerModelIterator(list);
    }

    public ServerModelIterator getSessionBeans() throws AFException {
        String[] sessionBeans = (String[])this.invoke(LIST_SESSION_BEANS, null, null);
        Vector<DeployedSessionBeanComponentBean> list = new Vector<DeployedSessionBeanComponentBean>();
        if (sessionBeans != null && sessionBeans.length > 0) {
            for (int i = 0; i < sessionBeans.length; ++i) {
                ObjectName mbeanName = null;
                String instanceName = this.deployedModule.getInstanceName();
                String moduleName = this.deployedModule.getModuleName();
                boolean isStandAloneModule = this.deployedModule.isStandAlone();
                if (isStandAloneModule) {
                    mbeanName = ObjectNames.getEjbObjectName(instanceName, moduleName, sessionBeans[i]);
                } else {
                    String appName = this.deployedModule.getAppName();
                    mbeanName = ObjectNames.getEjbObjectName(instanceName, appName, moduleName, sessionBeans[i]);
                }
                Assert.assertit(mbeanName != null, "null value returned");
                Debug.println("DeployedEJBModuleComponentController.getSessionBeans: mbeanName = " + mbeanName);
                DeployedSessionBeanComponentBean sessionBean = new DeployedSessionBeanComponentBean(mbeanName.toString(), sessionBeans[i]);
                sessionBean.setContextHolder(this.deployedModule.getContextHolder());
                list.add(sessionBean);
            }
        }
        return new ServerModelIterator(list);
    }

    private Object invoke(String operationName, Object[] params, String[] signature) throws AFException {
        ObjectName mbeanName = null;
        Object retValue = null;
        try {
            mbeanName = new ObjectName(this.deployedModule.getIdentifier());
            ContextHolder ctxHolder = this.deployedModule.getContextHolder();
            SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
            retValue = dispatcher.invoke(mbeanName, operationName, params, signature);
        }
        catch (MalformedObjectNameException mone) {
            throw new AFOtherException(mone);
        }
        return retValue;
    }
}

