/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.admin.common.Status;
import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.admin.servermgmt.InstancesManager;
import com.sun.enterprise.server.logging.FileandSyslogHandler;
import java.io.Serializable;
import java.util.Vector;

public class RuntimeStatus
implements Serializable {
    private boolean _restartNeeded;
    private Status _status;
    private Vector _recentErrorMessages;
    private String _name;

    public static RuntimeStatus getRuntimeStatus(String name, InstancesManager manager) throws InstanceException {
        int status = manager.getInstanceStatus();
        return new RuntimeStatus(name, manager.isRestartNeeded(), new Status(status, Status.getStatusString(status)), FileandSyslogHandler.getRecentErrorMessages());
    }

    public static void clearRuntimeStatus() {
        FileandSyslogHandler.clearRecentErrorMessages();
    }

    public RuntimeStatus() {
        this("", true, new Status(3, "not running"), new Vector());
    }

    public RuntimeStatus(String name) {
        this();
        this._name = name;
    }

    public RuntimeStatus(String name, boolean restartNeeded, Status status, Vector recentErrors) {
        this._name = name;
        this._restartNeeded = restartNeeded;
        this._status = status;
        this._recentErrorMessages = recentErrors;
    }

    public boolean isRestartNeeded() {
        return this._restartNeeded;
    }

    public String getName() {
        return this._name;
    }

    public void setStatus(Status status) {
        this._status = status;
    }

    public Status getStatus() {
        return this._status;
    }

    public Vector getRecentErrorMessages() {
        return this._recentErrorMessages;
    }

    public boolean isRunning() {
        return this.getStatus().getStatusCode() == 0;
    }

    public boolean isStopped() {
        return this.getStatus().getStatusCode() == 3;
    }

    public String toShortString() {
        String result = this.getStatus().getStatusString();
        if (this.isRunning() && this.isRestartNeeded()) {
            result = "requires restart";
        }
        return result;
    }

    public String toString() {
        String result = this.getName() + " is " + this.getStatus().getStatusString();
        result = this.isRestartNeeded() ? result + ", requires restart" : result + ", does not require restart";
        Vector messages = this.getRecentErrorMessages();
        for (int i = 0; i < messages.size(); ++i) {
            result = result + "\nerror " + i + " " + (String)messages.get(i);
        }
        return result;
    }
}

