/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.stats.spi;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.JVMRuntimeStats;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.StringStatistic;
import com.sun.enterprise.admin.monitor.stats.StringStatisticImpl;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;

public class JVMRuntimeStatsImpl
implements JVMRuntimeStats {
    private GenericStatsImpl baseStatsImpl;
    private static final String STATS_INTERFACE_NAME = "com.sun.enterprise.admin.monitor.stats.JVMRuntimeStats";
    private MBeanServer server;
    private MutableCountStatistic upTime;
    private StringStatistic name;
    private RuntimeMXBean bean;
    final long initTime = System.currentTimeMillis();

    public JVMRuntimeStatsImpl() {
        try {
            this.baseStatsImpl = new GenericStatsImpl(STATS_INTERFACE_NAME, (Object)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bean = ManagementFactory.getRuntimeMXBean();
        this.initializeStatistics();
    }

    public StringStatistic getName() {
        String name = this.bean.getName();
        return new StringStatisticImpl(name, "Name", "String", "The name of the running JVM", this.initTime, System.currentTimeMillis());
    }

    public StringStatistic getBootClasspath() {
        String bclasspath = this.bean.getBootClassPath();
        return new StringStatisticImpl(bclasspath, "BootClassPath", "String", "The boot classpath of the bootstrap class loader", this.initTime, System.currentTimeMillis());
    }

    public StringStatistic getClassPath() {
        String cpath = this.bean.getClassPath();
        return new StringStatisticImpl(cpath, "ClassPath", "String", "The classpath of the system class loader", this.initTime, System.currentTimeMillis());
    }

    public StringStatistic getInputArguments() {
        ArrayList<String> inputArgs = new ArrayList<String>();
        inputArgs.addAll(this.bean.getInputArguments());
        return new StringStatisticImpl(inputArgs.toString(), "InputArguments", "String", "Input Arguments to the JVM", this.initTime, System.currentTimeMillis());
    }

    public StringStatistic getLibraryPath() {
        String libpath = this.bean.getLibraryPath();
        return new StringStatisticImpl(libpath, "LibraryPath", "String", "Java Library path", this.initTime, System.currentTimeMillis());
    }

    public StringStatistic getManagementSpecVersion() {
        String ver = this.bean.getManagementSpecVersion();
        return new StringStatisticImpl(ver, "ManagementSpecVersion", "String", "Version of Management Spec implemented by the JVM", this.initTime, System.currentTimeMillis());
    }

    public StringStatistic getSpecName() {
        String specname = this.bean.getSpecName();
        return new StringStatisticImpl(specname, "SpecName", "String", "JVM specification name", this.initTime, System.currentTimeMillis());
    }

    public StringStatistic getSpecVendor() {
        String specvendor = this.bean.getSpecVendor();
        return new StringStatisticImpl(specvendor, "SpecVendor", "String", "JVM specification vendor", this.initTime, System.currentTimeMillis());
    }

    public StringStatistic getSpecVersion() {
        String specver = this.bean.getSpecVersion();
        return new StringStatisticImpl(specver, "SpecVersion", "String", "JVM specification version", this.initTime, System.currentTimeMillis());
    }

    public CountStatistic getUptime() {
        long u = this.bean.getUptime();
        this.upTime.setCount(u);
        return (CountStatistic)this.upTime.unmodifiableView();
    }

    public StringStatistic getVmName() {
        String vmname = this.bean.getVmName();
        return new StringStatisticImpl(vmname, "VmName", "String", "JVM implementation name", this.initTime, System.currentTimeMillis());
    }

    public StringStatistic getVmVendor() {
        String vmvendor = this.bean.getVmVendor();
        return new StringStatisticImpl(vmvendor, "VmVendor", "String", "JVM implementation vendor", this.initTime, System.currentTimeMillis());
    }

    public StringStatistic getVmVersion() {
        String vmver = this.bean.getVmVersion();
        return new StringStatisticImpl(vmver, "VmVersion", "String", "JVM implementation version", this.initTime, System.currentTimeMillis());
    }

    public Statistic[] getStatistics() {
        return this.baseStatsImpl.getStatistics();
    }

    public Statistic getStatistic(String str) {
        return this.baseStatsImpl.getStatistic(str);
    }

    public String[] getStatisticNames() {
        return this.baseStatsImpl.getStatisticNames();
    }

    private void initializeStatistics() {
        CountStatisticImpl c = new CountStatisticImpl("TotalCompilationTime", "milliseconds");
        this.upTime = new MutableCountStatisticImpl(c);
    }
}

