/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.stats.spi;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.JVMClassLoadingStats;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;

public class JVMClassLoadingStatsImpl
implements JVMClassLoadingStats {
    private GenericStatsImpl baseStatsImpl;
    private static final String STATS_INTERFACE_NAME = "com.sun.enterprise.admin.monitor.stats.JVMClassLoadingStats";
    private MutableCountStatistic loadedClassCount;
    private MutableCountStatistic unloadedClassCount;
    private MutableCountStatistic totalLoadedClassCount;
    private ClassLoadingMXBean bean;

    public JVMClassLoadingStatsImpl() {
        try {
            this.baseStatsImpl = new GenericStatsImpl(STATS_INTERFACE_NAME, (Object)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bean = ManagementFactory.getClassLoadingMXBean();
        this.initializeStatistics();
    }

    public CountStatistic getTotalLoadedClassCount() {
        long classCount = this.bean.getTotalLoadedClassCount();
        this.totalLoadedClassCount.setCount(classCount);
        return (CountStatistic)this.totalLoadedClassCount.unmodifiableView();
    }

    public CountStatistic getLoadedClassCount() {
        long classCount = this.bean.getLoadedClassCount();
        this.loadedClassCount.setCount(classCount);
        return (CountStatistic)this.loadedClassCount.unmodifiableView();
    }

    public CountStatistic getUnloadedClassCount() {
        long classCount = this.bean.getUnloadedClassCount();
        this.unloadedClassCount.setCount(classCount);
        return (CountStatistic)this.unloadedClassCount.unmodifiableView();
    }

    public Statistic[] getStatistics() {
        return this.baseStatsImpl.getStatistics();
    }

    public Statistic getStatistic(String str) {
        return this.baseStatsImpl.getStatistic(str);
    }

    public String[] getStatisticNames() {
        return this.baseStatsImpl.getStatisticNames();
    }

    private void initializeStatistics() {
        CountStatisticImpl c = new CountStatisticImpl("TotalLoadedClassCount");
        this.totalLoadedClassCount = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl("LoadedClassCount");
        this.loadedClassCount = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl("UnloadedClassCount");
        this.unloadedClassCount = new MutableCountStatisticImpl(c);
    }
}

