/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.registry.spi;

import [Ljava.lang.String;;
import [Ljavax.management.ObjectName;;
import [Ljavax.management.j2ee.statistics.Statistic;;
import com.sun.enterprise.admin.monitor.registry.StatsHolder;
import com.sun.enterprise.admin.monitor.registry.spi.DottedNameRegistrar;
import com.sun.enterprise.admin.monitor.registry.spi.StatisticWorkaround;
import com.sun.enterprise.admin.monitor.registry.spi.StatsHolderMBean;
import com.sun.enterprise.admin.monitor.registry.spi.StatsMediator;
import com.sun.enterprise.admin.monitor.registry.spi.StatsMediatorImpl;
import com.sun.enterprise.admin.monitor.stats.JTAStats;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;

class StatsHolderMBeanImpl
implements DynamicMBean,
StatsHolderMBean,
MBeanRegistration {
    private static Logger logger;
    private static StringManager sm;
    private final StatsHolder delegate;
    private final StatsMediator mediator;
    private DottedNameRegistrar registrar;
    private MBeanInfo mi;
    private int state;
    private Object lock = new Object();
    public static final int INITIALIZED = 0;
    public static final int REGISTERED = 1;
    public static final int MBEANINFO_DONE = 2;
    public static final String JTA_FREEZE = "freeze";
    public static final String JTA_UNFREEZE = "unfreeze";
    public static final String JTA_ROLLBACK = "rollback";
    public static final String DOTTED_NAME = "dotted-name";
    static final /* synthetic */ boolean $assertionsDisabled;

    StatsHolderMBeanImpl(StatsHolder delegate) {
        if (!$assertionsDisabled && delegate == null) {
            throw new AssertionError();
        }
        this.delegate = delegate;
        this.mediator = new StatsMediatorImpl(delegate.getStats(), delegate.getStatsClass());
        this.changeState(0);
    }

    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (name.equals(DOTTED_NAME)) {
            return this.delegate.getDottedName();
        }
        return this.mediator.getAttribute(name);
    }

    public AttributeList getAttributes(String[] names) {
        AttributeList list = new AttributeList();
        for (int i = 0; i < names.length; ++i) {
            try {
                Attribute a = new Attribute(names[i], this.getAttribute(names[i]));
                list.add(a);
                continue;
            }
            catch (Exception e) {
                logger.finest("Error while accessing an attribute named: " + names[i]);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBeanInfo getMBeanInfo() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == 2) {
                return this.mi;
            }
        }
        this.build();
        this.changeState(2);
        return this.mi;
    }

    private void build() {
        String name = StatsHolderMBeanImpl.class.getName();
        String desc = this.getDescription();
        MBeanAttributeInfo[] mais = this.mediator.getAttributeInfos();
        MBeanConstructorInfo[] mcis = this.getConstructorInfos();
        MBeanOperationInfo[] mois = this.getOperationInfos();
        MBeanNotificationInfo[] mnis = this.getNotificationInfos();
        this.mi = new MBeanInfo(name, desc, mais, mcis, mois, mnis);
    }

    private String getDescription() {
        return "StatsHolder MBean for: " + StatsHolderMBeanImpl.class.getName();
    }

    private MBeanConstructorInfo[] getConstructorInfos() {
        MBeanConstructorInfo[] cis = new MBeanConstructorInfo[]{};
        return cis;
    }

    private MBeanOperationInfo[] getOperationInfos() {
        ArrayList<MBeanOperationInfo> opInfo = new ArrayList<MBeanOperationInfo>();
        opInfo.add(this.getChildrenInfo());
        opInfo.add(this.getNameInfo());
        opInfo.add(this.getTypeInfo());
        if (this.delegate.getStats() != null) {
            opInfo.add(this.getStatisticNameInfo());
            opInfo.add(this.getStatsInfo());
        }
        MBeanOperationInfo[] mos = new MBeanOperationInfo[opInfo.size()];
        mos = opInfo.toArray(mos);
        if (this.isJta()) {
            return this.getJTAOperationInfo(mos);
        }
        return mos;
    }

    public Object invoke(String method, Object[] params, String[] sign) throws MBeanException, ReflectionException {
        if ("getChildren".equals(method)) {
            return this.getChildren();
        }
        if ("getName".equals(method)) {
            return this.getName();
        }
        if ("getType".equals(method)) {
            return this.getType();
        }
        if ("getStatisticNames".equals(method)) {
            return this.getStatisticNames();
        }
        if ("getStatistics".equals(method)) {
            return this.getStatistics();
        }
        if (this.isJTAMethod(method)) {
            return this.mediator.invoke(method, params, sign);
        }
        String msg = sm.getString("smi.no_such_method", (Object)method);
        UnsupportedOperationException ae = new UnsupportedOperationException(msg);
        throw new MBeanException(ae);
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new UnsupportedOperationException("NYI");
    }

    public AttributeList setAttributes(AttributeList attributes) {
        throw new UnsupportedOperationException("NYI");
    }

    public ObjectName[] getChildren() {
        Collection c = this.delegate.getAllChildren();
        ObjectName[] names = new ObjectName[c.size()];
        Iterator it = c.iterator();
        int i = 0;
        while (it.hasNext()) {
            StatsHolder s = (StatsHolder)it.next();
            names[i++] = s.getObjectName();
        }
        if (!$assertionsDisabled && names.length != i) {
            throw new AssertionError((Object)"Sizes don't match");
        }
        return names;
    }

    private MBeanOperationInfo getChildrenInfo() {
        MBeanOperationInfo info = new MBeanOperationInfo("getChildren", "Gets the children of this StatsHolder", null, ObjectName;.class.getName(), 0);
        return info;
    }

    private MBeanNotificationInfo[] getNotificationInfos() {
        MBeanNotificationInfo[] mns = new MBeanNotificationInfo[]{};
        return mns;
    }

    private boolean isJta() {
        boolean isJta = false;
        Class cl = this.delegate.getStatsClass();
        if (cl != null && JTAStats.class.getName().equals(cl.getName())) {
            isJta = true;
        }
        return isJta;
    }

    private boolean isJTAMethod(String methodName) {
        return JTA_FREEZE.equals(methodName) || JTA_UNFREEZE.equals(methodName) || JTA_ROLLBACK.equals(methodName);
    }

    public void postDeregister() {
    }

    public void postRegister(Boolean registered) {
        if (registered.equals(Boolean.TRUE)) {
            this.registrar.registerDottedName(this.delegate.getDottedName(), this.delegate.getObjectName());
            this.changeState(1);
        }
    }

    public void preDeregister() throws Exception {
        this.registrar.unregisterDottedName(this.delegate.getDottedName());
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.registrar = new DottedNameRegistrar(mBeanServer);
        return objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(int to) {
        Object object = this.lock;
        synchronized (object) {
            this.state = to;
        }
    }

    private MBeanOperationInfo[] getJTAOperationInfo(MBeanOperationInfo[] mos) {
        ArrayList<MBeanOperationInfo> opInfo = new ArrayList<MBeanOperationInfo>();
        for (int i = 0; i < mos.length; ++i) {
            opInfo.add(mos[i]);
        }
        MBeanOperationInfo mInfo = new MBeanOperationInfo(JTA_FREEZE, "Freezes the transaction service", null, Void.TYPE.getName(), 1);
        opInfo.add(mInfo);
        mInfo = new MBeanOperationInfo(JTA_UNFREEZE, "Unfreezes the transaction service", null, Void.TYPE.getName(), 1);
        opInfo.add(mInfo);
        mInfo = new MBeanOperationInfo(JTA_ROLLBACK, "Rollsback a given transaction", new MBeanParameterInfo[]{new MBeanParameterInfo("txnId", String.class.getName(), "Id of the transaction to be rolled back")}, Void.TYPE.getName(), 1);
        opInfo.add(mInfo);
        MBeanOperationInfo[] jtaOpInfo = new MBeanOperationInfo[opInfo.size()];
        return opInfo.toArray(jtaOpInfo);
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getType() {
        return this.delegate.getType().getTypeName();
    }

    private MBeanOperationInfo getNameInfo() {
        MBeanOperationInfo mInfo = new MBeanOperationInfo("getName", "Gets the name of this StatsHolder", null, String.class.getName(), 0);
        return mInfo;
    }

    private MBeanOperationInfo getTypeInfo() {
        MBeanOperationInfo mInfo = new MBeanOperationInfo("getType", "Gets the type of this StatsHolder", null, String.class.getName(), 0);
        return mInfo;
    }

    public String[] getStatisticNames() {
        Stats stats = this.delegate.getStats();
        if (stats != null) {
            return stats.getStatisticNames();
        }
        return null;
    }

    public Statistic[] getStatistics() {
        Stats stats = this.delegate.getStats();
        if (stats == null) {
            return null;
        }
        Object[] statArray = stats.getStatistics();
        boolean isSerializable = this.checkSerializability(statArray);
        if (isSerializable) {
            Statistic[] hackedArray = StatisticWorkaround.populateDescriptions((Statistic[])statArray);
            return hackedArray;
        }
        return null;
    }

    private MBeanOperationInfo getStatisticNameInfo() {
        MBeanOperationInfo mInfo = new MBeanOperationInfo("getStatisticNames", "Gets the names of all the statistics in the given Stats Object", null, String;.class.getName(), 0);
        return mInfo;
    }

    private MBeanOperationInfo getStatsInfo() {
        MBeanOperationInfo mInfo = new MBeanOperationInfo("getStatistics", "returns the results of all the getXXX methods, in the given Stats object", null, Statistic;.class.getName(), 0);
        return mInfo;
    }

    private boolean checkSerializability(Object[] objArray) {
        boolean isSerializable = true;
        for (int i = 0; i < objArray.length; ++i) {
            isSerializable = isSerializable && objArray[i] instanceof Serializable;
        }
        return isSerializable;
    }

    static {
        $assertionsDisabled = !StatsHolderMBeanImpl.class.desiredAssertionStatus();
        logger = Logger.getLogger("javax.enterprise.system.tools.admin");
        sm = StringManager.getManager((Class)StatsHolderMBeanImpl.class);
    }
}

