/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.registry.spi;

import com.sun.enterprise.admin.monitor.registry.spi.AttributeStringHelper;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.j2ee.statistics.Stats;

public class ManagedResourceIntrospector {
    final boolean READABLE = true;
    final boolean WRITABLE = true;
    final boolean ISGETTER = true;
    DynamicMBean mbean;
    Vector attributes;
    public static final String LOGGER_NAME = "this.is.console";
    final Logger logger;
    static /* synthetic */ Class class$javax$management$j2ee$statistics$Statistic;

    ManagedResourceIntrospector(DynamicMBean mbean) {
        this.mbean = mbean;
        this.attributes = new Vector();
        this.logger = Logger.getLogger(LOGGER_NAME);
    }

    MBeanInfo introspect(Stats stats) {
        return new MBeanInfo(this.mbean.getClass().getName(), "Managed Object for " + stats.getClass().getName() + " managed resource", this.getAttributeInfo(stats), null, this.getOperationInfo(stats), null);
    }

    MBeanAttributeInfo[] getAttributeInfo(Stats stats) {
        MBeanAttributeInfo[] attrInfo = null;
        if (stats != null) {
            Object[] attrs = this.deriveUnderlyingAttributes(stats);
            attrInfo = new MBeanAttributeInfo[attrs.length];
            for (int i = 0; i < attrs.length; ++i) {
                attrInfo[i] = new MBeanAttributeInfo((String)attrs[i], (class$javax$management$j2ee$statistics$Statistic == null ? ManagedResourceIntrospector.class$("javax.management.j2ee.statistics.Statistic") : class$javax$management$j2ee$statistics$Statistic).getName(), "Attribute" + attrs[i], true, false, false);
            }
        }
        return attrInfo;
    }

    Object[] deriveUnderlyingAttributes(Stats stats) {
        String[] attrs = stats.getStatisticNames();
        for (int i = 0; i < attrs.length; ++i) {
            this.introspectEachStatistic(stats.getStatistic(attrs[i]).getClass(), attrs[i]);
        }
        String[] a = new String[this.attributes.size()];
        return this.attributes.toArray(a);
    }

    void introspectEachStatistic(Class statistic, String statName) {
        HashSet<Method> a = new HashSet<Method>(Arrays.asList(statistic.getMethods()));
        Iterator it = a.iterator();
        while (it.hasNext()) {
            String s = ((Method)it.next()).getName();
            if (!s.startsWith("get") || s.equals("getClass")) continue;
            s = s.replaceFirst("get", "");
            this.attributes.add(AttributeStringHelper.joinAttributes(statName, s));
        }
    }

    MBeanOperationInfo[] getOperationInfo(Stats stats) {
        Method[] opers = stats.getClass().getMethods();
        MBeanOperationInfo[] operInfo = new MBeanOperationInfo[opers.length];
        for (int i = 0; i < opers.length; ++i) {
            if (this.isAttrGetterOrSetter(opers[i])) continue;
            operInfo[i] = this.createOperationInfo(opers[i]);
        }
        operInfo = this.addMoreMBeanOperations(operInfo);
        return operInfo;
    }

    private MBeanOperationInfo[] addMoreMBeanOperations(MBeanOperationInfo[] operInfo) {
        MBeanOperationInfo oper = new MBeanOperationInfo("listAttributes", "Method listAttributes", null, String.class.getName(), 0);
        MBeanOperationInfo[] opers = new MBeanOperationInfo[operInfo.length + 1];
        opers = operInfo;
        opers[opers.length - 1] = oper;
        return operInfo;
    }

    boolean isAttrGetterOrSetter(Method operation) {
        return operation.getName().startsWith("get") || operation.getName().startsWith("set");
    }

    MBeanOperationInfo createOperationInfo(Method oper) {
        return new MBeanOperationInfo(oper.getName(), "Method " + oper.getName(), this.getParameterInfo(oper.getParameterTypes()), oper.getReturnType().getName(), 0);
    }

    MBeanParameterInfo[] getParameterInfo(Class[] paramTypes) {
        MBeanParameterInfo[] params = null;
        if (paramTypes != null) {
            params = new MBeanParameterInfo[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                try {
                    params[i] = new MBeanParameterInfo("param" + i, paramTypes[i].getName(), paramTypes[i].getName());
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.logger.log(Level.INFO, e.toString());
                }
            }
        }
        return params;
    }
}

