/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.registry.spi;

import com.sun.enterprise.admin.dottedname.DottedName;
import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Logger;

class DottedNameFactory {
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final StringManager sm = StringManager.getManager((Class)DottedNameFactory.class);
    private static String instanceName = null;
    private static final String DELIMITER = ".";

    DottedNameFactory() {
    }

    private static String getInstanceName() {
        if (instanceName == null) {
            try {
                instanceName = ApplicationServer.getServerContext().getInstanceName();
                if (instanceName == null) {
                    String msg = sm.getString("instance_name_not_found");
                    throw new NullPointerException(msg);
                }
            }
            catch (Exception e) {
                logger.fine("DottedNameFactory:" + e.getClass().getName());
                throw new RuntimeException(e);
            }
        }
        return instanceName;
    }

    static String getRootDottedName() {
        return DottedNameFactory.getInstanceName();
    }

    static String getApplicationsDottedName() {
        return DottedNameFactory.getInstanceName() + DELIMITER + MonitoredObjectType.APPLICATIONS;
    }

    static String getResourcesDottedName() {
        return DottedNameFactory.getInstanceName() + DELIMITER + MonitoredObjectType.RESOURCES;
    }

    static String getOrbDottedName() {
        return DottedNameFactory.getInstanceName() + DELIMITER + MonitoredObjectType.ORB;
    }

    static String getTransactionServiceDottedName() {
        return DottedNameFactory.getInstanceName() + DELIMITER + MonitoredObjectType.TRANSACTION_SERVICE;
    }

    static String getThreadPoolsDottedName() {
        return DottedNameFactory.getInstanceName() + DELIMITER + MonitoredObjectType.THREAD_POOLS;
    }

    static String getThreadPoolDottedName(String name) {
        name = DottedName.escapePart((String)name);
        return DottedNameFactory.getThreadPoolsDottedName() + DELIMITER + name;
    }

    static String getHttpServiceDottedName() {
        return DottedNameFactory.getInstanceName() + DELIMITER + MonitoredObjectType.HTTP_SERVICE;
    }

    static String getJVMDottedName() {
        return DottedNameFactory.getInstanceName() + DELIMITER + MonitoredObjectType.JVM;
    }

    static String getHttpSvcVirtualServerDottedName(String vs) {
        vs = DottedName.escapePart((String)vs);
        return DottedNameFactory.getHttpServiceDottedName() + DELIMITER + vs;
    }

    static String getHttpListenerDottedName(String listenerName, String vs) {
        listenerName = DottedName.escapePart((String)listenerName);
        return DottedNameFactory.getHttpSvcVirtualServerDottedName(vs) + DELIMITER + listenerName;
    }

    static String getConnectionManagersDottedName() {
        return DottedNameFactory.getOrbDottedName() + DELIMITER + MonitoredObjectType.CONNECTION_MANAGERS;
    }

    static String getOrbConnectionManagerDottedName(String name) {
        name = DottedName.escapePart((String)name);
        return DottedNameFactory.getConnectionManagersDottedName() + DELIMITER + name;
    }

    static String getConnectionPoolDottedName(String poolName, String type) {
        poolName = DottedName.escapePart((String)poolName);
        return DottedNameFactory.getResourcesDottedName() + DELIMITER + poolName;
    }

    static String getStandAloneEJBModuleDottedName(String module) {
        module = DottedName.escapePart((String)module);
        return DottedNameFactory.getApplicationsDottedName() + DELIMITER + module;
    }

    static String getStandAloneWebModuleDottedName(String module) {
        module = DottedName.escapePart((String)module);
        return DottedNameFactory.getApplicationsDottedName() + DELIMITER + module;
    }

    static String getAppDottedName(String app) {
        app = DottedName.escapePart((String)app);
        return DottedNameFactory.getApplicationsDottedName() + DELIMITER + app;
    }

    static String getAppModuleDottedName(String app, String module) {
        module = DottedName.escapePart((String)module);
        return DottedNameFactory.getAppDottedName(app) + DELIMITER + module;
    }

    static String getWebAppsVirtualServerDottedName(String app, String module, String vs) {
        vs = DottedName.escapePart((String)vs);
        if (app == null) {
            return DottedNameFactory.getStandAloneWebModuleDottedName(module) + DELIMITER + vs;
        }
        return DottedNameFactory.getAppModuleDottedName(app, module) + DELIMITER + vs;
    }

    static String getServletDottedName(String app, String module, String vs, String servlet) {
        servlet = DottedName.escapePart((String)servlet);
        return DottedNameFactory.getWebAppsVirtualServerDottedName(app, module, vs) + DELIMITER + servlet;
    }

    static String getEJBDottedName(String app, String module, String ejb) {
        ejb = DottedName.escapePart((String)ejb);
        if (app == null) {
            return DottedNameFactory.getStandAloneEJBModuleDottedName(module) + DELIMITER + ejb;
        }
        return DottedNameFactory.getAppModuleDottedName(app, module) + DELIMITER + ejb;
    }

    static String getEJBDottedNameWithType(String app, String module, String ejb, String ejbType) {
        ejb = DottedName.escapePart((String)ejb);
        if (app == null) {
            return DottedNameFactory.getStandAloneEJBModuleDottedName(module) + DELIMITER + ejbType + DELIMITER + ejb;
        }
        return DottedNameFactory.getAppModuleDottedName(app, module) + DELIMITER + ejbType + DELIMITER + ejb;
    }

    static String getEJBCacheDottedName(String app, String module, String ejb) {
        return DottedNameFactory.getEJBDottedName(app, module, ejb) + DELIMITER + MonitoredObjectType.BEAN_CACHE;
    }

    static String getEJBPoolDottedName(String app, String module, String ejb) {
        return DottedNameFactory.getEJBDottedName(app, module, ejb) + DELIMITER + MonitoredObjectType.BEAN_POOL;
    }

    static String getEJBMethodsDottedName(String app, String module, String ejb) {
        return DottedNameFactory.getEJBDottedName(app, module, ejb) + DELIMITER + MonitoredObjectType.BEAN_METHODS;
    }

    static String getEJBMethodDottedName(String app, String module, String ejb, String method) {
        return DottedNameFactory.getEJBMethodsDottedName(app, module, ejb) + DELIMITER + DottedName.escapePart((String)method);
    }

    static String getConnectorServiceDottedName() {
        return DottedNameFactory.getInstanceName() + DELIMITER + MonitoredObjectType.CONNECTOR_SERVICE;
    }

    static String getJmsServiceDottedName() {
        return DottedNameFactory.getInstanceName() + DELIMITER + MonitoredObjectType.JMS_SERVICE;
    }

    static String getConnectorModuleDottedName(String j2eeAppName, String moduleName) {
        moduleName = j2eeAppName != null ? DottedName.escapePart((String)j2eeAppName) + "#" + DottedName.escapePart((String)moduleName) : DottedName.escapePart((String)moduleName);
        return DottedNameFactory.getConnectorServiceDottedName() + DELIMITER + moduleName;
    }

    static String getConnectorWorkMgmtDottedName(String j2eeAppName, String moduleName, boolean isJms) {
        String dottedName = null;
        dottedName = isJms ? DottedNameFactory.getJmsServiceDottedName() + DELIMITER + MonitoredObjectType.CONNECTOR_WORKMGMT : DottedNameFactory.getConnectorModuleDottedName(j2eeAppName, moduleName) + DELIMITER + MonitoredObjectType.CONNECTOR_WORKMGMT;
        return dottedName;
    }

    static String getConnectionFactoriesDottedName() {
        return DottedNameFactory.getJmsServiceDottedName() + DELIMITER + MonitoredObjectType.CONNECTION_FACTORIES;
    }

    static String getConnectionFactoryDottedName(String factoryName) {
        return DottedNameFactory.getConnectionFactoriesDottedName() + DELIMITER + DottedName.escapePart((String)factoryName);
    }

    static String getConnectionPoolsDottedName(String j2eeAppName, String moduleName) {
        return DottedNameFactory.getConnectorModuleDottedName(j2eeAppName, moduleName) + DELIMITER + MonitoredObjectType.CONNECTION_POOLS;
    }

    static String getConnectionPoolDottedName(String poolName, String j2eeAppName, String moduleName) {
        return DottedNameFactory.getConnectionPoolsDottedName(j2eeAppName, moduleName) + DELIMITER + DottedName.escapePart((String)poolName);
    }

    static String getConnectionQueueDottedName() {
        return DottedNameFactory.getHttpServiceDottedName() + DELIMITER + MonitoredObjectType.CONNECTION_QUEUE;
    }

    static String getDnsDottedName() {
        return DottedNameFactory.getHttpServiceDottedName() + DELIMITER + MonitoredObjectType.DNS;
    }

    static String getKeepAliveDottedName() {
        return DottedNameFactory.getHttpServiceDottedName() + DELIMITER + MonitoredObjectType.KEEP_ALIVE;
    }

    static String getPWCThreadPoolDottedName() {
        return DottedNameFactory.getHttpServiceDottedName() + DELIMITER + MonitoredObjectType.PWC_THREAD_POOL;
    }

    static String getFileCacheDottedName() {
        return DottedNameFactory.getHttpServiceDottedName() + DELIMITER + MonitoredObjectType.FILE_CACHE;
    }

    static String getRequestDottedName(String vsId) {
        return DottedNameFactory.getHttpSvcVirtualServerDottedName(vsId) + DELIMITER + MonitoredObjectType.REQUEST;
    }

    static String getStatefulSessionStoreDottedName(String ejbName, String moduleName, String j2eeAppName) {
        return DottedNameFactory.getEJBDottedName(j2eeAppName, moduleName, ejbName) + DELIMITER + MonitoredObjectType.SESSION_STORE;
    }

    static String getTimerDottedName(String ejbName, String moduleName, String j2eeAppName) {
        return DottedNameFactory.getEJBDottedName(j2eeAppName, moduleName, ejbName) + DELIMITER + MonitoredObjectType.TIMERS;
    }

    static String getJVMCompilationDottedName() {
        return DottedNameFactory.getJVMDottedName() + DELIMITER + MonitoredObjectType.JVM_COMPILATION;
    }

    static String getJVMClassLoadingDottedName() {
        return DottedNameFactory.getJVMDottedName() + DELIMITER + MonitoredObjectType.JVM_CLASSLOADING;
    }

    static String getJVMRuntimeDottedName() {
        return DottedNameFactory.getJVMDottedName() + DELIMITER + MonitoredObjectType.JVM_RUNTIME;
    }

    static String getJVMOSDottedName() {
        return DottedNameFactory.getJVMDottedName() + DELIMITER + MonitoredObjectType.JVM_OS;
    }

    static String getJVMGCSDottedName() {
        return DottedNameFactory.getJVMDottedName() + DELIMITER + MonitoredObjectType.JVM_GCS;
    }

    static String getJVMGCDottedName(String gcName) {
        return DottedNameFactory.getJVMGCSDottedName() + DELIMITER + DottedName.escapePart((String)gcName);
    }

    static String getJVMMemoryDottedName() {
        return DottedNameFactory.getJVMDottedName() + DELIMITER + MonitoredObjectType.JVM_MEMORY;
    }

    static String getJVMThreadDottedName() {
        return DottedNameFactory.getJVMDottedName() + DELIMITER + MonitoredObjectType.JVM_THREAD;
    }

    static String getJVMThreadInfoDottedName(String threadName) {
        return DottedNameFactory.getJVMThreadDottedName() + DELIMITER + DottedName.escapePart((String)threadName);
    }
}

