/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor;

import com.sun.enterprise.admin.monitor.BaseMonitorMBean;
import com.sun.enterprise.admin.monitor.MonitorCommand;
import com.sun.enterprise.admin.monitor.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.MonitoringHelper;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;

public class MonitorGetCommand
extends MonitorCommand {
    private static final int GET_ATTR = 2;
    private static final int GET_ALL_ATTR = 4;
    private static final int GET_ATTR_FOR_TYPE = 6;
    private static final int GET_ALL_ATTR_FOR_TYPE = 8;
    private String attrName;
    private static final String WILDCARD = "*";

    MonitorGetCommand(ObjectName mbeanName, String attrName) {
        this.objectName = mbeanName;
        this.attrName = attrName;
        this.actionCode = WILDCARD.equals(attrName) ? 4 : 2;
    }

    MonitorGetCommand(ObjectName mbeanName, MonitoredObjectType type, String attrName) {
        this.objectName = mbeanName;
        this.monitoredObjectType = type.getTypeName();
        this.attrName = attrName;
        this.actionCode = WILDCARD.equals(attrName) ? 8 : 6;
    }

    Object runCommand() throws InstanceNotFoundException, AttributeNotFoundException {
        BaseMonitorMBean mbean = MonitoringHelper.getMonitorMBean(this.objectName);
        MonitoredObjectType type = null;
        if (this.monitoredObjectType != null) {
            type = MonitoredObjectType.getMonitoredObjectType(this.monitoredObjectType);
        }
        ArrayList<BaseMonitorMBean> mbeanList = null;
        if (this.actionCode == 6 || this.actionCode == 8) {
            mbeanList = mbean.getChildList(type);
        } else {
            mbeanList = new ArrayList<BaseMonitorMBean>();
            mbeanList.add(mbean);
        }
        AttributeList result = new AttributeList();
        Iterator iter = mbeanList.iterator();
        while (iter.hasNext()) {
            BaseMonitorMBean bmb = (BaseMonitorMBean)iter.next();
            if (this.actionCode == 2 || this.actionCode == 6) {
                Object val = bmb.getAttribute(this.attrName);
                Attribute attr = null;
                attr = this.actionCode == 6 ? new Attribute(this.getQualifiedName(bmb, type, this.attrName), val) : new Attribute(this.attrName, val);
                result.add(attr);
                continue;
            }
            if (this.actionCode != 4 && this.actionCode != 8) continue;
            String[] attrNames = bmb.getAllAttributeNames();
            AttributeList attrList = bmb.getAttributes(attrNames);
            if (this.actionCode == 8) {
                AttributeList newAttrList = new AttributeList();
                int numAttr = attrList.size();
                for (int i = 0; i < numAttr; ++i) {
                    Attribute attr = (Attribute)attrList.get(i);
                    attr = new Attribute(this.getQualifiedName(bmb, type, attr.getName()), attr.getValue());
                    newAttrList.add(attr);
                }
                attrList = newAttrList;
            }
            result.addAll(attrList);
        }
        return result;
    }

    private String getQualifiedName(BaseMonitorMBean mbean, MonitoredObjectType type, String attrName) {
        StringBuffer fullName = new StringBuffer();
        fullName.append(mbean.getNodeType());
        if (!type.isSingleton()) {
            fullName.append("." + mbean.getNodeName());
        }
        fullName.append("." + attrName);
        return fullName.toString();
    }
}

