/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.jmx.remote.server;

import com.sun.enterprise.admin.jmx.remote.internal.Shifter;
import com.sun.enterprise.admin.jmx.remote.protocol.Version;
import com.sun.enterprise.admin.jmx.remote.server.ServerVersionMatcher;
import com.sun.enterprise.admin.jmx.remote.server.callers.MBeanServerConnectionMethodCaller;
import com.sun.enterprise.admin.jmx.remote.server.callers.MethodCallers;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.remote.message.MBeanServerRequestMessage;
import javax.management.remote.message.MBeanServerResponseMessage;
import javax.security.auth.Subject;

public class MBeanServerRequestHandler {
    private final Set callers = MethodCallers.callers(this.getMBeanServerConnection());
    private static final Logger logger;
    private static Version sv;
    private static final ServerVersionMatcher matcher;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MBeanServerRequestHandler() {
        logger.finer("Server Jmx Connector Version: " + sv.toString());
    }

    private MBeanServerConnection getMBeanServerConnection() {
        MBeanServerConnection mbsc = this.introspectMBS();
        if (mbsc != null) {
            return mbsc;
        }
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        MBeanServer systemMBS = servers.get(0);
        return systemMBS;
    }

    public MBeanServerResponseMessage handle(MBeanServerRequestMessage request0) {
        if (!$assertionsDisabled && request0.getParams().length < 1) {
            throw new AssertionError((Object)"Invalid Object Array");
        }
        MBeanServerResponseMessage response = null;
        Version cv = (Version)request0.getParams()[0];
        logger.finer("Client Version = " + cv.toString());
        if (!this.isCompatible(cv)) {
            response = this.incompatibleVersionMessage(request0);
            return response;
        }
        MBeanServerRequestMessage request = this.removeVersion(request0);
        boolean handled = false;
        Iterator iter = this.callers.iterator();
        while (iter.hasNext()) {
            MBeanServerConnectionMethodCaller caller = (MBeanServerConnectionMethodCaller)iter.next();
            if (!caller.canCall(request)) continue;
            response = caller.call(request);
            handled = true;
            break;
        }
        if (!$assertionsDisabled && !handled) {
            throw new AssertionError((Object)"The request is not handled -- catastrophe");
        }
        return response;
    }

    private MBeanServerConnection introspectMBS() {
        MBeanServerConnection mbsc = null;
        String FACTORY_CLASS = "com.sun.enterprise.admin.common.MBeanServerFactory";
        String FACTORY_METHOD = "getMBeanServer";
        try {
            logger.finer("Introspecting the MBeanServerConnection");
            Class<?> c = Class.forName("com.sun.enterprise.admin.common.MBeanServerFactory");
            Method m = c.getMethod("getMBeanServer", null);
            Object r = m.invoke(c, null);
            if (!$assertionsDisabled && !(r instanceof MBeanServer)) {
                throw new AssertionError((Object)"Reflection does not return the correct type");
            }
            mbsc = (MBeanServerConnection)r;
            logger.finer("Introspected the MBeanServerConnection successfully!!");
        }
        catch (Throwable t) {
            logger.throwing(this.getClass().getName(), "introspectMBS", t);
        }
        return mbsc;
    }

    private MBeanServerRequestMessage removeVersion(MBeanServerRequestMessage from) {
        int id = from.getMethodId();
        Subject s = from.getDelegationSubject();
        Shifter sh = new Shifter(from.getParams());
        sh.shiftLeft();
        Object[] np = sh.state();
        return new MBeanServerRequestMessage(id, np, s);
    }

    private boolean isCompatible(Version cv) {
        return matcher.match(cv, sv);
    }

    private MBeanServerResponseMessage incompatibleVersionMessage(MBeanServerRequestMessage r) {
        int id = r.getMethodId();
        boolean isException = true;
        Version cv = (Version)r.getParams()[0];
        Exception e = null;
        if (!$assertionsDisabled && this.isCompatible(cv)) {
            throw new AssertionError((Object)"No message for compatible versions");
        }
        if (!matcher.majorCompatible(cv, sv)) {
            e = this.majorVersionIncompatible(cv, sv);
        } else if (!matcher.minorCompatible(cv, sv)) {
            e = this.minorVersionIncompatible(cv, sv);
        } else if (!matcher.upgradeCompatible(cv, sv)) {
            e = this.upgradeIncompatible(cv, sv);
        }
        if (!$assertionsDisabled && e == null) {
            throw new AssertionError((Object)"Either minor/major version or upgrade data have to fail the match");
        }
        return new MBeanServerResponseMessage((long)id, (Object)e, true);
    }

    private Exception majorVersionIncompatible(Version cv, Version sv) {
        StringBuffer sb = new StringBuffer();
        sb.append("The major versions don't match: ").append("Client Major Version = " + cv.getMajorVersion()).append("Server Major Version = " + sv.getMajorVersion()).append(" Upgrade the software accordingly");
        return new RuntimeException(sb.toString());
    }

    private Exception minorVersionIncompatible(Version cv, Version sv) {
        StringBuffer sb = new StringBuffer();
        sb.append("The minor versions don't match: ").append("Client Minor Version = " + cv.getMinorVersion()).append("Server Minor Version = " + sv.getMinorVersion()).append(" Upgrade the software accordingly");
        return new RuntimeException(sb.toString());
    }

    private Exception upgradeIncompatible(Version cv, Version sv) {
        StringBuffer sb = new StringBuffer();
        sb.append("The upgrade data in versions does not match: ").append("Client Upgrade Data = " + cv.toString()).append("Server Upgrade Data = " + sv.toString()).append(" Upgrade the software accordingly");
        return new RuntimeException(sb.toString());
    }

    static {
        $assertionsDisabled = !MBeanServerRequestHandler.class.desiredAssertionStatus();
        logger = Logger.getLogger("com.sun.enterprise.admin.jmx.remote.finer.logger");
        try {
            sv = (Version)Class.forName("com.sun.enterprise.admin.jmx.remote.protocol.SunOneVersion").newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        matcher = ServerVersionMatcher.getMatcher();
    }
}

