/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.jmx.remote.internal;

import com.sun.enterprise.admin.jmx.remote.comm.ConnectionFactory;
import com.sun.enterprise.admin.jmx.remote.comm.HttpConnectorAddress;
import com.sun.enterprise.admin.jmx.remote.comm.IConnection;
import com.sun.enterprise.admin.jmx.remote.comm.MBeanServerMessageConductor;
import com.sun.enterprise.admin.jmx.remote.internal.MBeanServerConnectionExceptionThrower;
import com.sun.enterprise.admin.jmx.remote.internal.MBeanServerResponseActor;
import com.sun.enterprise.admin.jmx.remote.internal.Shifter;
import com.sun.enterprise.admin.jmx.remote.protocol.Version;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.message.MBeanServerResponseMessage;

public class RemoteMBeanServerConnection
implements MBeanServerConnection {
    private IConnection physicalConnection = null;
    private MBeanServerMessageConductor conductor = null;
    private HttpConnectorAddress ad = null;
    private static Version cv;
    private static final Object EMPTY;
    private static final Logger logger;

    public RemoteMBeanServerConnection(IConnection connectionToServer) {
    }

    public RemoteMBeanServerConnection(HttpConnectorAddress ad) throws Exception {
        this.ad = ad;
        this.connect();
        logger.finer("Connected to: Address = " + ad.getHost() + ":" + ad.getPort());
    }

    private void connect() throws IOException {
        this.physicalConnection = ConnectionFactory.createConnection(this.ad);
        this.conductor = new MBeanServerMessageConductor(this.physicalConnection);
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException, IOException {
        try {
            this.connect();
            MBeanServerResponseMessage response = this.conductor.invoke(1, this.toArray(objectName, null, notificationFilter, obj));
            MBeanServerResponseActor.voidOrThrow(response);
        }
        catch (Exception e) {
            MBeanServerConnectionExceptionThrower.addNotificationListenerObjectName(e);
        }
    }

    public void addNotificationListener(ObjectName objectName, ObjectName objectName1, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException, IOException {
        try {
            this.connect();
            MBeanServerResponseMessage response = this.conductor.invoke(2, this.toArray(objectName, objectName1, notificationFilter, obj));
            MBeanServerResponseActor.voidOrThrow(response);
        }
        catch (Exception e) {
            MBeanServerConnectionExceptionThrower.addNotificationListeners(e);
        }
    }

    public ObjectInstance createMBean(String str, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        try {
            this.connect();
            MBeanServerResponseMessage response = this.conductor.invoke(3, this.toArray(str, objectName));
            return (ObjectInstance)MBeanServerResponseActor.returnOrThrow(response);
        }
        catch (Exception e) {
            MBeanServerConnectionExceptionThrower.createMBean(e);
            return null;
        }
    }

    public ObjectInstance createMBean(String str, ObjectName objectName, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        try {
            this.connect();
            MBeanServerResponseMessage response = this.conductor.invoke(5, this.toArray(str, objectName, loaderName));
            return (ObjectInstance)MBeanServerResponseActor.returnOrThrow(response);
        }
        catch (Exception e) {
            MBeanServerConnectionExceptionThrower.createMBeanLoader(e);
            return null;
        }
    }

    public ObjectInstance createMBean(String str, ObjectName objectName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        try {
            this.connect();
            MBeanServerResponseMessage response = this.conductor.invoke(4, this.toArray(str, objectName, params, signature));
            return (ObjectInstance)MBeanServerResponseActor.returnOrThrow(response);
        }
        catch (Exception e) {
            MBeanServerConnectionExceptionThrower.createMBeanParams(e);
            return null;
        }
    }

    public ObjectInstance createMBean(String str, ObjectName objectName, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        try {
            this.connect();
            MBeanServerResponseMessage response = this.conductor.invoke(6, this.toArray(str, objectName, loaderName, params, signature));
            return (ObjectInstance)MBeanServerResponseActor.returnOrThrow(response);
        }
        catch (Exception e) {
            MBeanServerConnectionExceptionThrower.createMBeanLoaderParams(e);
            return null;
        }
    }

    public Object getAttribute(ObjectName objectName, String str) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        try {
            this.connect();
            MBeanServerResponseMessage response = this.conductor.invoke(7, this.toArray(objectName, str));
            return MBeanServerResponseActor.returnOrThrow(response);
        }
        catch (Exception e) {
            MBeanServerConnectionExceptionThrower.getAttribute(e);
            return null;
        }
    }

    public AttributeList getAttributes(ObjectName objectName, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        try {
            this.connect();
            MBeanServerResponseMessage response = this.conductor.invoke(8, this.toArray(objectName, attributes));
            return (AttributeList)MBeanServerResponseActor.returnOrThrow(response);
        }
        catch (Exception e) {
            MBeanServerConnectionExceptionThrower.getAttributes(e);
            return null;
        }
    }

    public String getDefaultDomain() throws IOException {
        try {
            this.connect();
            MBeanServerResponseMessage response = this.conductor.invoke(9, this.toArray(EMPTY));
            return (String)MBeanServerResponseActor.returnOrThrow(response);
        }
        catch (Exception e) {
            MBeanServerConnectionExceptionThrower.getDefaultDomain(e);
            return null;
        }
    }

    public String[] getDomains() throws IOException {
        try {
            this.connect();
            MBeanServerResponseMessage response = this.conductor.invoke(10, this.toArray(EMPTY));
            return (String[])MBeanServerResponseActor.returnOrThrow(response);
        }
        catch (Exception e) {
            MBeanServerConnectionExceptionThrower.getDomains(e);
            return null;
        }
    }

    public Integer getMBeanCount() throws IOException {
        try {
            this.connect();
            MBeanServerResponseMessage response = this.conductor.invoke(11, this.toArray(EMPTY));
            return (Integer)MBeanServerResponseActor.returnOrThrow(response);
        }
        catch (Exception e) {
            MBeanServerConnectionExceptionThrower.getMBeanCount(e);
            return null;
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        try {
            this.connect();
            MBeanServerResponseMessage response = this.conductor.invoke(12, this.toArray(objectName));
            return (MBeanInfo)MBeanServerResponseActor.returnOrThrow(response);
        }
        catch (Exception e) {
            MBeanServerConnectionExceptionThrower.getMBeanInfo(e);
            return null;
        }
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException, IOException {
        try {
            this.connect();
            MBeanServerResponseMessage response = this.conductor.invoke(13, this.toArray(objectName));
            return (ObjectInstance)MBeanServerResponseActor.returnOrThrow(response);
        }
        catch (Exception e) {
            MBeanServerConnectionExceptionThrower.getObjectInstance(e);
            return null;
        }
    }

    public Object invoke(ObjectName objectName, String methodName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        try {
            this.connect();
            MBeanServerResponseMessage response = this.conductor.invoke(14, this.toArray(objectName, methodName, params, signature));
            return MBeanServerResponseActor.returnOrThrow(response);
        }
        catch (Exception e) {
            MBeanServerConnectionExceptionThrower.invoke(e);
            return null;
        }
    }

    public boolean isInstanceOf(ObjectName objectName, String className) throws InstanceNotFoundException, IOException {
        try {
            this.connect();
            MBeanServerResponseMessage response = this.conductor.invoke(15, this.toArray(objectName, className));
            return (Boolean)MBeanServerResponseActor.returnOrThrow(response);
        }
        catch (Exception e) {
            MBeanServerConnectionExceptionThrower.isInstanceOf(e);
            return false;
        }
    }

    public boolean isRegistered(ObjectName objectName) throws IOException {
        try {
            this.connect();
            MBeanServerResponseMessage response = this.conductor.invoke(16, this.toArray(objectName));
            return (Boolean)MBeanServerResponseActor.returnOrThrow(response);
        }
        catch (Exception e) {
            MBeanServerConnectionExceptionThrower.isRegistered(e);
            return false;
        }
    }

    public Set queryMBeans(ObjectName objectName, QueryExp queryExp) throws IOException {
        try {
            this.connect();
            MBeanServerResponseMessage response = this.conductor.invoke(17, this.toArray(objectName, queryExp));
            return (Set)MBeanServerResponseActor.returnOrThrow(response);
        }
        catch (Exception e) {
            MBeanServerConnectionExceptionThrower.queryMBeans(e);
            return null;
        }
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) throws IOException {
        try {
            this.connect();
            MBeanServerResponseMessage response = this.conductor.invoke(18, this.toArray(objectName, queryExp));
            return (Set)MBeanServerResponseActor.returnOrThrow(response);
        }
        catch (Exception e) {
            MBeanServerConnectionExceptionThrower.queryNames(e);
            return null;
        }
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        try {
            this.connect();
            MBeanServerResponseMessage response = this.conductor.invoke(19, this.toArray(objectName, notificationListener));
            MBeanServerResponseActor.voidOrThrow(response);
        }
        catch (Exception e) {
            MBeanServerConnectionExceptionThrower.removeNotificationListener(e);
        }
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName1) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        try {
            this.connect();
            MBeanServerResponseMessage response = this.conductor.invoke(19, this.toArray(objectName, objectName1));
            MBeanServerResponseActor.voidOrThrow(response);
        }
        catch (Exception e) {
            MBeanServerConnectionExceptionThrower.removeNotificationListenerObjectName(e);
        }
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName1, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        try {
            this.connect();
            MBeanServerResponseMessage response = this.conductor.invoke(19, this.toArray(objectName, objectName1, notificationFilter, obj));
            MBeanServerResponseActor.voidOrThrow(response);
        }
        catch (Exception e) {
            MBeanServerConnectionExceptionThrower.removeNotificationListenerObjectNameFilterHandback(e);
        }
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        try {
            this.connect();
            MBeanServerResponseMessage response = this.conductor.invoke(19, this.toArray(objectName, notificationListener, notificationFilter, obj));
            MBeanServerResponseActor.voidOrThrow(response);
        }
        catch (Exception e) {
            MBeanServerConnectionExceptionThrower.removeNotificationListenerFilterHandback(e);
        }
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        try {
            this.connect();
            MBeanServerResponseMessage response = this.conductor.invoke(23, this.toArray(objectName, attribute));
            MBeanServerResponseActor.voidOrThrow(response);
        }
        catch (Exception e) {
            MBeanServerConnectionExceptionThrower.setAttribute(e);
        }
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList list) throws InstanceNotFoundException, ReflectionException, IOException {
        try {
            this.connect();
            MBeanServerResponseMessage response = this.conductor.invoke(24, this.toArray(objectName, list));
            return (AttributeList)MBeanServerResponseActor.returnOrThrow(response);
        }
        catch (Exception e) {
            MBeanServerConnectionExceptionThrower.setAttributes(e);
            return null;
        }
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        try {
            this.connect();
            MBeanServerResponseMessage response = this.conductor.invoke(25, this.toArray(objectName));
            MBeanServerResponseActor.voidOrThrow(response);
        }
        catch (Exception e) {
            MBeanServerConnectionExceptionThrower.unregisterMBean(e);
        }
    }

    private Object[] toArray(Object param1) {
        Shifter s = new Shifter(new Object[]{param1});
        s.shiftRight(cv);
        return s.state();
    }

    private Object[] toArray(Object param1, Object param2) {
        Shifter s = new Shifter(new Object[]{param1, param2});
        s.shiftRight(cv);
        return s.state();
    }

    private Object[] toArray(Object param1, Object param2, Object param3) {
        Shifter s = new Shifter(new Object[]{param1, param2, param3});
        s.shiftRight(cv);
        return s.state();
    }

    private Object[] toArray(Object param1, Object param2, Object param3, Object param4) {
        Shifter s = new Shifter(new Object[]{param1, param2, param3, param4});
        s.shiftRight(cv);
        return s.state();
    }

    private Object[] toArray(Object param1, Object param2, Object param3, Object param4, Object param5) {
        Shifter s = new Shifter(new Object[]{param1, param2, param3, param4, param5});
        s.shiftRight(cv);
        return s.state();
    }

    static {
        try {
            cv = (Version)Class.forName("com.sun.enterprise.admin.jmx.remote.protocol.SunOneVersion").newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        EMPTY = new String();
        logger = Logger.getLogger("com.sun.enterprise.admin.jmx.remote.finer.logger");
    }
}

