/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.jmx.remote.https;

import com.sun.enterprise.admin.jmx.remote.UrlConnector;
import com.sun.enterprise.admin.jmx.remote.https.SunOneBasicHostNameVerifier;
import com.sun.enterprise.admin.jmx.remote.https.SunOneBasicX509TrustManager;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Map;
import javax.management.remote.JMXServiceURL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpsUrlConnector
extends UrlConnector {
    private HostnameVerifier hv = null;
    private X509TrustManager tm = null;

    public HttpsUrlConnector(JMXServiceURL serviceUrl, Map environment) {
        super(serviceUrl, environment);
        this.hv = (HostnameVerifier)environment.get("HOSTNAME_VERIFIER_KEY");
        this.tm = (X509TrustManager)environment.get("TRUST_MANAGER_KEY");
        if (this.hv == null) {
            this.hv = new SunOneBasicHostNameVerifier(serviceUrl.getHost());
        }
        if (this.tm == null) {
            this.tm = new SunOneBasicX509TrustManager(serviceUrl);
        }
        this.initialize();
    }

    protected void validateJmxServiceUrl() throws RuntimeException {
    }

    protected void validateEnvironment() throws RuntimeException {
        super.validateEnvironment();
    }

    private void initialize() {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("SSLv3");
            TrustManager[] tms = new X509TrustManager[]{this.tm};
            sslContext.init(null, tms, new SecureRandom());
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        if (sslContext != null) {
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        }
        HttpsURLConnection.setDefaultHostnameVerifier(this.hv);
    }
}

