/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.jmx.remote.comm;

import com.sun.enterprise.admin.jmx.remote.comm.HttpConnectorAddress;
import com.sun.enterprise.admin.jmx.remote.comm.IConnection;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.net.UnknownHostException;

class ServletConnection
implements IConnection {
    static final String UNKNOWN_HOST = "Unknown host : ";
    static final String INVALID_HOST_PORT = "Unable to connect to admin-server.  Please check if the server is up and running and that the host and port provided are correct.";
    static final String UNAUTHORIZED_ACCESS = "Invalid user or password";
    private URLConnection mConnection = null;
    private ObjectOutputStream mObjectOutStream = null;
    private ObjectInputStream mObjectInStream = null;

    ServletConnection(HttpConnectorAddress a) throws IOException {
        try {
            this.mConnection = a.openConnection("/web1/remotejmx");
        }
        catch (IOException ioe) {
            this.handleException(ioe);
        }
    }

    public Object receive() throws IOException, ClassNotFoundException {
        Object value = null;
        try {
            this.mObjectInStream = new ObjectInputStream(new BufferedInputStream(this.mConnection.getInputStream()));
            value = this.mObjectInStream.readObject();
        }
        catch (IOException ioe) {
            this.handleException(ioe);
        }
        return value;
    }

    public void send(Serializable object) throws IOException {
        try {
            this.mObjectOutStream = new ObjectOutputStream(new BufferedOutputStream(this.mConnection.getOutputStream()));
            this.mObjectOutStream.writeObject(object);
            this.mObjectOutStream.flush();
        }
        catch (IOException ioe) {
            this.handleException(ioe);
        }
    }

    public void close() {
        try {
            this.mObjectInStream.close();
            this.mObjectOutStream.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void handleException(IOException e) throws IOException {
        int responseCode;
        IOException exception = null;
        exception = e instanceof UnknownHostException ? new UnknownHostException(UNKNOWN_HOST + e.getMessage()) : (e instanceof ConnectException ? new ConnectException(INVALID_HOST_PORT) : ((responseCode = ((HttpURLConnection)this.mConnection).getResponseCode()) == 401 ? new IOException(UNAUTHORIZED_ACCESS) : e));
        throw exception;
    }
}

