/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.misc;

import com.sun.appserv.management.util.misc.CompareUtil;
import com.sun.appserv.management.util.misc.SetUtil;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class MapUtil {
    private MapUtil() {
    }

    public static Object[] getKeyObjects(Map m) {
        return SetUtil.toArray(m.keySet());
    }

    public static String[] getKeyStrings(Map m) {
        return SetUtil.toStringArray(m.keySet());
    }

    public static Map newMap(String key, Object value) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put(key, value);
        return m;
    }

    public static Map newMap(Map m1, Map m2) {
        HashMap m = new HashMap();
        if (m1 != null) {
            m.putAll(m1);
        }
        if (m2 != null) {
            m.putAll(m2);
        }
        return m;
    }

    public static Map newMap(Object[] mappings) {
        if (mappings.length % 2 != 0) {
            throw new IllegalArgumentException("mappings must have even length");
        }
        HashMap<Object, Object> m = new HashMap<Object, Object>();
        for (int i = 0; i < mappings.length; i += 2) {
            m.put(mappings[i], mappings[i + 1]);
        }
        return m;
    }

    public static void removeAll(Map m, Set keys) {
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            m.remove(iter.next());
        }
    }

    public static void removeAll(Map m, String[] keys) {
        for (int i = 0; i < keys.length; ++i) {
            m.remove(keys[i]);
        }
    }

    public static boolean mapsEqual(Map m1, Map m2) {
        if (m1 == m2) {
            return true;
        }
        boolean equal = false;
        if (m1.size() == m2.size() && ((Object)m1.keySet()).equals(m2.keySet())) {
            equal = true;
            Iterator iter = m1.keySet().iterator();
            while (iter.hasNext()) {
                Object value2;
                Object key = iter.next();
                Object value1 = m1.get(key);
                if (CompareUtil.objectsEqual(value1, value2 = m2.get(key))) continue;
                equal = false;
                break;
            }
        }
        return equal;
    }

    public static Map newMapNoNullValues(Map m) {
        HashMap result = new HashMap();
        Iterator iter = m.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Object value = m.get(key);
            if (value == null) continue;
            result.put(key, value);
        }
        return result;
    }

    public static String toString(Map m) {
        return MapUtil.toString(m, ",");
    }

    public static String toString(Map m, String separator) {
        if (m == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        Iterator iter = m.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Object value = m.get(key);
            buf.append(key + "=" + SmartStringifier.toString(value) + separator);
        }
        if (buf.length() != 0) {
            buf.setLength(buf.length() - separator.length());
        }
        return buf.toString();
    }

    public static Set getNullValueKeys(Map m) {
        HashSet s = new HashSet();
        Iterator iter = m.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            if (m.get(key) != null) continue;
            s.add(key);
        }
        return s;
    }
}

