/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.misc;

import java.util.ArrayList;

public final class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static Throwable[] getCauses(Throwable start) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        boolean haveNonException = false;
        Throwable t = start;
        while (t != null) {
            Throwable temp;
            list.add(t);
            if (!(t instanceof Exception)) {
                haveNonException = true;
            }
            if ((temp = t.getCause()) == null) break;
            t = temp;
        }
        Throwable[] results = haveNonException ? new Throwable[list.size()] : new Exception[list.size()];
        list.toArray(results);
        return results;
    }

    public static Throwable getRootCause(Throwable e) {
        Throwable[] causes = ExceptionUtil.getCauses(e);
        return causes[causes.length - 1];
    }

    public static String getStackTrace(Throwable t) {
        StringBuffer buf = new StringBuffer();
        StackTraceElement[] elems = t.getStackTrace();
        for (int i = 0; i < elems.length; ++i) {
            buf.append(elems[i]);
            buf.append("\n");
        }
        return buf.toString();
    }
}

