/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.misc;

import com.sun.appserv.management.util.misc.CompareUtil;
import com.sun.appserv.management.util.stringifier.ArrayStringifier;
import java.util.AbstractList;

public final class CircularList
extends AbstractList {
    private final Object[] mObjects;
    private int mNumItems;
    private int mFirst;
    private OverflowHandler mOverflowHandler;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CircularList(int size) {
        if (size == 0) {
            throw new IllegalArgumentException("list must have at least one item");
        }
        this.mObjects = new Object[size];
        this.mFirst = 0;
        this.mNumItems = 0;
        this.mOverflowHandler = null;
    }

    public void setOverflowHandler(OverflowHandler handler) {
        this.mOverflowHandler = handler;
    }

    public OverflowHandler getOverflowHandler() {
        return this.mOverflowHandler;
    }

    public final int size() {
        return this.mNumItems;
    }

    public final int capacity() {
        return this.mObjects.length;
    }

    public final void clear() {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, (Object)null);
        }
        this.mNumItems = 0;
        ++this.modCount;
    }

    private final int getPhysicalIndex(int logicalIndex) {
        return (this.mFirst + logicalIndex) % this.capacity();
    }

    public final Object get(int i) {
        this.checkInBounds(i);
        return this.mObjects[this.getPhysicalIndex(i)];
    }

    public final Object set(int i, Object item) {
        this.checkInBounds(i);
        int physicalIndex = this.getPhysicalIndex(i);
        Object oldItem = this.mObjects[physicalIndex];
        this.mObjects[physicalIndex] = item;
        return oldItem;
    }

    protected void discardedObject(Object o) {
        if (this.mOverflowHandler != null) {
            this.mOverflowHandler.handleBufferOverflow(o);
        }
    }

    private final void store(int logicalIndex, Object item) {
        this.mObjects[this.getPhysicalIndex((int)logicalIndex)] = item;
    }

    public final boolean add(Object item) {
        int capacity = this.capacity();
        if (!$assertionsDisabled && this.mFirst >= capacity) {
            throw new AssertionError();
        }
        if (this.size() == capacity) {
            Object overwrittenObject = this.get(0);
            this.mFirst = (this.mFirst + 1) % capacity;
            this.store(capacity - 1, item);
            this.discardedObject(overwrittenObject);
        } else {
            this.store(this.mNumItems, item);
            ++this.mNumItems;
        }
        ++this.modCount;
        return true;
    }

    public final void add(int index, Object item) {
        if (index != this.mNumItems) {
            throw new UnsupportedOperationException("add not at end");
        }
        this.add(item);
    }

    public final Object remove(int i) {
        Object result = null;
        if (i == 0) {
            result = this.removeFirst();
        } else if (i == this.mNumItems - 1) {
            result = this.removeLast();
        } else {
            throw new UnsupportedOperationException();
        }
        ++this.modCount;
        return result;
    }

    private final void checkInBounds(int i) {
        if (i < 0 || i >= this.mNumItems) {
            throw new IndexOutOfBoundsException("" + i);
        }
    }

    public final Object removeFirst() {
        this.checkInBounds(0);
        Object result = this.get(0);
        --this.mNumItems;
        this.mFirst = (this.mFirst + 1) % this.capacity();
        return result;
    }

    public final Object removeLast() {
        this.checkInBounds(0);
        Object result = this.get(this.mNumItems - 1);
        --this.mNumItems;
        return result;
    }

    public boolean equals(Object rhsIn) {
        boolean equal = false;
        if (rhsIn == this) {
            equal = true;
        } else if (!(rhsIn instanceof CircularList)) {
            equal = false;
        } else {
            CircularList rhs = (CircularList)rhsIn;
            boolean bl = equal = this.capacity() == rhs.capacity() && this.size() == rhs.size();
            if (equal) {
                int size = this.size();
                for (int i = 0; i < this.size(); ++i) {
                    if (CompareUtil.objectsEqual(this.get(i), rhs.get(i))) continue;
                    equal = false;
                    break;
                }
            }
        }
        return equal;
    }

    public String toString() {
        return ArrayStringifier.stringify(this.toArray(), ", ");
    }

    static {
        $assertionsDisabled = !CircularList.class.desiredAssertionStatus();
    }

    public static interface OverflowHandler {
        public void handleBufferOverflow(Object var1);
    }
}

