/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.jmx;

import com.sun.appserv.management.util.jmx.AttributeNameMangler;
import com.sun.appserv.management.util.jmx.AttributeNameManglerImpl;
import com.sun.appserv.management.util.jmx.AttributeNameMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AttributeNameMapperImpl
implements AttributeNameMapper {
    final Map mDerivedToOriginal = new HashMap();
    final Map mOriginalToDerived = new HashMap();
    final Set mAllNames = new HashSet();
    final AttributeNameMangler mMangler;

    public AttributeNameMapperImpl() {
        this(null, null);
    }

    public AttributeNameMapperImpl(String[] originalNames) {
        this(originalNames, new AttributeNameManglerImpl(true, null));
    }

    public AttributeNameMapperImpl(AttributeNameMangler mangler) {
        this(null, mangler);
    }

    public AttributeNameMapperImpl(String[] originalNames, AttributeNameMangler mangler) {
        AttributeNameMangler attributeNameMangler = this.mMangler = mangler == null ? new AttributeNameManglerImpl(true, null) : mangler;
        if (originalNames != null) {
            this.deriveAll(originalNames);
        }
    }

    public void deriveAll(String[] originalNames) {
        HashSet<String> notRequired = new HashSet<String>();
        HashSet<String> required = new HashSet<String>();
        for (int i = 0; i < originalNames.length; ++i) {
            String originalName = originalNames[i];
            if (!this.requiresMapping(originalName)) {
                notRequired.add(originalName);
                continue;
            }
            required.add(originalName);
        }
        Iterator iter = notRequired.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            this.addMapping(name, name);
        }
        String[] names = required.toArray(required.toArray(new String[required.size()]));
        for (int i = 0; i < names.length; ++i) {
            String preferredDerivation;
            String originalName = names[i];
            String derivedName = preferredDerivation = this.originalToDerived(originalName);
            int id = 0;
            while (this.mAllNames.contains(derivedName) || required.contains(derivedName)) {
                derivedName = preferredDerivation + "_" + id;
                ++id;
            }
            this.addMapping(originalName, derivedName);
        }
    }

    public boolean derivedSameAsOriginal(String derivedName) {
        String original = this.derivedToOriginal(derivedName);
        boolean theSame = original != null && derivedName.equals(original);
        return theSame;
    }

    public void addMapping(String originalName, String derivedName) {
        this.mDerivedToOriginal.put(derivedName, originalName);
        this.mOriginalToDerived.put(originalName, derivedName);
        this.mAllNames.add(derivedName);
    }

    public void dontMap(String originalName) {
        this.addMapping(originalName, originalName);
    }

    public boolean requiresMapping(String originalName) {
        boolean requiresMapping = true;
        char firstChar = originalName.charAt(0);
        if (Character.isUpperCase(firstChar) && Character.isJavaIdentifierStart(firstChar)) {
            int length = originalName.length();
            requiresMapping = false;
            for (int i = 1; i < length; ++i) {
                if (Character.isJavaIdentifierPart(originalName.charAt(i))) continue;
                requiresMapping = true;
                break;
            }
        }
        return requiresMapping;
    }

    public String originalToDerived(String originalName) {
        String derivedName = (String)this.mOriginalToDerived.get(originalName);
        if (derivedName == null) {
            derivedName = this.mMangler.mangleAttributeName(originalName);
        }
        return derivedName;
    }

    public String derivedToOriginal(String derivedName) {
        String original = (String)this.mDerivedToOriginal.get(derivedName);
        if (original == null) {
            original = derivedName;
        }
        return original;
    }

    public Set getAttributeNames() {
        return this.mAllNames;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("AttributeNameMapperImpl mappings:\n");
        Iterator iter = this.getAttributeNames().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            buf.append(name);
            buf.append(" => ");
            buf.append(this.derivedToOriginal(name) + "\n");
        }
        return buf.toString();
    }
}

