/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.j2ee.statistics;

import com.sun.appserv.management.j2ee.statistics.MapStatistic;
import com.sun.appserv.management.util.j2ee.J2EEUtil;
import com.sun.appserv.management.util.misc.MapUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.j2ee.statistics.Statistic;

public class MapStatisticImpl
implements MapStatistic,
Serializable {
    static final long serialVersionUID = -5921306849633125922L;
    final Map mItems;

    public MapStatisticImpl(Map map) {
        this.mItems = new HashMap(map);
    }

    public MapStatisticImpl(Statistic statistic) {
        if (statistic instanceof MapStatistic) {
            this.mItems = new HashMap();
            this.mItems.putAll(((MapStatistic)statistic).asMap());
        } else {
            this.mItems = J2EEUtil.statisticToMap(statistic);
        }
    }

    public final long getlong(String name) {
        Object value = this.getValue(name);
        if (!(value instanceof Long)) {
            throw new IllegalArgumentException("MapStatisticImpl.getLong: expecting Long for " + name + ", got " + value + " of class " + value.getClass() + ", all values: " + this.toString());
        }
        return (Long)value;
    }

    public final int getint(String name) {
        return (Integer)this.getValue(name);
    }

    public final String getString(String name) {
        return (String)this.getValue(name);
    }

    public final Object getValue(String name) {
        Object value = this.mItems.get(name);
        if (value == null && !this.mItems.containsKey(name)) {
            throw new IllegalArgumentException(name);
        }
        return value;
    }

    public String getDescription() {
        return this.getString("Description");
    }

    public long getLastSampleTime() {
        return this.getlong("LastSampleTime");
    }

    public String getName() {
        return this.getString("Name");
    }

    public String setName(String newName) {
        if (newName == null || newName.length() == 0) {
            throw new IllegalArgumentException();
        }
        String oldName = this.getName();
        this.mItems.put("Name", newName);
        return oldName;
    }

    public long getStartTime() {
        return this.getlong("StartTime");
    }

    public String getUnit() {
        return this.getString("Unit");
    }

    public Set valueNames() {
        return Collections.unmodifiableSet(this.mItems.keySet());
    }

    public Map asMap() {
        return Collections.unmodifiableMap(this.mItems);
    }

    public String toString() {
        return MapUtil.toString(this.mItems);
    }

    public boolean equals(Object rhs) {
        boolean equals = false;
        if (rhs instanceof MapStatistic) {
            equals = MapUtil.mapsEqual(this.asMap(), ((MapStatistic)rhs).asMap());
        }
        return equals;
    }
}

