/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sun.appserv;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.optional.sun.appserv.LocalStringsManager;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipFileSet;

public class UpdateTask
extends Task {
    private static final boolean debug = false;
    private String file;
    private String sunonehome = null;
    private String domain = "domain1";
    private ArrayList fromFiles;
    private ArrayList toFiles;
    LocalStringsManager lsm = new LocalStringsManager();

    public void setFile(String file) {
        this.file = new File(file).getPath();
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    /*
     * WARNING - void declaration
     */
    public void execute() throws BuildException {
        if (this.file == null || this.file.equals("")) {
            throw new BuildException(this.lsm.getString("AttributeFileNoProvided"));
        }
        try {
            String deployedDir;
            if (this.sunonehome == null) {
                ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
                URL url = cl.getResource("org/apache/tools/ant/taskdefs/defaults.properties");
                String path = new File(url.getFile()).getPath();
                if (path.indexOf("file:") != -1) {
                    path = path.substring(5);
                }
                int jarIndex = path.indexOf("sun-appserv-ant.jar");
                this.sunonehome = path.substring(0, jarIndex - 5);
            }
            System.out.println(this.lsm.getString("UpdateMessage", new Object[]{this.file, this.sunonehome, this.domain}));
            Jar[] creatorTasks = this.findCreatorTasks(this.file);
            if (creatorTasks == null) {
                throw new BuildException(this.lsm.getString("UnableToCreateArchive", new Object[]{this.file}));
            }
            this.fromFiles = new ArrayList();
            this.toFiles = new ArrayList();
            String sep = File.separator;
            String appsDirName = this.sunonehome + sep + "domains" + sep + this.domain + sep + "applications";
            String appname = this.getAppNameFromFile(this.file);
            if (this.file.endsWith(".ear")) {
                String j2eeAppsDir = appsDirName + sep + "j2ee-apps";
                deployedDir = j2eeAppsDir + File.separator + appname;
                String[] moduleFiles = this.getModuleFiles(creatorTasks, this.file);
                for (int i = 0; i < moduleFiles.length; ++i) {
                    void var12_16;
                    String modDeployedDir;
                    String modFile = moduleFiles[i];
                    Jar[] modCreatorTasks = this.findCreatorTasks(modFile);
                    if (modCreatorTasks == null) {
                        System.err.println(this.lsm.getString("UnableToFindTask", new Object[]{modFile}));
                        continue;
                    }
                    String modName = this.getAppNameFromFile(modFile);
                    if (modFile.endsWith(".war")) {
                        modDeployedDir = deployedDir + sep + modName + "_war";
                    } else if (modFile.endsWith(".jar")) {
                        modDeployedDir = deployedDir + sep + modName + "_jar";
                    } else if (modFile.endsWith(".rar")) {
                        modDeployedDir = deployedDir + sep + modName + "_rar";
                    } else if (modFile.equals(this.file)) {
                        modDeployedDir = deployedDir;
                    } else {
                        System.err.println(this.lsm.getString("InvalidModule", new Object[]{modFile}));
                        continue;
                    }
                    this.updateModule(modCreatorTasks, (String)var12_16);
                }
            } else {
                String modulesDir = appsDirName + sep + "j2ee-modules";
                deployedDir = modulesDir + sep + appname;
                this.updateModule(creatorTasks, deployedDir);
            }
            if (this.fromFiles.size() > 0) {
                for (int i = 0; i < this.fromFiles.size(); ++i) {
                    this.copyFile((File)this.fromFiles.get(i), (File)this.toFiles.get(i));
                }
                File reload = new File(deployedDir, ".reload");
                if (!reload.createNewFile()) {
                    reload.setLastModified(System.currentTimeMillis());
                }
                System.out.println(this.lsm.getString("AplicationUpdated"));
            } else {
                System.out.println(this.lsm.getString("FilesUpdateToDate"));
            }
        }
        catch (Exception ex) {
            System.err.println(this.lsm.getString("UpdateError"));
            throw new BuildException((Throwable)ex);
        }
    }

    private String[] getModuleFiles(Jar[] earTasks, String earFile) throws BuildException {
        ArrayList filesets = this.getFilesets(earTasks);
        ArrayList<String> modules = new ArrayList<String>();
        for (int i = 0; i < filesets.size(); ++i) {
            FileSet fs = (FileSet)filesets.get(i);
            if (!fs.getDir(this.getProject()).exists()) continue;
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File fromDir = fs.getDir(this.getProject());
            String[] files = ds.getIncludedFiles();
            for (int j = 0; j < files.length; ++j) {
                String f = files[j];
                if (!f.endsWith(".jar") && !f.endsWith(".war") && !f.endsWith(".rar")) continue;
                modules.add(new File(fromDir, f).toString());
            }
        }
        modules.add(earFile);
        return modules.toArray(new String[modules.size()]);
    }

    private void updateModule(Jar[] creatorTasks, String deployedDir) throws BuildException {
        try {
            File deployedDirFile = new File(deployedDir);
            if (!deployedDirFile.exists()) {
                System.err.println(this.lsm.getString("ModuleDoesNotExist", new Object[]{this.file}));
                return;
            }
            ArrayList filesets = this.getFilesets(creatorTasks);
            for (int i = 0; i < filesets.size(); ++i) {
                FileSet fs = (FileSet)filesets.get(i);
                if (!fs.getDir(this.getProject()).exists()) continue;
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                File fromDir = fs.getDir(this.getProject());
                String[] srcFiles = ds.getIncludedFiles();
                String prefix = "";
                String fullpath = "";
                if (fs instanceof ZipFileSet) {
                    ZipFileSet zfs = (ZipFileSet)fs;
                    String tmpPrefix = zfs.getPrefix(this.getProject());
                    String tmpFullpath = zfs.getFullpath(this.getProject());
                    if (tmpPrefix != null && !tmpPrefix.equals("")) {
                        prefix = tmpPrefix;
                    } else if (tmpFullpath != null && !tmpFullpath.equals("")) {
                        fullpath = tmpFullpath;
                    }
                }
                if (this.file.endsWith(".ear")) {
                    if (!fullpath.equals("META-INF/application.xml") && !prefix.startsWith("META-INF")) continue;
                    this.compareAndCopy(fromDir, srcFiles, deployedDirFile, prefix, fullpath);
                    continue;
                }
                this.compareAndCopy(fromDir, srcFiles, deployedDirFile, prefix, fullpath);
            }
        }
        catch (Exception ex) {
            System.err.println(this.lsm.getString("UpdateError"));
            throw new BuildException((Throwable)ex);
        }
    }

    private String getAppNameFromFile(String file) {
        String appname = file.substring(0, file.length() - 4);
        if (appname.lastIndexOf(File.separator) != -1) {
            appname = appname.substring(appname.lastIndexOf(File.separator) + 1);
        }
        return appname;
    }

    private Jar[] findCreatorTasks(String file) throws IOException {
        Hashtable targets = this.project.getTargets();
        Enumeration e = targets.elements();
        ArrayList<Jar> creators = new ArrayList<Jar>();
        while (e.hasMoreElements()) {
            int i;
            Target t = (Target)e.nextElement();
            Task[] tasks = t.getTasks();
            for (i = 0; i < tasks.length; ++i) {
                if (!(tasks[i] instanceof UnknownElement)) continue;
                try {
                    tasks[i].maybeConfigure();
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            tasks = t.getTasks();
            for (i = 0; i < tasks.length; ++i) {
                if (!(tasks[i] instanceof Jar)) continue;
                Jar task = (Jar)tasks[i];
                try {
                    task.maybeConfigure();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (task.getDestFile() == null || !task.getDestFile().getCanonicalPath().equals(new File(file).getCanonicalPath())) continue;
                creators.add(task);
            }
        }
        if (creators.size() == 0) {
            return null;
        }
        return creators.toArray(new Jar[creators.size()]);
    }

    private ArrayList getFilesets(Jar[] tasks) throws BuildException {
        try {
            Class<?> zipClass = Class.forName("org.apache.tools.ant.taskdefs.Zip");
            Field filesetsField = zipClass.getDeclaredField("filesets");
            filesetsField.setAccessible(true);
            Field basedirField = zipClass.getDeclaredField("baseDir");
            basedirField.setAccessible(true);
            Class<?> mtClass = Class.forName("org.apache.tools.ant.taskdefs.MatchingTask");
            Field filesetField = mtClass.getDeclaredField("fileset");
            filesetField.setAccessible(true);
            ArrayList<FileSet> filesets = new ArrayList<FileSet>();
            for (int i = 0; i < tasks.length; ++i) {
                Vector fs = (Vector)filesetsField.get(tasks[i]);
                filesets.addAll(fs);
                FileSet implFileset = (FileSet)filesetField.get(tasks[i]);
                File baseDir = (File)basedirField.get(tasks[i]);
                if (implFileset == null || baseDir == null) continue;
                FileSet fileset = (FileSet)implFileset.clone();
                fileset.setDir(baseDir);
                filesets.add(fileset);
            }
            return filesets;
        }
        catch (Exception ex) {
            throw (BuildException)new BuildException().initCause((Throwable)ex);
        }
    }

    private void compareAndCopy(File fromDir, String[] srcFiles, File toDir, String prefix, String fullpath) {
        if (prefix != null && !prefix.equals("")) {
            toDir = new File(toDir, prefix);
        }
        for (int i = 0; i < srcFiles.length; ++i) {
            String srcFile = srcFiles[i];
            File from = new File(fromDir, srcFile);
            File to = fullpath != null && !fullpath.equals("") ? new File(toDir, fullpath) : new File(toDir, srcFile);
            if (from.lastModified() <= to.lastModified()) continue;
            this.fromFiles.add(from);
            this.toFiles.add(to);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyFile(File from, File to) throws BuildException {
        System.out.println("Copying file " + from + " to " + to);
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            try {
                if (!to.exists()) {
                    if (!to.getParentFile().exists()) {
                        to.getParentFile().mkdirs();
                    }
                    to.createNewFile();
                }
                in = new FileInputStream(from);
                out = new FileOutputStream(to);
                byte[] buffer = new byte[8192];
                int count = 0;
                while ((count = in.read(buffer, 0, buffer.length)) != -1) {
                    out.write(buffer, 0, count);
                }
                Object var8_8 = null;
            }
            catch (Exception ex) {
                throw new RuntimeException(this.lsm.getString("UnableToCopy", new Object[]{from}), ex);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (out != null) {
                    out.close();
                }
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex) {}
        if (out != null) {
            out.close();
        }
        if (in == null) return;
        in.close();
        return;
    }
}

